/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.CanonicalRowExpressionRewriter;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.CanonicalPartitioningScheme;
import com.facebook.presto.sql.planner.CanonicalPlanFragment;
import com.facebook.presto.sql.planner.CanonicalTableScanNode;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CanonicalPlanGenerator
extends InternalPlanVisitor<Optional<PlanNode>, Map<VariableReferenceExpression, VariableReferenceExpression>> {
    private final PlanNodeIdAllocator planNodeidAllocator = new PlanNodeIdAllocator();
    private final PlanVariableAllocator variableAllocator = new PlanVariableAllocator();

    public static Optional<CanonicalPlanFragment> generateCanonicalPlan(PlanNode root, PartitioningScheme partitioningScheme) {
        HashMap originalToNewVariableNames = new HashMap();
        Optional canonicalPlan = (Optional)root.accept((PlanVisitor)new CanonicalPlanGenerator(), originalToNewVariableNames);
        if (!originalToNewVariableNames.keySet().containsAll(partitioningScheme.getOutputLayout())) {
            return Optional.empty();
        }
        return canonicalPlan.map(planNode -> new CanonicalPlanFragment((PlanNode)planNode, CanonicalPartitioningScheme.getCanonicalPartitioningScheme(partitioningScheme, originalToNewVariableNames)));
    }

    public Optional<PlanNode> visitPlan(PlanNode node, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return Optional.empty();
    }

    public Optional<PlanNode> visitAggregation(AggregationNode node, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List aggregationReferences = (List)node.getAggregations().entrySet().stream().map(entry -> new AggregationReference(CanonicalPlanGenerator.getCanonicalAggregation((AggregationNode.Aggregation)entry.getValue(), context), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(aggregationReference -> aggregationReference.getAggregation().getCall().toString())).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (AggregationReference aggregationReference2 : aggregationReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable((RowExpression)aggregationReference2.getAggregation().getCall());
            context.put(aggregationReference2.getVariableReferenceExpression(), reference);
            aggregations.put((Object)reference, (Object)aggregationReference2.getAggregation());
        }
        return Optional.of(new AggregationNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (Map)aggregations.build(), CanonicalPlanGenerator.getCanonicalGroupingSetDescriptor(node.getGroupingSets(), context), (List)node.getPreGroupedVariables().stream().map(context::get).collect(ImmutableList.toImmutableList()), node.getStep(), node.getHashVariable().map(ignored -> this.variableAllocator.newHashVariable()), node.getGroupIdVariable().map(context::get)));
    }

    private static AggregationNode.Aggregation getCanonicalAggregation(AggregationNode.Aggregation aggregation, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new AggregationNode.Aggregation((CallExpression)CanonicalPlanGenerator.inlineAndCanonicalize(context, (RowExpression)aggregation.getCall()), aggregation.getFilter().map(filter -> CanonicalPlanGenerator.inlineAndCanonicalize(context, filter)), aggregation.getOrderBy().map(orderBy -> CanonicalPlanGenerator.getCanonicalOrderingScheme(orderBy, context)), aggregation.isDistinct(), aggregation.getMask().map(context::get));
    }

    private static OrderingScheme getCanonicalOrderingScheme(OrderingScheme orderingScheme, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new OrderingScheme((List)orderingScheme.getOrderBy().stream().map(orderBy -> new Ordering((VariableReferenceExpression)context.get(orderBy.getVariable()), orderBy.getSortOrder())).collect(ImmutableList.toImmutableList()));
    }

    private static AggregationNode.GroupingSetDescriptor getCanonicalGroupingSetDescriptor(AggregationNode.GroupingSetDescriptor groupingSetDescriptor, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new AggregationNode.GroupingSetDescriptor((List)groupingSetDescriptor.getGroupingKeys().stream().map(context::get).collect(ImmutableList.toImmutableList()), groupingSetDescriptor.getGroupingSetCount(), groupingSetDescriptor.getGlobalGroupingSets());
    }

    @Override
    public Optional<PlanNode> visitGroupId(GroupIdNode node, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        ImmutableMap.Builder groupingColumns = ImmutableMap.builder();
        for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> entry : node.getGroupingColumns().entrySet()) {
            VariableReferenceExpression variableReferenceExpression = context.get(entry.getValue());
            VariableReferenceExpression reference = this.variableAllocator.newVariable((RowExpression)variableReferenceExpression, "gid");
            context.put(entry.getKey(), reference);
            groupingColumns.put((Object)reference, (Object)variableReferenceExpression);
        }
        ImmutableList.Builder groupingSets = ImmutableList.builder();
        for (List<VariableReferenceExpression> list : node.getGroupingSets()) {
            groupingSets.add(list.stream().map(context::get).collect(ImmutableList.toImmutableList()));
        }
        VariableReferenceExpression variableReferenceExpression = this.variableAllocator.newVariable("groupid", (Type)IntegerType.INTEGER);
        context.put(node.getGroupIdVariable(), variableReferenceExpression);
        return Optional.of(new GroupIdNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (List<List<VariableReferenceExpression>>)groupingSets.build(), (Map<VariableReferenceExpression, VariableReferenceExpression>)groupingColumns.build(), (List)node.getAggregationArguments().stream().map(context::get).collect(ImmutableList.toImmutableList()), variableReferenceExpression));
    }

    @Override
    public Optional<PlanNode> visitUnnest(UnnestNode node, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        ImmutableMap.Builder newUnnestVariables = ImmutableMap.builder();
        for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariable : node.getUnnestVariables().entrySet()) {
            VariableReferenceExpression input = (VariableReferenceExpression)CanonicalPlanGenerator.inlineAndCanonicalize(context, (RowExpression)unnestVariable.getKey());
            ImmutableList.Builder newVariables = ImmutableList.builder();
            for (VariableReferenceExpression variable2 : unnestVariable.getValue()) {
                VariableReferenceExpression newVariable = this.variableAllocator.newVariable(Optional.empty(), "unnest_field", variable2.getType());
                context.put(variable2, newVariable);
                newVariables.add((Object)newVariable);
            }
            newUnnestVariables.put((Object)input, (Object)newVariables.build());
        }
        Optional<VariableReferenceExpression> ordinalityVariable = node.getOrdinalityVariable().map(variable -> {
            VariableReferenceExpression newVariable = this.variableAllocator.newVariable(Optional.empty(), "unnest_ordinality", variable.getType());
            context.put((VariableReferenceExpression)variable, newVariable);
            return newVariable;
        });
        return Optional.of(new UnnestNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (List)node.getReplicateVariables().stream().map(variable -> (VariableReferenceExpression)CanonicalPlanGenerator.inlineAndCanonicalize(context, (RowExpression)variable)).collect(ImmutableList.toImmutableList()), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)newUnnestVariables.build(), ordinalityVariable));
    }

    public Optional<PlanNode> visitProject(ProjectNode node, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List rowExpressionReferences = (List)node.getAssignments().entrySet().stream().map(entry -> new RowExpressionReference(CanonicalPlanGenerator.inlineAndCanonicalize(context, (RowExpression)entry.getValue()), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(rowExpressionReference -> rowExpressionReference.getRowExpression().toString())).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (RowExpressionReference rowExpressionReference2 : rowExpressionReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable(rowExpressionReference2.getRowExpression());
            context.put(rowExpressionReference2.getVariableReferenceExpression(), reference);
            assignments.put((Object)reference, (Object)rowExpressionReference2.getRowExpression());
        }
        return Optional.of(new ProjectNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), new Assignments((Map)assignments.build()), node.getLocality()));
    }

    public Optional<PlanNode> visitFilter(FilterNode node, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, context);
        return source.map(planNode -> new FilterNode(Optional.empty(), this.planNodeidAllocator.getNextId(), planNode, CanonicalPlanGenerator.inlineAndCanonicalize(context, node.getPredicate())));
    }

    public Optional<PlanNode> visitTableScan(TableScanNode node, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        List columnReferences = (List)node.getAssignments().entrySet().stream().map(entry -> new ColumnReference((ColumnHandle)entry.getValue(), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(columnReference -> columnReference.getColumnHandle().toString())).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder outputVariables = ImmutableList.builder();
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (ColumnReference columnReference2 : columnReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable(Optional.empty(), columnReference2.getColumnHandle().toString(), columnReference2.getVariableReferenceExpression().getType());
            context.put(columnReference2.getVariableReferenceExpression(), reference);
            outputVariables.add((Object)reference);
            assignments.put((Object)reference, (Object)columnReference2.getColumnHandle());
        }
        return Optional.of(new CanonicalTableScanNode(Optional.empty(), this.planNodeidAllocator.getNextId(), CanonicalTableScanNode.CanonicalTableHandle.getCanonicalTableHandle(node.getTable()), (List<VariableReferenceExpression>)outputVariables.build(), (Map<VariableReferenceExpression, ColumnHandle>)assignments.build()));
    }

    private static RowExpression inlineAndCanonicalize(Map<VariableReferenceExpression, VariableReferenceExpression> context, RowExpression expression) {
        return RowExpressionVariableInliner.inlineVariables(context::get, CanonicalRowExpressionRewriter.canonicalizeRowExpression((RowExpression)expression));
    }

    private static class ColumnReference {
        private final ColumnHandle columnHandle;
        private final VariableReferenceExpression variableReferenceExpression;

        public ColumnReference(ColumnHandle columnHandle, VariableReferenceExpression variableReferenceExpression) {
            this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public ColumnHandle getColumnHandle() {
            return this.columnHandle;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }

    private static class RowExpressionReference {
        private final RowExpression rowExpression;
        private final VariableReferenceExpression variableReferenceExpression;

        public RowExpressionReference(RowExpression rowExpression, VariableReferenceExpression variableReferenceExpression) {
            this.rowExpression = Objects.requireNonNull(rowExpression, "rowExpression is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public RowExpression getRowExpression() {
            return this.rowExpression;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }

    private static class AggregationReference {
        private final AggregationNode.Aggregation aggregation;
        private final VariableReferenceExpression variableReferenceExpression;

        public AggregationReference(AggregationNode.Aggregation aggregation, VariableReferenceExpression variableReferenceExpression) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public AggregationNode.Aggregation getAggregation() {
            return this.aggregation;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }
}

