/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StageId;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/v1/stage")
@RolesAllowed(value={"user"})
public class StageResource {
    private final QueryManager queryManager;

    @Inject
    public StageResource(QueryManager queryManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @DELETE
    @Path(value="{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        this.queryManager.cancelStage(stageId);
    }
}

