/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class KDistinct
extends SqlScalarFunction {
    public static final KDistinct K_DISTINCT = new KDistinct();
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(KDistinct.class, "createState", new Class[0]);

    private KDistinct() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"k_distinct"), FunctionKind.SCALAR, (List)ImmutableList.of(), (List)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature()), false));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.HIDDEN;
    }

    public boolean isDeterministic() {
        return false;
    }

    public String getDescription() {
        return "Returns true for the first K distinct hash values updating the state if it's not already in";
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.functionTypeArgumentProperty(BinaryFunctionInterface.class)), Reflection.methodHandle(KDistinct.class, "addKey", Object.class, Long.TYPE, Long.TYPE), Optional.of(Reflection.methodHandle(KDistinct.class, "createState", new Class[0])));
    }

    @UsedByGeneratedCode
    public static boolean addKey(Object state, long hash, long k) {
        State currentState = (State)state;
        if (currentState.longArraySet != null) {
            if ((long)currentState.longArraySet.size() == k) {
                return false;
            }
        } else {
            currentState.longArraySet = new LongArraySet(new long[(int)k]);
        }
        return currentState.longArraySet.add(hash);
    }

    @UsedByGeneratedCode
    public static Object createState() {
        return new State();
    }

    private static class State {
        public LongArraySet longArraySet;

        private State() {
        }
    }
}

