/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.util.Failures;

@ScalarFunction(value="array_normalize")
@Description(value="Normalizes an array by dividing each element by the p-norm of the array.")
public final class ArrayNormalizeFunction {
    private static final ValueAccessor DOUBLE_VALUE_ACCESSOR = new DoubleValueAccessor();
    private static final ValueAccessor REAL_VALUE_ACCESSOR = new RealValueAccessor();

    private ArrayNormalizeFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    @SqlNullable
    public static Block normalizeDoubleArray(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block, @SqlType(value="T") double p) {
        return ArrayNormalizeFunction.normalizeArray(elementType, block, p, DOUBLE_VALUE_ACCESSOR);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    @SqlNullable
    public static Block normalizeRealArray(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block, @SqlType(value="T") long p) {
        return ArrayNormalizeFunction.normalizeArray(elementType, block, Float.intBitsToFloat((int)p), REAL_VALUE_ACCESSOR);
    }

    private static Block normalizeArray(Type elementType, Block block, double p, ValueAccessor valueAccessor) {
        if (!(elementType instanceof RealType) && !(elementType instanceof DoubleType)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported array element type for array_normalize function: %s", elementType.getDisplayName()));
        }
        Failures.checkCondition(p >= 0.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "array_normalize only supports non-negative p: %s", p);
        if (p == 0.0) {
            return block;
        }
        int elementCount = block.getPositionCount();
        double pNorm = 0.0;
        for (int i = 0; i < elementCount; ++i) {
            if (block.isNull(i)) {
                return null;
            }
            pNorm += Math.pow(Math.abs(valueAccessor.getValue(elementType, block, i)), p);
        }
        if (pNorm == 0.0) {
            return block;
        }
        pNorm = Math.pow(pNorm, 1.0 / p);
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, elementCount);
        for (int i = 0; i < elementCount; ++i) {
            valueAccessor.writeValue(elementType, blockBuilder, valueAccessor.getValue(elementType, block, i) / pNorm);
        }
        return blockBuilder.build();
    }

    private static class RealValueAccessor
    implements ValueAccessor {
        private RealValueAccessor() {
        }

        @Override
        public double getValue(Type elementType, Block block, int position) {
            return Float.intBitsToFloat((int)elementType.getLong(block, position));
        }

        @Override
        public void writeValue(Type elementType, BlockBuilder blockBuilder, double value) {
            elementType.writeLong(blockBuilder, (long)Float.floatToIntBits((float)value));
        }
    }

    private static class DoubleValueAccessor
    implements ValueAccessor {
        private DoubleValueAccessor() {
        }

        @Override
        public double getValue(Type elementType, Block block, int position) {
            return elementType.getDouble(block, position);
        }

        @Override
        public void writeValue(Type elementType, BlockBuilder blockBuilder, double value) {
            elementType.writeDouble(blockBuilder, value);
        }
    }

    private static interface ValueAccessor {
        public double getValue(Type var1, Block var2, int var3);

        public void writeValue(Type var1, BlockBuilder var2, double var3);
    }
}

