/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import java.util.Optional;

@ScalarFunction(value="ngrams")
@Description(value="Return N-grams for the input")
public final class ArrayNgramsFunction {
    private ArrayNgramsFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="array(array(T))")
    public static Block ngrams(@SqlType(value="array(T)") Block array, @SqlType(value="integer") long n) {
        Failures.checkCondition(n > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "N must be positive", new Object[0]);
        int elementsPerRecord = StrictMath.toIntExact(Math.min((long)array.getPositionCount(), n));
        int totalRecords = array.getPositionCount() - elementsPerRecord + 1;
        int[] ids = new int[totalRecords * elementsPerRecord];
        int[] offset = new int[totalRecords + 1];
        for (int recordIndex = 0; recordIndex < totalRecords; ++recordIndex) {
            for (int elementIndex = 0; elementIndex < elementsPerRecord; ++elementIndex) {
                ids[recordIndex * elementsPerRecord + elementIndex] = recordIndex + elementIndex;
            }
            offset[recordIndex + 1] = (recordIndex + 1) * elementsPerRecord;
        }
        return ArrayBlock.fromElementBlock((int)totalRecords, Optional.empty(), (int[])offset, (Block)array.getPositions(ids, 0, totalRecords * elementsPerRecord));
    }
}

