/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.array.LongBigArray;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import io.airlift.slice.Slice;
import org.openjdk.jol.info.ClassLayout;

public class LongDecimalWithOverflowAndLongStateFactory
implements AccumulatorStateFactory<LongDecimalWithOverflowAndLongState> {
    public LongDecimalWithOverflowAndLongState createSingleState() {
        return new SingleLongDecimalWithOverflowAndLongState();
    }

    public Class<? extends LongDecimalWithOverflowAndLongState> getSingleStateClass() {
        return SingleLongDecimalWithOverflowAndLongState.class;
    }

    public LongDecimalWithOverflowAndLongState createGroupedState() {
        return new GroupedLongDecimalWithOverflowAndLongState();
    }

    public Class<? extends LongDecimalWithOverflowAndLongState> getGroupedStateClass() {
        return GroupedLongDecimalWithOverflowAndLongState.class;
    }

    public static class SingleLongDecimalWithOverflowAndLongState
    extends LongDecimalWithOverflowStateFactory.SingleLongDecimalWithOverflowState
    implements LongDecimalWithOverflowAndLongState {
        public static final int SIZE = ClassLayout.parseClass(Slice.class).instanceSize() + 16 + 16;
        protected long longValue;

        @Override
        public long getLong() {
            return this.longValue;
        }

        @Override
        public void setLong(long longValue) {
            this.longValue = longValue;
        }

        @Override
        public void addLong(long value) {
            this.longValue += value;
        }

        @Override
        public void incrementLong() {
            ++this.longValue;
        }

        @Override
        public long getEstimatedSize() {
            if (this.getLongDecimal() == null) {
                return 8L;
            }
            return SIZE;
        }
    }

    public static class GroupedLongDecimalWithOverflowAndLongState
    extends LongDecimalWithOverflowStateFactory.GroupedLongDecimalWithOverflowState
    implements LongDecimalWithOverflowAndLongState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedLongDecimalWithOverflowAndLongState.class).instanceSize();
        private final LongBigArray longs = new LongBigArray();

        @Override
        public void ensureCapacity(long size) {
            this.longs.ensureCapacity(size);
            super.ensureCapacity(size);
        }

        @Override
        public long getLong() {
            return this.longs.get(this.getGroupId());
        }

        @Override
        public void setLong(long value) {
            this.longs.set(this.getGroupId(), value);
        }

        @Override
        public void addLong(long value) {
            this.longs.add(this.getGroupId(), value);
        }

        @Override
        public void incrementLong() {
            this.longs.increment(this.getGroupId());
        }

        @Override
        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.unscaledDecimals.sizeOf() + this.numberOfElements * (long)SingleLongDecimalWithOverflowAndLongState.SIZE + (this.overflows == null ? 0L : this.overflows.sizeOf());
        }
    }
}

