/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentState;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.StreamSummary;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;

public class ApproximateMostFrequentStateFactory
implements AccumulatorStateFactory<ApproximateMostFrequentState> {
    public ApproximateMostFrequentState createSingleState() {
        return new SingleApproximateMostFrequentState();
    }

    public Class<? extends ApproximateMostFrequentState> getSingleStateClass() {
        return SingleApproximateMostFrequentState.class;
    }

    public ApproximateMostFrequentState createGroupedState() {
        return new GroupedApproximateMostFrequentState();
    }

    public Class<? extends ApproximateMostFrequentState> getGroupedStateClass() {
        return GroupedApproximateMostFrequentState.class;
    }

    public static class GroupedApproximateMostFrequentState
    extends AbstractGroupedAccumulatorState
    implements ApproximateMostFrequentState {
        private final ObjectBigArray<StreamSummary> streamSummaries = new ObjectBigArray();
        private long size;

        @Override
        public StreamSummary getStateSummary() {
            return (StreamSummary)this.streamSummaries.get(this.getGroupId());
        }

        @Override
        public void setStateSummary(StreamSummary histogram) {
            StreamSummary previous = this.getStateSummary();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.streamSummaries.set(this.getGroupId(), (Object)histogram);
            this.size += histogram.estimatedInMemorySize();
        }

        public void ensureCapacity(long size) {
            this.streamSummaries.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return this.size + this.streamSummaries.sizeOf();
        }
    }

    public static class SingleApproximateMostFrequentState
    implements ApproximateMostFrequentState {
        private StreamSummary streamSummary;
        private long size;

        @Override
        public StreamSummary getStateSummary() {
            return this.streamSummary;
        }

        @Override
        public void setStateSummary(StreamSummary histogram) {
            this.streamSummary = histogram;
            this.size = histogram.estimatedInMemorySize();
        }

        public long getEstimatedSize() {
            return this.size;
        }
    }
}

