/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.execution.scheduler.PartialResultQueryTaskTracker;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;

public class PartialResultQueryManager {
    private final AtomicReference<ScheduledExecutorService> executor = new AtomicReference();
    private final PriorityBlockingQueue<PartialResultQueryTaskTracker> queue = new PriorityBlockingQueue<PartialResultQueryTaskTracker>(1, Comparator.comparing(PartialResultQueryTaskTracker::getMaxEndTime));

    @Inject
    public PartialResultQueryManager() {
    }

    private void startExecutor() {
        if (this.executor.compareAndSet(null, Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"partial-result-query-manager-%s")))) {
            this.executor.get().scheduleWithFixedDelay(this::checkAndCancelTasks, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    public void addQueryTaskTracker(PartialResultQueryTaskTracker queryTaskTracker) {
        this.startExecutor();
        this.queue.add(queryTaskTracker);
    }

    public void checkAndCancelTasks() {
        long currentTime = System.nanoTime();
        while (!this.queue.isEmpty() && currentTime >= this.queue.peek().getMaxEndTime()) {
            PartialResultQueryTaskTracker queryTracker = this.queue.poll();
            queryTracker.cancelUnfinishedTasks();
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    @PreDestroy
    public void stop() {
        if (this.executor.get() != null) {
            this.executor.get().shutdownNow();
        }
    }
}

