/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionFunctionHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.sql.ParameterUtils;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class DropFunctionTask
implements DDLDefinitionTask<DropFunction> {
    private final SqlParser sqlParser;
    private final Set<SqlFunctionId> removedSessionFunctions = Sets.newConcurrentHashSet();

    @Inject
    public DropFunctionTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "DROP FUNCTION";
    }

    @Override
    public String explain(DropFunction statement, List<Expression> parameters) {
        return String.format("DROP %sFUNCTION %s", statement.isTemporary() ? "TEMPORARY " : "", statement.getFunctionName());
    }

    @Override
    public ListenableFuture<?> execute(DropFunction statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector) {
        Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
        Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, accessControl, Optional.empty(), parameters, parameterLookup, warningCollector);
        analyzer.analyze((Statement)statement);
        Optional<List<TypeSignature>> parameterTypes = statement.getParameterTypes().map(types -> (ImmutableList)types.stream().map(TypeSignature::parseTypeSignature).collect(ImmutableList.toImmutableList()));
        if (statement.isTemporary()) {
            this.removeSessionFunction(session, new SqlFunctionId(QualifiedObjectName.valueOf((CatalogSchemaName)SessionFunctionHandle.SESSION_NAMESPACE, (String)statement.getFunctionName().getSuffix()), parameterTypes.orElse(Collections.emptyList())), statement.isExists());
        } else {
            metadata.getFunctionAndTypeManager().dropFunction(FunctionAndTypeManager.qualifyObjectName(statement.getFunctionName()), parameterTypes, statement.isExists());
        }
        return Futures.immediateFuture(null);
    }

    private void removeSessionFunction(Session session, SqlFunctionId signature, boolean suppressNotFoundException) {
        Objects.requireNonNull(signature, "signature is null");
        if (!session.getSessionFunctions().containsKey(signature)) {
            if (!suppressNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Session function %s not found", signature.getFunctionName()));
            }
        } else {
            this.removedSessionFunctions.add(signature);
        }
    }

    @VisibleForTesting
    public Set<SqlFunctionId> getRemovedSessionFunctions() {
        return this.removedSessionFunctions;
    }
}

