/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.statistics.ExternalPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class HistoryBasedPlanStatisticsCalculator
implements StatsCalculator {
    private final Supplier<ExternalPlanStatisticsProvider> externalPlanStatisticsProvider;
    private final Metadata metadata;
    private final StatsCalculator delegate;

    public HistoryBasedPlanStatisticsCalculator(Supplier<ExternalPlanStatisticsProvider> externalPlanStatisticsProvider, Metadata metadata, StatsCalculator delegate) {
        this.externalPlanStatisticsProvider = Objects.requireNonNull(externalPlanStatisticsProvider, "externalPlanStatisticsProvider is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        return this.delegate.calculateStats(node, sourceStats, lookup, session, types).combineStats(this.getStatistics(node, session, types, lookup));
    }

    private PlanNode removeGroupReferences(PlanNode planNode, Lookup lookup) {
        if (planNode instanceof GroupReference) {
            return lookup.resolve(planNode);
        }
        List children = (List)planNode.getSources().stream().map(node -> this.removeGroupReferences((PlanNode)node, lookup)).collect(ImmutableList.toImmutableList());
        return planNode.replaceChildren(children);
    }

    private PlanStatistics getStatistics(PlanNode planNode, Session session, TypeProvider types, Lookup lookup) {
        planNode = this.removeGroupReferences(planNode, lookup);
        ExternalPlanStatisticsProvider externalStatisticsProvider = this.externalPlanStatisticsProvider.get();
        if (SystemSessionProperties.useExternalPlanStatisticsEnabled(session)) {
            return externalStatisticsProvider.getStats(planNode, node -> PlanPrinter.jsonLogicalPlan(node, types, this.metadata.getFunctionAndTypeManager(), StatsAndCosts.empty(), session), tableScanNode -> this.metadata.getTableStatistics(session, tableScanNode.getTable(), (List<ColumnHandle>)ImmutableList.copyOf(tableScanNode.getAssignments().values()), (Constraint<ColumnHandle>)new Constraint(tableScanNode.getCurrentConstraint())));
        }
        if (!SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled(session)) {
            return PlanStatistics.empty();
        }
        return PlanStatistics.empty();
    }
}

