/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.Session;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.metadata.InternalTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataListing;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.GrantInfo;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.RoleGrant;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InformationSchemaPageSourceProvider
implements ConnectorPageSourceProvider {
    private final Metadata metadata;
    private final AccessControl accessControl;

    public InformationSchemaPageSourceProvider(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, SplitContext splitContext) {
        InternalTable table = this.getInternalTable(session, split, columns);
        ArrayList<Integer> channels = new ArrayList<Integer>();
        for (ColumnHandle column : columns) {
            String columnName = ((InformationSchemaColumnHandle)column).getColumnName();
            int columnIndex = table.getColumnIndex(columnName);
            channels.add(columnIndex);
        }
        ImmutableList.Builder pages = ImmutableList.builder();
        for (Page page : table.getPages()) {
            Block[] blocks = new Block[channels.size()];
            for (int index = 0; index < blocks.length; ++index) {
                blocks[index] = page.getBlock(((Integer)channels.get(index)).intValue());
            }
            pages.add((Object)new Page(page.getPositionCount(), blocks));
        }
        return new FixedPageSource((Iterable)pages.build());
    }

    private InternalTable getInternalTable(ConnectorSession connectorSession, ConnectorSplit connectorSplit, List<ColumnHandle> columns) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        InformationSchemaSplit split = (InformationSchemaSplit)connectorSplit;
        Objects.requireNonNull(columns, "columns is null");
        InformationSchemaTableHandle handle = split.getTableHandle();
        Set<QualifiedTablePrefix> prefixes = split.getPrefixes();
        return this.getInformationSchemaTable(session, handle.getCatalogName(), handle.getSchemaTableName(), prefixes);
    }

    public InternalTable getInformationSchemaTable(Session session, String catalog, SchemaTableName table, Set<QualifiedTablePrefix> prefixes) {
        if (table.equals((Object)InformationSchemaMetadata.TABLE_COLUMNS)) {
            return this.buildColumns(session, prefixes);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_TABLES)) {
            return this.buildTables(session, prefixes);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_VIEWS)) {
            return this.buildViews(session, prefixes);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_SCHEMATA)) {
            return this.buildSchemata(session, catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_TABLE_PRIVILEGES)) {
            return this.buildTablePrivileges(session, prefixes);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_ROLES)) {
            return this.buildRoles(session, catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_APPLICABLE_ROLES)) {
            return this.buildApplicableRoles(session, catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_ENABLED_ROLES)) {
            return this.buildEnabledRoles(session, catalog);
        }
        throw new IllegalArgumentException(String.format("table does not exist: %s", table));
    }

    private InternalTable buildColumns(Session session, Set<QualifiedTablePrefix> prefixes) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_COLUMNS));
        for (QualifiedTablePrefix prefix : prefixes) {
            for (Map.Entry<SchemaTableName, List<ColumnMetadata>> entry : MetadataListing.listTableColumns(session, this.metadata, this.accessControl, prefix).entrySet()) {
                SchemaTableName tableName = entry.getKey();
                int ordinalPosition = 1;
                for (ColumnMetadata column : entry.getValue()) {
                    if (column.isHidden()) continue;
                    table.add(prefix.getCatalogName(), tableName.getSchemaName(), tableName.getTableName(), column.getName(), ordinalPosition, null, "YES", column.getType().getDisplayName(), column.getComment(), column.getExtraInfo());
                    ++ordinalPosition;
                }
            }
        }
        return table.build();
    }

    private InternalTable buildTables(Session session, Set<QualifiedTablePrefix> prefixes) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_TABLES));
        for (QualifiedTablePrefix prefix : prefixes) {
            Set<SchemaTableName> tables = MetadataListing.listTables(session, this.metadata, this.accessControl, prefix);
            Set<SchemaTableName> views = MetadataListing.listViews(session, this.metadata, this.accessControl, prefix);
            for (SchemaTableName name : Sets.union(tables, views)) {
                String type = views.contains(name) ? "VIEW" : "BASE TABLE";
                table.add(prefix.getCatalogName(), name.getSchemaName(), name.getTableName(), type);
            }
        }
        return table.build();
    }

    private InternalTable buildTablePrivileges(Session session, Set<QualifiedTablePrefix> prefixes) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_TABLE_PRIVILEGES));
        for (QualifiedTablePrefix prefix : prefixes) {
            ImmutableList grants = ImmutableList.copyOf(MetadataListing.listTablePrivileges(session, this.metadata, this.accessControl, prefix));
            for (GrantInfo grant : grants) {
                table.add(grant.getGrantor().map(PrestoPrincipal::getName).orElse(null), grant.getGrantor().map(principal -> principal.getType().toString()).orElse(null), grant.getGrantee().getName(), grant.getGrantee().getType().toString(), prefix.getCatalogName(), grant.getSchemaTableName().getSchemaName(), grant.getSchemaTableName().getTableName(), grant.getPrivilegeInfo().getPrivilege().name(), grant.getPrivilegeInfo().isGrantOption() ? "YES" : "NO", grant.getWithHierarchy().map(withHierarchy -> withHierarchy != false ? "YES" : "NO").orElse(null));
            }
        }
        return table.build();
    }

    private InternalTable buildViews(Session session, Set<QualifiedTablePrefix> prefixes) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_VIEWS));
        for (QualifiedTablePrefix prefix : prefixes) {
            for (Map.Entry<QualifiedObjectName, ViewDefinition> entry : this.metadata.getViews(session, prefix).entrySet()) {
                table.add(entry.getKey().getCatalogName(), entry.getKey().getSchemaName(), entry.getKey().getObjectName(), entry.getValue().getOwner().orElse(null), entry.getValue().getOriginalSql());
            }
        }
        return table.build();
    }

    private InternalTable buildSchemata(Session session, String catalogName) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_SCHEMATA));
        for (String schema : MetadataListing.listSchemas(session, this.metadata, this.accessControl, catalogName)) {
            table.add(catalogName, schema);
        }
        return table.build();
    }

    private InternalTable buildRoles(Session session, String catalog) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_ROLES));
        try {
            this.accessControl.checkCanShowRoles(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), catalog);
        }
        catch (AccessDeniedException exception) {
            return table.build();
        }
        for (String role : this.metadata.listRoles(session, catalog)) {
            table.add(role);
        }
        return table.build();
    }

    private InternalTable buildApplicableRoles(Session session, String catalog) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_APPLICABLE_ROLES));
        for (RoleGrant grant : this.metadata.listApplicableRoles(session, new PrestoPrincipal(PrincipalType.USER, session.getUser()), catalog)) {
            PrestoPrincipal grantee = grant.getGrantee();
            table.add(grantee.getName(), grantee.getType().toString(), grant.getRoleName(), grant.isGrantable() ? "YES" : "NO");
        }
        return table.build();
    }

    private InternalTable buildEnabledRoles(Session session, String catalog) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_ENABLED_ROLES));
        for (String role : this.metadata.listEnabledRoles(session, catalog)) {
            table.add(role);
        }
        return table.build();
    }
}

