/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorMetadataUpdateHandle;
import com.facebook.presto.spi.ConnectorTypeSerde;
import com.facebook.presto.spi.connector.ConnectorTypeSerdeProvider;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectorTypeSerdeManager {
    private final Map<ConnectorId, ConnectorTypeSerdeProvider> connectorTypeSerdeProviderMap = new ConcurrentHashMap<ConnectorId, ConnectorTypeSerdeProvider>();

    @Inject
    public ConnectorTypeSerdeManager() {
    }

    public void addConnectorTypeSerdeProvider(ConnectorId connectorId, ConnectorTypeSerdeProvider connectorTypeSerdeProvider) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(connectorTypeSerdeProvider, "connectorTypeSerdeProvider is null");
        Preconditions.checkArgument((this.connectorTypeSerdeProviderMap.putIfAbsent(connectorId, connectorTypeSerdeProvider) == null ? 1 : 0) != 0, (String)"ConnectorMetadataUpdateHandleSerdeProvider for connector '%s' is already registered", (Object)connectorId);
    }

    public void removeConnectorTypeSerdeProvider(ConnectorId connectorId) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        this.connectorTypeSerdeProviderMap.remove(connectorId);
    }

    public Optional<ConnectorTypeSerde<ConnectorMetadataUpdateHandle>> getMetadataUpdateHandleSerde(ConnectorId connectorId) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        return Optional.ofNullable(this.connectorTypeSerdeProviderMap.get(connectorId)).map(ConnectorTypeSerdeProvider::getConnectorMetadataUpdateHandleSerde);
    }
}

