/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.Int128ArrayBlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.AbstractPrimitiveType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.TypeSignature;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.UUID;

public class UuidType
extends AbstractPrimitiveType
implements FixedWidthType {
    public static final UuidType UUID = new UuidType();

    private UuidType() {
        super(TypeSignature.parseTypeSignature((String)"uuid"), Slice.class);
    }

    public int getFixedSize() {
        return 16;
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isOrderable() {
        return true;
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return leftBlock.getLong(leftPosition, 8) == rightBlock.getLong(rightPosition, 8) && leftBlock.getLong(leftPosition, 0) == rightBlock.getLong(rightPosition, 0);
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int compare = Long.compare(leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 8));
        if (compare != 0) {
            return compare;
        }
        return Long.compare(leftBlock.getLong(leftPosition, 0), rightBlock.getLong(rightPosition, 0));
    }

    public long hash(Block block, int position) {
        return XxHash64.hash((Slice)this.getSlice(block, position));
    }

    public Object getObjectValue(SqlFunctionProperties sqlFunctionProperties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new UUID(block.getLong(position, 0), block.getLong(position, 8)).toString();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0));
            blockBuilder.writeLong(block.getLong(position, 8));
            blockBuilder.closeEntry();
        }
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length != 16) {
            throw new IllegalStateException("Expected entry size to be exactly 16 but was " + length);
        }
        blockBuilder.writeLong(value.getLong(offset));
        blockBuilder.writeLong(value.getLong(offset + 8));
        blockBuilder.closeEntry();
    }

    public final Slice getSlice(Block block, int position) {
        return Slices.wrappedLongArray((long[])new long[]{block.getLong(position, 0), block.getLong(position, 8)});
    }

    public static Slice javaUuidToPrestoUuid(UUID uuid) {
        return Slices.wrappedLongArray((long[])new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()});
    }

    public static UUID prestoUuidToJavaUuid(Slice uuid) {
        if (uuid.length() != 16) {
            throw new IllegalStateException(String.format("Expected value to be exactly %d bytes but was %d", 16, uuid.length()));
        }
        return new UUID(uuid.getLong(0), uuid.getLong(8));
    }
}

