/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OffsetNode
extends InternalPlanNode {
    private final PlanNode source;
    private final long count;

    @JsonCreator
    public OffsetNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count) {
        super(sourceLocation, id);
        Objects.requireNonNull(source, "source is null");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count must be greater than or equal to zero");
        this.source = source;
        this.count = count;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public long getCount() {
        return this.count;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitOffset(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new OffsetNode(this.getSourceLocation(), this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.count);
    }
}

