/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.optimizations.SymbolMapper;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PlanNodeDecorrelator {
    private final PlanNodeIdAllocator idAllocator;
    private final PlanVariableAllocator variableAllocator;
    private final Lookup lookup;

    public PlanNodeDecorrelator(PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, Lookup lookup) {
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.lookup = Objects.requireNonNull(lookup, "lookup is null");
    }

    public Optional<DecorrelatedNode> decorrelateFilters(PlanNode node, List<VariableReferenceExpression> correlation) {
        Optional decorrelationResultOptional = (Optional)this.lookup.resolve(node).accept((PlanVisitor)new DecorrelatingVisitor(correlation), null);
        return decorrelationResultOptional.flatMap(decorrelationResult -> this.decorrelatedNode(decorrelationResult.correlatedPredicates, decorrelationResult.node, correlation));
    }

    private Optional<DecorrelatedNode> decorrelatedNode(List<Expression> correlatedPredicates, PlanNode node, List<VariableReferenceExpression> correlation) {
        if (this.containsCorrelation(node, correlation)) {
            return Optional.empty();
        }
        return Optional.of(new DecorrelatedNode(correlatedPredicates, node));
    }

    private boolean containsCorrelation(PlanNode node, List<VariableReferenceExpression> correlation) {
        return Sets.union(VariablesExtractor.extractUnique(node, this.lookup, this.variableAllocator.getTypes()), VariablesExtractor.extractOutputVariables(node, this.lookup)).stream().anyMatch(correlation::contains);
    }

    public static class DecorrelatedNode {
        private final List<Expression> correlatedPredicates;
        private final PlanNode node;

        public DecorrelatedNode(List<Expression> correlatedPredicates, PlanNode node) {
            Objects.requireNonNull(correlatedPredicates, "correlatedPredicates is null");
            this.correlatedPredicates = ImmutableList.copyOf(correlatedPredicates);
            this.node = Objects.requireNonNull(node, "node is null");
        }

        public Optional<Expression> getCorrelatedPredicates() {
            if (this.correlatedPredicates.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(ExpressionUtils.and(this.correlatedPredicates));
        }

        public PlanNode getNode() {
            return this.node;
        }
    }

    private static class DecorrelationResult {
        final PlanNode node;
        final Set<VariableReferenceExpression> variablesToPropagate;
        final List<Expression> correlatedPredicates;
        final Multimap<VariableReferenceExpression, VariableReferenceExpression> correlatedVariablesMapping;
        final boolean atMostSingleRow;

        DecorrelationResult(PlanNode node, Set<VariableReferenceExpression> variablesToPropagate, List<Expression> correlatedPredicates, Multimap<VariableReferenceExpression, VariableReferenceExpression> correlatedVariablesMapping, boolean atMostSingleRow) {
            this.node = node;
            this.variablesToPropagate = variablesToPropagate;
            this.correlatedPredicates = correlatedPredicates;
            this.atMostSingleRow = atMostSingleRow;
            this.correlatedVariablesMapping = correlatedVariablesMapping;
            Preconditions.checkState((boolean)variablesToPropagate.containsAll(correlatedVariablesMapping.values()), (Object)"Expected symbols to propagate to contain all constant symbols");
        }

        SymbolMapper getCorrelatedSymbolMapper() {
            SymbolMapper.Builder builder = SymbolMapper.builder();
            this.correlatedVariablesMapping.forEach(builder::put);
            return builder.build();
        }

        Set<VariableReferenceExpression> getConstantVariables() {
            return ImmutableSet.copyOf((Collection)this.correlatedVariablesMapping.values());
        }
    }

    private class DecorrelatingVisitor
    extends InternalPlanVisitor<Optional<DecorrelationResult>, Void> {
        final List<VariableReferenceExpression> correlation;

        DecorrelatingVisitor(List<VariableReferenceExpression> correlation) {
            this.correlation = Objects.requireNonNull(correlation, "correlation is null");
        }

        public Optional<DecorrelationResult> visitPlan(PlanNode node, Void context) {
            return Optional.of(new DecorrelationResult(node, (Set<VariableReferenceExpression>)ImmutableSet.of(), (List<Expression>)ImmutableList.of(), (Multimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableMultimap.of(), false));
        }

        public Optional<DecorrelationResult> visitFilter(FilterNode node, Void context) {
            Optional childDecorrelationResultOptional = Optional.of(new DecorrelationResult(node.getSource(), (Set<VariableReferenceExpression>)ImmutableSet.of(), (List<Expression>)ImmutableList.of(), (Multimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableMultimap.of(), false));
            if (PlanNodeDecorrelator.this.containsCorrelation(node.getSource(), this.correlation)) {
                childDecorrelationResultOptional = (Optional)PlanNodeDecorrelator.this.lookup.resolve(node.getSource()).accept((PlanVisitor)this, null);
            }
            if (!childDecorrelationResultOptional.isPresent()) {
                return Optional.empty();
            }
            Expression predicate = OriginalExpressionUtils.castToExpression(node.getPredicate());
            Map<Boolean, List<Expression>> predicates = ExpressionUtils.extractConjuncts(predicate).stream().collect(Collectors.partitioningBy(this::isCorrelated));
            ImmutableList correlatedPredicates = ImmutableList.copyOf((Collection)predicates.get(true));
            ImmutableList uncorrelatedPredicates = ImmutableList.copyOf((Collection)predicates.get(false));
            DecorrelationResult childDecorrelationResult = (DecorrelationResult)childDecorrelationResultOptional.get();
            FilterNode newFilterNode = new FilterNode(node.getSourceLocation(), PlanNodeDecorrelator.this.idAllocator.getNextId(), childDecorrelationResult.node, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts((Collection<Expression>)uncorrelatedPredicates)));
            Sets.SetView variablesToPropagate = Sets.difference(VariablesExtractor.extractUnique((Iterable<? extends Expression>)correlatedPredicates, PlanNodeDecorrelator.this.variableAllocator.getTypes()), (Set)ImmutableSet.copyOf(this.correlation));
            return Optional.of(new DecorrelationResult((PlanNode)newFilterNode, (Set<VariableReferenceExpression>)Sets.union(childDecorrelationResult.variablesToPropagate, (Set)variablesToPropagate), (List<Expression>)ImmutableList.builder().addAll(childDecorrelationResult.correlatedPredicates).addAll((Iterable)correlatedPredicates).build(), (Multimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableMultimap.builder().putAll(childDecorrelationResult.correlatedVariablesMapping).putAll(this.extractCorrelatedSymbolsMapping((List<Expression>)correlatedPredicates)).build(), childDecorrelationResult.atMostSingleRow));
        }

        public Optional<DecorrelationResult> visitLimit(LimitNode node, Void context) {
            Optional childDecorrelationResultOptional = (Optional)PlanNodeDecorrelator.this.lookup.resolve(node.getSource()).accept((PlanVisitor)this, null);
            if (!childDecorrelationResultOptional.isPresent() || node.getCount() == 0L) {
                return Optional.empty();
            }
            DecorrelationResult childDecorrelationResult = (DecorrelationResult)childDecorrelationResultOptional.get();
            if (childDecorrelationResult.atMostSingleRow) {
                return childDecorrelationResultOptional;
            }
            if (node.getCount() != 1L) {
                return Optional.empty();
            }
            Set<VariableReferenceExpression> constantVariables = childDecorrelationResult.getConstantVariables();
            PlanNode decorrelatedChildNode = childDecorrelationResult.node;
            if (constantVariables.isEmpty() || !constantVariables.containsAll(decorrelatedChildNode.getOutputVariables())) {
                return Optional.empty();
            }
            AggregationNode aggregationNode = new AggregationNode(decorrelatedChildNode.getSourceLocation(), PlanNodeDecorrelator.this.idAllocator.getNextId(), decorrelatedChildNode, (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)decorrelatedChildNode.getOutputVariables()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
            return Optional.of(new DecorrelationResult((PlanNode)aggregationNode, childDecorrelationResult.variablesToPropagate, childDecorrelationResult.correlatedPredicates, childDecorrelationResult.correlatedVariablesMapping, true));
        }

        @Override
        public Optional<DecorrelationResult> visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            Optional childDecorrelationResultOptional = (Optional)PlanNodeDecorrelator.this.lookup.resolve(node.getSource()).accept((PlanVisitor)this, null);
            return childDecorrelationResultOptional.filter(result -> result.atMostSingleRow);
        }

        public Optional<DecorrelationResult> visitAggregation(AggregationNode node, Void context) {
            if (node.hasEmptyGroupingSet()) {
                return Optional.empty();
            }
            Optional childDecorrelationResultOptional = (Optional)PlanNodeDecorrelator.this.lookup.resolve(node.getSource()).accept((PlanVisitor)this, null);
            if (!childDecorrelationResultOptional.isPresent()) {
                return Optional.empty();
            }
            DecorrelationResult childDecorrelationResult = (DecorrelationResult)childDecorrelationResultOptional.get();
            Set<VariableReferenceExpression> constantVariables = childDecorrelationResult.getConstantVariables();
            AggregationNode decorrelatedAggregation = childDecorrelationResult.getCorrelatedSymbolMapper().map(node, childDecorrelationResult.node);
            ImmutableSet groupingKeys = ImmutableSet.copyOf((Collection)node.getGroupingKeys());
            List variablesToAdd = (List)childDecorrelationResult.variablesToPropagate.stream().filter(arg_0 -> DecorrelatingVisitor.lambda$visitAggregation$1((Set)groupingKeys, arg_0)).collect(ImmutableList.toImmutableList());
            if (!constantVariables.containsAll(variablesToAdd)) {
                return Optional.empty();
            }
            AggregationNode newAggregation = new AggregationNode(decorrelatedAggregation.getSourceLocation(), decorrelatedAggregation.getId(), decorrelatedAggregation.getSource(), decorrelatedAggregation.getAggregations(), AggregationNode.singleGroupingSet((List)ImmutableList.builder().addAll((Iterable)node.getGroupingKeys()).addAll((Iterable)variablesToAdd).build()), (List)ImmutableList.of(), decorrelatedAggregation.getStep(), decorrelatedAggregation.getHashVariable(), decorrelatedAggregation.getGroupIdVariable());
            boolean atMostSingleRow = newAggregation.getGroupingSetCount() == 1 && constantVariables.containsAll(newAggregation.getGroupingKeys());
            return Optional.of(new DecorrelationResult((PlanNode)newAggregation, childDecorrelationResult.variablesToPropagate, childDecorrelationResult.correlatedPredicates, childDecorrelationResult.correlatedVariablesMapping, atMostSingleRow));
        }

        public Optional<DecorrelationResult> visitProject(ProjectNode node, Void context) {
            Optional childDecorrelationResultOptional = (Optional)PlanNodeDecorrelator.this.lookup.resolve(node.getSource()).accept((PlanVisitor)this, null);
            if (!childDecorrelationResultOptional.isPresent()) {
                return Optional.empty();
            }
            DecorrelationResult childDecorrelationResult = (DecorrelationResult)childDecorrelationResultOptional.get();
            ImmutableSet nodeOutputVariables = ImmutableSet.copyOf((Collection)node.getOutputVariables());
            List variablesToAdd = (List)childDecorrelationResult.variablesToPropagate.stream().filter(arg_0 -> DecorrelatingVisitor.lambda$visitProject$2((Set)nodeOutputVariables, arg_0)).collect(ImmutableList.toImmutableList());
            Assignments assignments = Assignments.builder().putAll(node.getAssignments()).putAll(AssignmentUtils.identitiesAsSymbolReferences(variablesToAdd)).build();
            return Optional.of(new DecorrelationResult((PlanNode)new ProjectNode(PlanNodeDecorrelator.this.idAllocator.getNextId(), childDecorrelationResult.node, assignments), childDecorrelationResult.variablesToPropagate, childDecorrelationResult.correlatedPredicates, childDecorrelationResult.correlatedVariablesMapping, childDecorrelationResult.atMostSingleRow));
        }

        private Multimap<VariableReferenceExpression, VariableReferenceExpression> extractCorrelatedSymbolsMapping(List<Expression> correlatedConjuncts) {
            ImmutableMultimap.Builder mapping = ImmutableMultimap.builder();
            for (Expression conjunct : correlatedConjuncts) {
                ComparisonExpression comparison;
                if (!(conjunct instanceof ComparisonExpression) || !(comparison = (ComparisonExpression)conjunct).getOperator().equals((Object)ComparisonExpression.Operator.EQUAL)) continue;
                List<VariableReferenceExpression> left = this.extractUniqueExpression(comparison.getLeft());
                List<VariableReferenceExpression> right = this.extractUniqueExpression(comparison.getRight());
                for (VariableReferenceExpression leftVariableExpression : left) {
                    for (VariableReferenceExpression rightVariableExpression : right) {
                        if (this.correlation.contains(leftVariableExpression) && !this.correlation.contains(rightVariableExpression)) {
                            mapping.put((Object)leftVariableExpression, (Object)rightVariableExpression);
                        }
                        if (!this.correlation.contains(rightVariableExpression) || this.correlation.contains(leftVariableExpression)) continue;
                        mapping.put((Object)rightVariableExpression, (Object)leftVariableExpression);
                    }
                }
            }
            return mapping.build();
        }

        private List<VariableReferenceExpression> extractUniqueExpression(Expression expression) {
            return (List)VariablesExtractor.extractUnique(expression, PlanNodeDecorrelator.this.variableAllocator.getTypes()).stream().collect(ImmutableList.toImmutableList());
        }

        private boolean isCorrelated(Expression expression) {
            return this.correlation.stream().anyMatch(VariablesExtractor.extractUnique(expression, PlanNodeDecorrelator.this.variableAllocator.getTypes())::contains);
        }

        private static /* synthetic */ boolean lambda$visitProject$2(Set nodeOutputVariables, VariableReferenceExpression variable) {
            return !nodeOutputVariables.contains(variable);
        }

        private static /* synthetic */ boolean lambda$visitAggregation$1(Set groupingKeys, VariableReferenceExpression variable) {
            return !groupingKeys.contains(variable);
        }
    }
}

