/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.ExternalCallExpressionChecker;
import com.facebook.presto.sql.planner.plan.Patterns;
import java.util.Objects;

public class RewriteFilterWithExternalFunctionToProject
implements Rule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();
    private final FunctionAndTypeManager functionAndTypeManager;

    public RewriteFilterWithExternalFunctionToProject(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
        if (!((Boolean)node.getPredicate().accept((RowExpressionVisitor)new ExternalCallExpressionChecker(this.functionAndTypeManager), null)).booleanValue()) {
            return Rule.Result.empty();
        }
        VariableReferenceExpression predicateVariable = context.getVariableAllocator().newVariable(node.getPredicate());
        Assignments.Builder assignments = Assignments.builder();
        node.getOutputVariables().forEach(variable -> assignments.put(variable, (RowExpression)variable));
        Assignments identityAssignments = assignments.build();
        assignments.put(predicateVariable, node.getPredicate());
        return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)new FilterNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), node.getSource(), assignments.build()), (RowExpression)predicateVariable), identityAssignments, ProjectNode.Locality.LOCAL));
    }
}

