/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class ImplementOffset
implements Rule<OffsetNode> {
    private static final Pattern<OffsetNode> PATTERN = Patterns.offset();

    @Override
    public Pattern<OffsetNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(OffsetNode parent, Captures captures, Rule.Context context) {
        if (!SystemSessionProperties.isOffsetClauseEnabled(context.getSession())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Offset support is not enabled");
        }
        VariableReferenceExpression rowNumberSymbol = context.getVariableAllocator().newVariable("row_number", (Type)BigintType.BIGINT);
        RowNumberNode rowNumberNode = new RowNumberNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), parent.getSource(), (List<VariableReferenceExpression>)ImmutableList.of(), rowNumberSymbol, Optional.empty(), Optional.empty());
        FilterNode filterNode = new FilterNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)rowNumberNode, OriginalExpressionUtils.castToRowExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)ExpressionTreeUtils.createSymbolReference(rowNumberSymbol), (Expression)new GenericLiteral("BIGINT", Long.toString(parent.getCount())))));
        ProjectNode projectNode = new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)filterNode, AssignmentUtils.identityAssignmentsAsSymbolReferences(parent.getOutputVariables()));
        return Rule.Result.ofPlanNode((PlanNode)projectNode);
    }
}

