/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.PartitioningMetadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.SchedulingOrderVisitor;
import com.facebook.presto.sql.planner.StatisticsAggregationPlanner;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class PlanFragmenter {
    public static final int ROOT_FRAGMENT_ID = 0;
    public static final String TOO_MANY_STAGES_MESSAGE = "If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.";
    private final Metadata metadata;
    private final NodePartitioningManager nodePartitioningManager;
    private final QueryManagerConfig config;
    private final SqlParser sqlParser;
    private final PlanChecker distributedPlanChecker;
    private final PlanChecker singleNodePlanChecker;

    @Inject
    public PlanFragmenter(Metadata metadata, NodePartitioningManager nodePartitioningManager, QueryManagerConfig queryManagerConfig, SqlParser sqlParser, FeaturesConfig featuresConfig) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.config = Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.distributedPlanChecker = new PlanChecker(Objects.requireNonNull(featuresConfig, "featuresConfig is null"), false);
        this.singleNodePlanChecker = new PlanChecker(Objects.requireNonNull(featuresConfig, "featuresConfig is null"), true);
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean forceSingleNode, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        PlanVariableAllocator variableAllocator = new PlanVariableAllocator(plan.getTypes().allVariables());
        return this.createSubPlans(session, plan, forceSingleNode, idAllocator, variableAllocator, warningCollector);
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean forceSingleNode, PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, WarningCollector warningCollector) {
        Fragmenter fragmenter = new Fragmenter(session, this.metadata, plan.getStatsAndCosts(), forceSingleNode ? this.singleNodePlanChecker : this.distributedPlanChecker, warningCollector, this.sqlParser, idAllocator, variableAllocator, PlanFragmenter.getTableWriterNodeIds(plan.getRoot()));
        FragmentProperties properties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), plan.getRoot().getOutputVariables()));
        if (forceSingleNode || SystemSessionProperties.isForceSingleNodeOutput(session)) {
            properties = properties.setSingleNodeDistribution();
        }
        PlanNode root = SimplePlanRewriter.rewriteWith(fragmenter, plan.getRoot(), properties);
        SubPlan subPlan = fragmenter.buildRootFragment(root, properties);
        subPlan = this.reassignPartitioningHandleIfNecessary(session, subPlan);
        if (!forceSingleNode) {
            subPlan = this.analyzeGroupedExecution(session, subPlan, false);
        }
        Preconditions.checkState((!SystemSessionProperties.isForceSingleNodeOutput(session) || subPlan.getFragment().getPartitioning().isSingleNode() ? 1 : 0) != 0, (Object)"Root of PlanFragment is not single node");
        this.sanityCheckFragmentedPlan(subPlan, warningCollector, SystemSessionProperties.getExchangeMaterializationStrategy(session), SystemSessionProperties.getQueryMaxStageCount(session), this.config.getStageCountWarningThreshold());
        return subPlan;
    }

    private void sanityCheckFragmentedPlan(SubPlan subPlan, WarningCollector warningCollector, QueryManagerConfig.ExchangeMaterializationStrategy exchangeMaterializationStrategy, int maxStageCount, int stageCountSoftLimit) {
        subPlan.sanityCheck();
        int fragmentCount = subPlan.getAllFragments().size();
        if (fragmentCount > maxStageCount) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_HAS_TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the allowed maximum (%s). If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.", fragmentCount, maxStageCount));
        }
        if (exchangeMaterializationStrategy != QueryManagerConfig.ExchangeMaterializationStrategy.ALL && fragmentCount > stageCountSoftLimit) {
            warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the soft limit (%s). If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.", fragmentCount, stageCountSoftLimit)));
        }
    }

    private SubPlan analyzeGroupedExecution(Session session, SubPlan subPlan, boolean parentContainsTableFinish) {
        PlanFragment fragment = subPlan.getFragment();
        GroupedExecutionProperties properties = (GroupedExecutionProperties)fragment.getRoot().accept((PlanVisitor)new GroupedExecutionTagger(session, this.metadata, this.nodePartitioningManager), null);
        if (properties.isSubTreeUseful()) {
            boolean preferDynamic = fragment.getRemoteSourceNodes().stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE);
            BucketNodeMap bucketNodeMap = this.nodePartitioningManager.getBucketNodeMap(session, fragment.getPartitioning(), preferDynamic);
            if (bucketNodeMap.isDynamic()) {
                boolean recoverable;
                boolean bl = recoverable = SystemSessionProperties.isRecoverableGroupedExecutionEnabled(session) && SystemSessionProperties.isTableWriterMergeOperatorEnabled(session) && parentContainsTableFinish && (fragment.getRoot() instanceof TableWriterMergeNode || fragment.getRoot() instanceof TableWriterNode) && properties.isRecoveryEligible();
                fragment = recoverable ? fragment.withRecoverableGroupedExecution(properties.getCapableTableScanNodes(), properties.getTotalLifespans()) : fragment.withDynamicLifespanScheduleGroupedExecution(properties.getCapableTableScanNodes(), properties.getTotalLifespans());
            } else {
                fragment = fragment.withFixedLifespanScheduleGroupedExecution(properties.getCapableTableScanNodes(), properties.getTotalLifespans());
            }
        }
        ImmutableList.Builder result = ImmutableList.builder();
        boolean containsTableFinishNode = PlanFragmenter.containsTableFinishNode(fragment);
        for (SubPlan child : subPlan.getChildren()) {
            result.add((Object)this.analyzeGroupedExecution(session, child, containsTableFinishNode));
        }
        return new SubPlan(fragment, (List<SubPlan>)result.build());
    }

    private static boolean containsTableFinishNode(PlanFragment planFragment) {
        PlanNode root = planFragment.getRoot();
        return root instanceof OutputNode && Iterables.getOnlyElement((Iterable)root.getSources()) instanceof TableFinishNode;
    }

    private SubPlan reassignPartitioningHandleIfNecessary(Session session, SubPlan subPlan) {
        return this.reassignPartitioningHandleIfNecessaryHelper(session, subPlan, subPlan.getFragment().getPartitioning());
    }

    private SubPlan reassignPartitioningHandleIfNecessaryHelper(Session session, SubPlan subPlan, PartitioningHandle newOutputPartitioningHandle) {
        PlanFragment fragment = subPlan.getFragment();
        PlanNode newRoot = fragment.getRoot();
        if (!fragment.getPartitioning().isSingleNode()) {
            PartitioningHandleReassigner partitioningHandleReassigner = new PartitioningHandleReassigner(fragment.getPartitioning(), this.metadata, session);
            newRoot = SimplePlanRewriter.rewriteWith(partitioningHandleReassigner, newRoot);
        }
        PartitioningScheme outputPartitioningScheme = fragment.getPartitioningScheme();
        Partitioning newOutputPartitioning = outputPartitioningScheme.getPartitioning();
        if (outputPartitioningScheme.getPartitioning().getHandle().getConnectorId().isPresent()) {
            newOutputPartitioning = newOutputPartitioning.withAlternativePartitioningHandle(newOutputPartitioningHandle);
        }
        PlanFragment newFragment = new PlanFragment(fragment.getId(), newRoot, fragment.getVariables(), fragment.getPartitioning(), fragment.getTableScanSchedulingOrder(), new PartitioningScheme(newOutputPartitioning, outputPartitioningScheme.getOutputLayout(), outputPartitioningScheme.getHashColumn(), outputPartitioningScheme.isReplicateNullsAndAny(), outputPartitioningScheme.getBucketToPartition()), fragment.getStageExecutionDescriptor(), fragment.isOutputTableWriterFragment(), fragment.getStatsAndCosts(), fragment.getJsonRepresentation());
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (SubPlan child : subPlan.getChildren()) {
            childrenBuilder.add((Object)this.reassignPartitioningHandleIfNecessaryHelper(session, child, fragment.getPartitioning()));
        }
        return new SubPlan(newFragment, (List<SubPlan>)childrenBuilder.build());
    }

    private static Set<PlanNodeId> getTableWriterNodeIds(PlanNode plan) {
        return (Set)Streams.stream((Iterable)Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)plan)).filter(node -> node instanceof TableWriterNode).map(PlanNode::getId).collect(ImmutableSet.toImmutableSet());
    }

    private static class PartitioningVariableAssignments {
        private final List<VariableReferenceExpression> variables;
        private final Map<VariableReferenceExpression, RowExpression> constants;

        private PartitioningVariableAssignments(List<VariableReferenceExpression> variables, Map<VariableReferenceExpression, RowExpression> constants) {
            this.variables = ImmutableList.copyOf((Collection)Objects.requireNonNull(variables, "variables is null"));
            this.constants = ImmutableMap.copyOf(Objects.requireNonNull(constants, "constants is null"));
            Preconditions.checkArgument((boolean)ImmutableSet.copyOf(variables).containsAll(constants.keySet()), (Object)"partitioningVariables list must contain all partitioning variables including constants");
        }

        public List<VariableReferenceExpression> getVariables() {
            return this.variables;
        }

        public Map<VariableReferenceExpression, RowExpression> getConstants() {
            return this.constants;
        }
    }

    private static final class PartitioningHandleReassigner
    extends SimplePlanRewriter<Void> {
        private final PartitioningHandle fragmentPartitioningHandle;
        private final Metadata metadata;
        private final Session session;

        public PartitioningHandleReassigner(PartitioningHandle fragmentPartitioningHandle, Metadata metadata, Session session) {
            this.fragmentPartitioningHandle = fragmentPartitioningHandle;
            this.metadata = metadata;
            this.session = session;
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PartitioningHandle partitioning = this.metadata.getLayout(this.session, node.getTable()).getTablePartitioning().map(TableLayout.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            if (partitioning.equals(this.fragmentPartitioningHandle)) {
                return node;
            }
            TableHandle newTableHandle = this.metadata.getAlternativeTableHandle(this.session, node.getTable(), this.fragmentPartitioningHandle);
            return new TableScanNode(node.getSourceLocation(), node.getId(), newTableHandle, node.getOutputVariables(), node.getAssignments(), node.getCurrentConstraint(), node.getEnforcedConstraint());
        }
    }

    private static class GroupedExecutionProperties {
        private final boolean currentNodeCapable;
        private final boolean subTreeUseful;
        private final List<PlanNodeId> capableTableScanNodes;
        private final int totalLifespans;
        private final boolean recoveryEligible;

        public GroupedExecutionProperties(boolean currentNodeCapable, boolean subTreeUseful, List<PlanNodeId> capableTableScanNodes, int totalLifespans, boolean recoveryEligible) {
            this.currentNodeCapable = currentNodeCapable;
            this.subTreeUseful = subTreeUseful;
            this.capableTableScanNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(capableTableScanNodes, "capableTableScanNodes is null"));
            this.totalLifespans = totalLifespans;
            this.recoveryEligible = recoveryEligible;
            Preconditions.checkArgument((!subTreeUseful || currentNodeCapable ? 1 : 0) != 0);
            Preconditions.checkArgument((!recoveryEligible || currentNodeCapable ? 1 : 0) != 0);
            Preconditions.checkArgument((currentNodeCapable == !capableTableScanNodes.isEmpty() ? 1 : 0) != 0);
        }

        public static GroupedExecutionProperties notCapable() {
            return new GroupedExecutionProperties(false, false, (List<PlanNodeId>)ImmutableList.of(), 1, false);
        }

        public boolean isCurrentNodeCapable() {
            return this.currentNodeCapable;
        }

        public boolean isSubTreeUseful() {
            return this.subTreeUseful;
        }

        public List<PlanNodeId> getCapableTableScanNodes() {
            return this.capableTableScanNodes;
        }

        public int getTotalLifespans() {
            return this.totalLifespans;
        }

        public boolean isRecoveryEligible() {
            return this.recoveryEligible;
        }
    }

    private static class GroupedExecutionTagger
    extends InternalPlanVisitor<GroupedExecutionProperties, Void> {
        private final Session session;
        private final Metadata metadata;
        private final NodePartitioningManager nodePartitioningManager;
        private final boolean groupedExecutionEnabled;

        public GroupedExecutionTagger(Session session, Metadata metadata, NodePartitioningManager nodePartitioningManager) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.groupedExecutionEnabled = SystemSessionProperties.isGroupedExecutionEnabled(session);
        }

        public GroupedExecutionProperties visitPlan(PlanNode node, Void context) {
            if (node.getSources().isEmpty()) {
                return GroupedExecutionProperties.notCapable();
            }
            return this.processChildren(node);
        }

        @Override
        public GroupedExecutionProperties visitJoin(JoinNode node, Void context) {
            GroupedExecutionProperties left = (GroupedExecutionProperties)node.getLeft().accept((PlanVisitor)this, null);
            GroupedExecutionProperties right = (GroupedExecutionProperties)node.getRight().accept((PlanVisitor)this, null);
            if (!node.getDistributionType().isPresent() || !this.groupedExecutionEnabled) {
                return GroupedExecutionProperties.notCapable();
            }
            if (!(node.getType() != JoinNode.Type.RIGHT && node.getType() != JoinNode.Type.FULL || right.currentNodeCapable)) {
                return GroupedExecutionProperties.notCapable();
            }
            switch (node.getDistributionType().get()) {
                case REPLICATED: {
                    Preconditions.checkState((!right.currentNodeCapable ? 1 : 0) != 0);
                    return left;
                }
                case PARTITIONED: {
                    if (left.currentNodeCapable && right.currentNodeCapable) {
                        Preconditions.checkState((left.totalLifespans == right.totalLifespans ? 1 : 0) != 0, (Object)String.format("Mismatched number of lifespans on left(%s) and right(%s) side of join", left.totalLifespans, right.totalLifespans));
                        return new GroupedExecutionProperties(true, true, (List<PlanNodeId>)ImmutableList.builder().addAll((Iterable)left.capableTableScanNodes).addAll((Iterable)right.capableTableScanNodes).build(), left.totalLifespans, left.recoveryEligible && right.recoveryEligible);
                    }
                    return left;
                }
            }
            throw new UnsupportedOperationException("Unknown distribution type: " + node.getDistributionType());
        }

        public GroupedExecutionProperties visitAggregation(AggregationNode node, Void context) {
            GroupedExecutionProperties properties = (GroupedExecutionProperties)node.getSource().accept((PlanVisitor)this, null);
            if (this.groupedExecutionEnabled && properties.isCurrentNodeCapable()) {
                switch (node.getStep()) {
                    case SINGLE: 
                    case FINAL: {
                        return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes, properties.totalLifespans, properties.recoveryEligible);
                    }
                    case PARTIAL: 
                    case INTERMEDIATE: {
                        return properties;
                    }
                }
            }
            return GroupedExecutionProperties.notCapable();
        }

        @Override
        public GroupedExecutionProperties visitWindow(WindowNode node, Void context) {
            return this.processWindowFunction(node);
        }

        @Override
        public GroupedExecutionProperties visitRowNumber(RowNumberNode node, Void context) {
            return this.processWindowFunction(node);
        }

        @Override
        public GroupedExecutionProperties visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            return this.processWindowFunction(node);
        }

        private GroupedExecutionProperties processWindowFunction(PlanNode node) {
            GroupedExecutionProperties properties = (GroupedExecutionProperties)((PlanNode)Iterables.getOnlyElement((Iterable)node.getSources())).accept((PlanVisitor)this, null);
            if (this.groupedExecutionEnabled && properties.isCurrentNodeCapable()) {
                return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes, properties.totalLifespans, properties.recoveryEligible);
            }
            return GroupedExecutionProperties.notCapable();
        }

        public GroupedExecutionProperties visitMarkDistinct(MarkDistinctNode node, Void context) {
            GroupedExecutionProperties properties = (GroupedExecutionProperties)((PlanNode)Iterables.getOnlyElement((Iterable)node.getSources())).accept((PlanVisitor)this, null);
            if (this.groupedExecutionEnabled && properties.isCurrentNodeCapable()) {
                return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes, properties.totalLifespans, properties.recoveryEligible);
            }
            return GroupedExecutionProperties.notCapable();
        }

        @Override
        public GroupedExecutionProperties visitTableWriter(TableWriterNode node, Void context) {
            GroupedExecutionProperties properties = (GroupedExecutionProperties)node.getSource().accept((PlanVisitor)this, null);
            boolean recoveryEligible = properties.isRecoveryEligible();
            TableWriterNode.WriterTarget target = node.getTarget().orElseThrow(() -> new VerifyException("target is absent"));
            recoveryEligible = target instanceof TableWriterNode.CreateName || target instanceof TableWriterNode.InsertReference || target instanceof TableWriterNode.RefreshMaterializedViewReference ? (recoveryEligible &= this.metadata.getConnectorCapabilities(this.session, target.getConnectorId()).contains(ConnectorCapabilities.SUPPORTS_PAGE_SINK_COMMIT)) : false;
            return new GroupedExecutionProperties(properties.isCurrentNodeCapable(), properties.isSubTreeUseful(), properties.getCapableTableScanNodes(), properties.getTotalLifespans(), recoveryEligible);
        }

        public GroupedExecutionProperties visitTableScan(TableScanNode node, Void context) {
            Optional<TableLayout.TablePartitioning> tablePartitioning = this.metadata.getLayout(this.session, node.getTable()).getTablePartitioning();
            if (!tablePartitioning.isPresent()) {
                return GroupedExecutionProperties.notCapable();
            }
            List<ConnectorPartitionHandle> partitionHandles = this.nodePartitioningManager.listPartitionHandles(this.session, tablePartitioning.get().getPartitioningHandle());
            if (ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED).equals(partitionHandles)) {
                return GroupedExecutionProperties.notCapable();
            }
            return new GroupedExecutionProperties(true, false, (List<PlanNodeId>)ImmutableList.of((Object)node.getId()), partitionHandles.size(), this.metadata.getConnectorCapabilities(this.session, node.getTable().getConnectorId()).contains(ConnectorCapabilities.SUPPORTS_REWINDABLE_SPLIT_SOURCE));
        }

        private GroupedExecutionProperties processChildren(PlanNode node) {
            boolean anyUseful = false;
            OptionalInt totalLifespans = OptionalInt.empty();
            boolean allRecoveryEligible = true;
            ImmutableList.Builder capableTableScanNodes = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                GroupedExecutionProperties properties = (GroupedExecutionProperties)source.accept((PlanVisitor)this, null);
                if (!properties.isCurrentNodeCapable()) {
                    return GroupedExecutionProperties.notCapable();
                }
                anyUseful |= properties.isSubTreeUseful();
                allRecoveryEligible &= properties.isRecoveryEligible();
                if (!totalLifespans.isPresent()) {
                    totalLifespans = OptionalInt.of(properties.totalLifespans);
                } else {
                    Preconditions.checkState((totalLifespans.getAsInt() == properties.totalLifespans ? 1 : 0) != 0, (Object)String.format("Mismatched number of lifespans among children nodes. Expected: %s, actual: %s", totalLifespans.getAsInt(), properties.totalLifespans));
                }
                capableTableScanNodes.addAll((Iterable)properties.capableTableScanNodes);
            }
            return new GroupedExecutionProperties(true, anyUseful, (List<PlanNodeId>)capableTableScanNodes.build(), totalLifespans.getAsInt(), allRecoveryEligible);
        }
    }

    private static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private final PartitioningScheme partitioningScheme;
        private Optional<PartitioningHandle> partitioningHandle = Optional.empty();
        private final Set<PlanNodeId> partitionedSources = new HashSet<PlanNodeId>();

        public FragmentProperties(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isSingleNode()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.SINGLE_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.SINGLE_DISTRIBUTION);
            return this;
        }

        public FragmentProperties setDistribution(PartitioningHandle distribution, Metadata metadata, Session session) {
            if (!this.partitioningHandle.isPresent()) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            PartitioningHandle currentPartitioning = this.partitioningHandle.get();
            if (SystemPartitioningHandle.isCompatibleSystemPartitioning(currentPartitioning, distribution)) {
                return this;
            }
            if (currentPartitioning.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            if (currentPartitioning.isSingleNode()) {
                return this;
            }
            if (currentPartitioning.equals(distribution)) {
                return this;
            }
            Optional<PartitioningHandle> commonPartitioning = metadata.getCommonPartitioning(session, currentPartitioning, distribution);
            if (commonPartitioning.isPresent()) {
                this.partitioningHandle = commonPartitioning;
                return this;
            }
            if (metadata.isRefinedPartitioningOver(session, distribution, currentPartitioning)) {
                return this;
            }
            throw new IllegalStateException(String.format("Cannot set distribution to %s. Already set to %s", distribution, this.partitioningHandle));
        }

        public FragmentProperties setCoordinatorOnlyDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isCoordinatorOnly()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() || this.partitioningHandle.get().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION);
            return this;
        }

        public FragmentProperties addSourceDistribution(PlanNodeId source, PartitioningHandle distribution, Metadata metadata, Session session) {
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(distribution, "distribution is null");
            this.partitionedSources.add(source);
            return this.setDistribution(distribution, metadata, session);
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public PartitioningScheme getPartitioningScheme() {
            return this.partitioningScheme;
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle.get();
        }

        public Set<PlanNodeId> getPartitionedSources() {
            return this.partitionedSources;
        }
    }

    private static class Fragmenter
    extends SimplePlanRewriter<FragmentProperties> {
        private final Session session;
        private final Metadata metadata;
        private final PlanNodeIdAllocator idAllocator;
        private final PlanVariableAllocator variableAllocator;
        private final StatsAndCosts statsAndCosts;
        private final PlanChecker planChecker;
        private final WarningCollector warningCollector;
        private final SqlParser sqlParser;
        private final Set<PlanNodeId> outputTableWriterNodeIds;
        private int nextFragmentId = 1;
        private final StatisticsAggregationPlanner statisticsAggregationPlanner;

        public Fragmenter(Session session, Metadata metadata, StatsAndCosts statsAndCosts, PlanChecker planChecker, WarningCollector warningCollector, SqlParser sqlParser, PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, Set<PlanNodeId> outputTableWriterNodeIds) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
            this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
            this.outputTableWriterNodeIds = ImmutableSet.copyOf((Collection)Objects.requireNonNull(outputTableWriterNodeIds, "outputTableWriterNodeIds is null"));
            this.statisticsAggregationPlanner = new StatisticsAggregationPlanner(variableAllocator, metadata);
        }

        public SubPlan buildRootFragment(PlanNode root, FragmentProperties properties) {
            return this.buildFragment(root, properties, new PlanFragmentId(0));
        }

        private PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(this.nextFragmentId++);
        }

        private SubPlan buildFragment(PlanNode root, FragmentProperties properties, PlanFragmentId fragmentId) {
            List<PlanNodeId> schedulingOrder = SchedulingOrderVisitor.scheduleOrder(root);
            Preconditions.checkArgument((boolean)properties.getPartitionedSources().equals(ImmutableSet.copyOf(schedulingOrder)), (String)"Expected scheduling order (%s) to contain an entry for all partitioned sources (%s)", schedulingOrder, properties.getPartitionedSources());
            Set<VariableReferenceExpression> fragmentVariableTypes = VariablesExtractor.extractOutputVariables(root);
            this.planChecker.validatePlanFragment(root, this.session, this.metadata, this.sqlParser, TypeProvider.fromVariables(fragmentVariableTypes), this.warningCollector);
            Set tableWriterNodeIds = PlanFragmenter.getTableWriterNodeIds(root);
            boolean outputTableWriterFragment = tableWriterNodeIds.stream().anyMatch(this.outputTableWriterNodeIds::contains);
            if (outputTableWriterFragment) {
                Verify.verify((boolean)this.outputTableWriterNodeIds.containsAll(tableWriterNodeIds), (String)"outputTableWriterNodeIds %s must include either all or none of tableWriterNodeIds %s", this.outputTableWriterNodeIds, (Object)tableWriterNodeIds);
            }
            PlanFragment fragment = new PlanFragment(fragmentId, root, fragmentVariableTypes, properties.getPartitioningHandle(), schedulingOrder, properties.getPartitioningScheme(), StageExecutionDescriptor.ungroupedExecution(), outputTableWriterFragment, this.statsAndCosts.getForSubplan(root), Optional.of(PlanPrinter.jsonFragmentPlan(root, fragmentVariableTypes, this.metadata.getFunctionAndTypeManager(), this.session)));
            return new SubPlan(fragment, properties.getChildren());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (SystemSessionProperties.isForceSingleNodeOutput(this.session)) {
                context.get().setSingleNodeDistribution();
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitMetadataDelete(MetadataDeleteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PartitioningHandle partitioning = this.metadata.getLayout(this.session, node.getTable()).getTablePartitioning().map(TableLayout.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            context.get().addSourceDistribution(node.getId(), partitioning, this.metadata, this.session);
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (node.getTablePartitioningScheme().isPresent()) {
                context.get().setDistribution(node.getTablePartitioningScheme().get().getPartitioning().getHandle(), this.metadata, this.session);
            }
            if (node.getPreferredShufflePartitioningScheme().isPresent()) {
                context.get().setDistribution(node.getPreferredShufflePartitioningScheme().get().getPartitioning().getHandle(), this.metadata, this.session);
            }
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            switch (exchange.getScope()) {
                case LOCAL: {
                    return context.defaultRewrite(exchange, context.get());
                }
                case REMOTE_STREAMING: {
                    return this.createRemoteStreamingExchange(exchange, context);
                }
                case REMOTE_MATERIALIZED: {
                    return this.createRemoteMaterializedExchange(exchange, context);
                }
            }
            throw new IllegalArgumentException("Unexpected exchange scope: " + (Object)((Object)exchange.getScope()));
        }

        private PlanNode createRemoteStreamingExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            Preconditions.checkArgument((exchange.getScope() == ExchangeNode.Scope.REMOTE_STREAMING ? 1 : 0) != 0, (String)"Unexpected exchange scope: %s", (Object)((Object)exchange.getScope()));
            PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
            if (exchange.getType() == ExchangeNode.Type.GATHER) {
                context.get().setSingleNodeDistribution();
            } else if (exchange.getType() == ExchangeNode.Type.REPARTITION) {
                context.get().setDistribution(partitioningScheme.getPartitioning().getHandle(), this.metadata, this.session);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int sourceIndex = 0; sourceIndex < exchange.getSources().size(); ++sourceIndex) {
                FragmentProperties childProperties = new FragmentProperties(partitioningScheme.translateOutputLayout(exchange.getInputs().get(sourceIndex)));
                builder.add((Object)this.buildSubPlan(exchange.getSources().get(sourceIndex), childProperties, context));
            }
            ImmutableList children = builder.build();
            context.get().addChildren((List<SubPlan>)children);
            List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableList.toImmutableList());
            return new RemoteSourceNode((Optional<SourceLocation>)exchange.getSourceLocation(), exchange.getId(), childrenIds, exchange.getOutputVariables(), exchange.isEnsureSourceOrdering(), exchange.getOrderingScheme(), exchange.getType());
        }

        private PlanNode createRemoteMaterializedExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            TableHandle temporaryTableHandle;
            Preconditions.checkArgument((exchange.getType() == ExchangeNode.Type.REPARTITION ? 1 : 0) != 0, (String)"Unexpected exchange type: %s", (Object)((Object)exchange.getType()));
            Preconditions.checkArgument((exchange.getScope() == ExchangeNode.Scope.REMOTE_MATERIALIZED ? 1 : 0) != 0, (String)"Unexpected exchange scope: %s", (Object)((Object)exchange.getScope()));
            PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
            PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
            ConnectorId connectorId = partitioningHandle.getConnectorId().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The \"partitioning_provider_catalog\" session property must be set to enable the exchanges materialization. The catalog must support providing a custom partitioning and storing temporary tables."));
            Partitioning partitioning = partitioningScheme.getPartitioning();
            PartitioningVariableAssignments partitioningVariableAssignments = this.assignPartitioningVariables(partitioning);
            Map<VariableReferenceExpression, ColumnMetadata> variableToColumnMap = this.assignTemporaryTableColumnNames(exchange.getOutputVariables(), partitioningVariableAssignments.getConstants().keySet());
            List<VariableReferenceExpression> partitioningVariables = partitioningVariableAssignments.getVariables();
            List partitionColumns = (List)partitioningVariables.stream().map(variable -> ((ColumnMetadata)variableToColumnMap.get(variable)).getName()).collect(ImmutableList.toImmutableList());
            PartitioningMetadata partitioningMetadata = new PartitioningMetadata(partitioningHandle, partitionColumns);
            try {
                temporaryTableHandle = this.metadata.createTemporaryTable(this.session, connectorId.getCatalogName(), (List<ColumnMetadata>)ImmutableList.copyOf(variableToColumnMap.values()), Optional.of(partitioningMetadata));
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Temporary table cannot be created in catalog \"%s\": %s", connectorId.getCatalogName(), e.getMessage()), (Throwable)e);
                }
                throw e;
            }
            TableScanNode scan = this.createTemporaryTableScan(exchange.getSourceLocation(), temporaryTableHandle, exchange.getOutputVariables(), variableToColumnMap, partitioningMetadata);
            Preconditions.checkArgument((!exchange.getPartitioningScheme().isReplicateNullsAndAny() ? 1 : 0) != 0, (Object)"materialized remote exchange is not supported when replicateNullsAndAny is needed");
            TableFinishNode write = this.createTemporaryTableWrite(scan.getSourceLocation(), temporaryTableHandle, variableToColumnMap, exchange.getOutputVariables(), exchange.getInputs(), exchange.getSources(), partitioningVariableAssignments.getConstants(), partitioningMetadata);
            FragmentProperties writeProperties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), write.getOutputVariables()));
            writeProperties.setCoordinatorOnlyDistribution();
            ImmutableList children = ImmutableList.of((Object)this.buildSubPlan(write, writeProperties, context));
            context.get().addChildren((List<SubPlan>)children);
            return this.visitTableScan(scan, context);
        }

        private PartitioningVariableAssignments assignPartitioningVariables(Partitioning partitioning) {
            ImmutableList.Builder variables = ImmutableList.builder();
            ImmutableMap.Builder constants = ImmutableMap.builder();
            for (RowExpression argument : partitioning.getArguments()) {
                VariableReferenceExpression variable;
                Preconditions.checkArgument((argument instanceof ConstantExpression || argument instanceof VariableReferenceExpression ? 1 : 0) != 0, (Object)String.format("Expect argument to be ConstantExpression or VariableReferenceExpression, get %s (%s)", argument.getClass(), argument));
                if (argument instanceof ConstantExpression) {
                    variable = this.variableAllocator.newVariable((Optional<SourceLocation>)argument.getSourceLocation(), "constant_partition", argument.getType());
                    constants.put((Object)variable, (Object)argument);
                } else {
                    variable = (VariableReferenceExpression)argument;
                }
                variables.add((Object)variable);
            }
            return new PartitioningVariableAssignments((List)variables.build(), (Map)constants.build());
        }

        private Map<VariableReferenceExpression, ColumnMetadata> assignTemporaryTableColumnNames(Collection<VariableReferenceExpression> outputVariables, Collection<VariableReferenceExpression> constantPartitioningVariables) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            int column = 0;
            for (VariableReferenceExpression outputVariable : Iterables.concat(outputVariables, constantPartitioningVariables)) {
                String columnName = String.format("_c%d_%s", column, outputVariable.getName());
                result.put((Object)outputVariable, (Object)new ColumnMetadata(columnName, outputVariable.getType()));
                ++column;
            }
            return result.build();
        }

        private TableScanNode createTemporaryTableScan(Optional<SourceLocation> sourceLocation, TableHandle tableHandle, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnMetadata> variableToColumnMap, PartitioningMetadata expectedPartitioningMetadata) {
            Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, tableHandle);
            Map outputColumns = (Map)outputVariables.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), variableToColumnMap::get));
            Set outputColumnHandles = (Set)outputColumns.values().stream().map(ColumnMetadata::getName).map(columnHandles::get).collect(ImmutableSet.toImmutableSet());
            TableLayoutResult selectedLayout = this.metadata.getLayout(this.session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.of(outputColumnHandles));
            Verify.verify((boolean)selectedLayout.getUnenforcedConstraint().equals((Object)TupleDomain.all()), (String)"temporary table layout shouldn't enforce any constraints", (Object[])new Object[0]);
            Verify.verify((!selectedLayout.getLayout().getColumns().isPresent() ? 1 : 0) != 0, (String)"temporary table layout must provide all the columns", (Object[])new Object[0]);
            TableLayout.TablePartitioning expectedPartitioning = new TableLayout.TablePartitioning(expectedPartitioningMetadata.getPartitioningHandle(), (List)expectedPartitioningMetadata.getPartitionColumns().stream().map(columnHandles::get).collect(ImmutableList.toImmutableList()));
            Verify.verify((boolean)selectedLayout.getLayout().getTablePartitioning().equals(Optional.of(expectedPartitioning)), (String)"invalid temporary table partitioning", (Object[])new Object[0]);
            Map assignments = (Map)outputVariables.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), variable -> (ColumnHandle)columnHandles.get(((ColumnMetadata)outputColumns.get(variable)).getName())));
            return new TableScanNode(sourceLocation, this.idAllocator.getNextId(), selectedLayout.getLayout().getNewTableHandle(), outputVariables, assignments, TupleDomain.all(), TupleDomain.all());
        }

        private TableFinishNode createTemporaryTableWrite(Optional<SourceLocation> sourceLocation, TableHandle tableHandle, Map<VariableReferenceExpression, ColumnMetadata> variableToColumnMap, List<VariableReferenceExpression> outputs, List<List<VariableReferenceExpression>> inputs, List<PlanNode> sources, Map<VariableReferenceExpression, RowExpression> constantExpressions, PartitioningMetadata partitioningMetadata) {
            InternalPlanNode tableWriterMerge;
            if (!constantExpressions.isEmpty()) {
                ImmutableList constantVariables = ImmutableList.copyOf(constantExpressions.keySet());
                outputs = ImmutableList.builder().addAll(outputs).addAll((Iterable)constantVariables).build();
                inputs = (List)inputs.stream().map(arg_0 -> Fragmenter.lambda$createTemporaryTableWrite$3((List)constantVariables, arg_0)).collect(ImmutableList.toImmutableList());
                sources = (List)sources.stream().map(arg_0 -> this.lambda$createTemporaryTableWrite$6((List)constantVariables, constantExpressions, arg_0)).collect(ImmutableList.toImmutableList());
            }
            NewTableLayout insertLayout = this.metadata.getInsertLayout(this.session, tableHandle).orElseThrow(() -> new IllegalArgumentException("insertLayout for the temporary table must be present"));
            PartitioningHandle partitioningHandle = partitioningMetadata.getPartitioningHandle();
            List<String> partitionColumns = partitioningMetadata.getPartitionColumns();
            ConnectorNewTableLayout expectedNewTableLayout = new ConnectorNewTableLayout(partitioningHandle.getConnectorHandle(), partitionColumns);
            Verify.verify((boolean)insertLayout.getLayout().equals((Object)expectedNewTableLayout), (String)"unexpected new table layout", (Object[])new Object[0]);
            Map columnNameToVariable = (Map)variableToColumnMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((ColumnMetadata)entry.getValue()).getName(), Map.Entry::getKey));
            List partitioningVariables = (List)partitionColumns.stream().map(columnNameToVariable::get).collect(ImmutableList.toImmutableList());
            List outputColumnNames = (List)outputs.stream().map(variableToColumnMap::get).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
            Set<VariableReferenceExpression> outputNotNullColumnVariables = outputs.stream().filter(variable -> variableToColumnMap.get(variable) != null && !((ColumnMetadata)variableToColumnMap.get(variable)).isNullable()).collect(Collectors.toSet());
            SchemaTableName schemaTableName = this.metadata.getTableMetadata(this.session, tableHandle).getTable();
            TableWriterNode.InsertReference insertReference = new TableWriterNode.InsertReference(tableHandle, schemaTableName);
            PartitioningScheme partitioningScheme = new PartitioningScheme(Partitioning.create(partitioningHandle, partitioningVariables), (List<VariableReferenceExpression>)outputs, Optional.empty(), false, Optional.empty());
            ExchangeNode writerRemoteSource = new ExchangeNode(sourceLocation, this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.REMOTE_STREAMING, partitioningScheme, sources, inputs, false, Optional.empty());
            ExchangeNode writerSource = SystemSessionProperties.getTaskPartitionedWriterCount(this.session) == 1 ? ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, writerRemoteSource) : ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, writerRemoteSource, partitioningScheme);
            String catalogName = tableHandle.getConnectorId().getCatalogName();
            TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle);
            TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, catalogName, tableMetadata.getMetadata());
            StatisticsAggregationPlanner.TableStatisticAggregation statisticsResult = this.statisticsAggregationPlanner.createStatisticsAggregation(statisticsMetadata, columnNameToVariable, false);
            StatisticAggregations.Parts aggregations = statisticsResult.getAggregations().splitIntoPartialAndFinal(this.variableAllocator, this.metadata.getFunctionAndTypeManager());
            boolean enableStatsCollectionForTemporaryTable = SystemSessionProperties.isEnableStatsCollectionForTemporaryTable(this.session);
            if (SystemSessionProperties.isTableWriterMergeOperatorEnabled(this.session)) {
                StatisticAggregations.Parts localAggregations = aggregations.getPartialAggregation().splitIntoPartialAndIntermediate(this.variableAllocator, this.metadata.getFunctionAndTypeManager());
                tableWriterMerge = new TableWriterMergeNode(sourceLocation, this.idAllocator.getNextId(), ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, new TableWriterNode(sourceLocation, this.idAllocator.getNextId(), writerSource, Optional.of(insertReference), this.variableAllocator.newVariable("partialrows", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("partialfragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("partialtablecommitcontext", (Type)VarbinaryType.VARBINARY), (List<VariableReferenceExpression>)outputs, outputColumnNames, outputNotNullColumnVariables, Optional.of(partitioningScheme), Optional.empty(), enableStatsCollectionForTemporaryTable ? Optional.of(localAggregations.getPartialAggregation()) : Optional.empty())), this.variableAllocator.newVariable("intermediaterows", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("intermediatefragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("intermediatetablecommitcontext", (Type)VarbinaryType.VARBINARY), enableStatsCollectionForTemporaryTable ? Optional.of(localAggregations.getIntermediateAggregation()) : Optional.empty());
            } else {
                tableWriterMerge = new TableWriterNode(sourceLocation, this.idAllocator.getNextId(), writerSource, Optional.of(insertReference), this.variableAllocator.newVariable("partialrows", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("partialfragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("partialtablecommitcontext", (Type)VarbinaryType.VARBINARY), (List<VariableReferenceExpression>)outputs, outputColumnNames, outputNotNullColumnVariables, Optional.of(partitioningScheme), Optional.empty(), enableStatsCollectionForTemporaryTable ? Optional.of(aggregations.getPartialAggregation()) : Optional.empty());
            }
            return new TableFinishNode(sourceLocation, this.idAllocator.getNextId(), ExchangeNode.ensureSourceOrderingGatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, tableWriterMerge), Optional.of(insertReference), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), enableStatsCollectionForTemporaryTable ? Optional.of(aggregations.getFinalAggregation()) : Optional.empty(), enableStatsCollectionForTemporaryTable ? Optional.of(statisticsResult.getDescriptor()) : Optional.empty());
        }

        private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PlanFragmentId planFragmentId = this.nextFragmentId();
            PlanNode child = context.rewrite(node, properties);
            return this.buildFragment(child, properties, planFragmentId);
        }

        private /* synthetic */ ProjectNode lambda$createTemporaryTableWrite$6(List constantVariables, Map constantExpressions, PlanNode source) {
            Assignments.Builder assignments = Assignments.builder();
            source.getOutputVariables().forEach(variable -> assignments.put(variable, (RowExpression)new VariableReferenceExpression(variable.getSourceLocation(), variable.getName(), variable.getType())));
            constantVariables.forEach(variable -> assignments.put(variable, (RowExpression)constantExpressions.get(variable)));
            return new ProjectNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, assignments.build(), ProjectNode.Locality.LOCAL);
        }

        private static /* synthetic */ ImmutableList lambda$createTemporaryTableWrite$3(List constantVariables, List input) {
            return ImmutableList.builder().addAll((Iterable)input).addAll((Iterable)constantVariables).build();
        }
    }
}

