/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;

public class ParameterRewriter
extends ExpressionRewriter<Void> {
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private final Analysis analysis;

    public ParameterRewriter(Map<NodeRef<Parameter>, Expression> parameters) {
        Objects.requireNonNull(parameters, "parameterMap is null");
        this.parameters = parameters;
        this.analysis = null;
    }

    public ParameterRewriter(Analysis analysis) {
        this.analysis = analysis;
        this.parameters = analysis.getParameters();
    }

    public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        return treeRewriter.defaultRewrite(node, (Object)context);
    }

    public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        Preconditions.checkState((this.parameters.size() > node.getPosition() ? 1 : 0) != 0, (Object)"Too few parameter values");
        return this.coerceIfNecessary((Expression)node, this.parameters.get(NodeRef.of((Node)node)));
    }

    private Expression coerceIfNecessary(Expression original, Expression rewritten) {
        if (this.analysis == null) {
            return rewritten;
        }
        Type coercion = this.analysis.getCoercion(original);
        if (coercion != null) {
            rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.analysis.isTypeOnlyCoercion(original));
        }
        return rewritten;
    }
}

