/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MaterializedViewInformationExtractor
extends DefaultTraversalVisitor<Void, Void> {
    private final MaterializedViewInfo materializedViewInfo = new MaterializedViewInfo();

    protected Void visitQuerySpecification(QuerySpecification node, Void context) {
        if (node.getLimit().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Limit clause is not supported in query optimizer", new Object[0]);
        }
        if (node.getHaving().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Having clause is not supported in query optimizer", new Object[0]);
        }
        if (!node.getFrom().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Materialized view with no From clause is not supported in query optimizer", new Object[0]);
        }
        this.materializedViewInfo.setBaseTable((Relation)node.getFrom().get());
        this.materializedViewInfo.setWhereClause(node.getWhere());
        return (Void)super.visitQuerySpecification(node, (Object)context);
    }

    protected Void visitSelect(Select node, Void context) {
        super.visitSelect(node, (Object)context);
        this.materializedViewInfo.setDistinct(node.isDistinct());
        return null;
    }

    protected Void visitSingleColumn(SingleColumn node, Void context) {
        this.materializedViewInfo.addBaseToViewColumn(node);
        return null;
    }

    protected Void visitAllColumns(AllColumns node, Void context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "All columns materialized view is not supported in query optimizer", new Object[0]);
    }

    protected Void visitGroupBy(GroupBy node, Void context) {
        for (GroupingElement element : node.getGroupingElements()) {
            this.materializedViewInfo.addGroupBy(element);
        }
        return null;
    }

    public MaterializedViewInfo getMaterializedViewInfo() {
        return this.materializedViewInfo;
    }

    public static final class MaterializedViewInfo {
        private final Map<Expression, Identifier> baseToViewColumnMap = new HashMap<Expression, Identifier>();
        private Optional<Relation> baseTable = Optional.empty();
        private Optional<Expression> whereClause = Optional.empty();
        private Optional<Set<Expression>> groupBy = Optional.empty();
        private boolean isDistinct;
        private Optional<Identifier> removablePrefix = Optional.empty();

        private void addBaseToViewColumn(SingleColumn singleColumn) {
            Expression key = (singleColumn = ExpressionUtils.removeSingleColumnPrefix(singleColumn, this.removablePrefix)).getExpression();
            if (key instanceof FunctionCall && !singleColumn.getAlias().isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)singleColumn, "Derived field in materialized view must have an alias", new Object[0]);
            }
            this.baseToViewColumnMap.put(key, singleColumn.getAlias().orElse(new Identifier(key.toString())));
        }

        private void addGroupBy(GroupingElement groupingElement) {
            if (!this.groupBy.isPresent()) {
                this.groupBy = Optional.of(new HashSet());
            }
            this.groupBy.get().addAll(ExpressionUtils.removeGroupingElementPrefix(groupingElement, this.removablePrefix).getExpressions());
        }

        private void setBaseTable(Relation baseTable) {
            Preconditions.checkState((!this.baseTable.isPresent() ? 1 : 0) != 0, (Object)"Only support single table rewrite in query optimizer");
            if (baseTable instanceof AliasedRelation) {
                this.removablePrefix = Optional.of(((AliasedRelation)baseTable).getAlias());
                baseTable = ((AliasedRelation)baseTable).getRelation();
            }
            if (!(baseTable instanceof Table)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)baseTable, "Relation other than Table is not supported in query optimizer", new Object[0]);
            }
            this.baseTable = Optional.of(baseTable);
            if (!this.removablePrefix.isPresent()) {
                this.removablePrefix = Optional.of(new Identifier(((Table)baseTable).getName().toString()));
            }
        }

        private void setWhereClause(Optional<Expression> whereClause) {
            Preconditions.checkState((!this.whereClause.isPresent() ? 1 : 0) != 0);
            this.whereClause = whereClause;
        }

        private void setDistinct(boolean state) {
            this.isDistinct = state;
        }

        public Optional<Relation> getBaseTable() {
            return this.baseTable;
        }

        public Map<Expression, Identifier> getBaseToViewColumnMap() {
            return ImmutableMap.copyOf(this.baseToViewColumnMap);
        }

        public Optional<Expression> getWhereClause() {
            return this.whereClause;
        }

        public boolean isDistinct() {
            return this.isDistinct;
        }

        public Optional<Set<Expression>> getGroupBy() {
            return this.groupBy;
        }
    }
}

