/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.spiller.SpillCipher;
import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

final class AesSpillCipher
implements SpillCipher {
    private static final String CIPHER_NAME = "AES/CBC/PKCS5Padding";
    private static final int KEY_BITS = 256;
    private SecretKey key = AesSpillCipher.generateNewSecretKey();
    private final int ivBytes = this.createEncryptCipher().getIV().length;

    AesSpillCipher() {
    }

    public ByteBuffer decrypt(ByteBuffer encryptedData) {
        int length = encryptedData.remaining();
        if (length < this.ivBytes) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Encrypted data size is too small: %s. It must be at least the size of the initialization vector: %s.", length, this.ivBytes));
        }
        byte[] iv = new byte[this.ivBytes];
        encryptedData.get(iv);
        Cipher cipher = this.createDecryptCipher(new IvParameterSpec(iv));
        ByteBuffer output = ByteBuffer.allocate(cipher.getOutputSize(encryptedData.remaining()));
        try {
            cipher.doFinal(encryptedData, output);
            output.flip();
            return output;
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Cannot decrypt previously encrypted data: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] decrypt(byte[] encryptedData) {
        return AesSpillCipher.unwrapOrCopyToByteArray(this.decrypt(ByteBuffer.wrap(encryptedData)));
    }

    public ByteBuffer encrypt(ByteBuffer data) {
        Cipher cipher = this.createEncryptCipher();
        byte[] iv = cipher.getIV();
        ByteBuffer output = ByteBuffer.allocate(iv.length + cipher.getOutputSize(data.remaining())).put(iv);
        try {
            cipher.doFinal(data, output);
            output.flip();
            return output;
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to encrypt data: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] encrypt(byte[] data) {
        return AesSpillCipher.unwrapOrCopyToByteArray(this.encrypt(ByteBuffer.wrap(data)));
    }

    public void destroy() {
        this.key = null;
    }

    public boolean isDestroyed() {
        return this.key == null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isDestroyed", this.isDestroyed()).toString();
    }

    private SecretKey verifyKeyNotDestroyed() {
        SecretKey key = this.key;
        if (key == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Spill cipher already destroyed");
        }
        return key;
    }

    private Cipher createEncryptCipher() {
        SecretKey key = this.verifyKeyNotDestroyed();
        Cipher cipher = AesSpillCipher.createUninitializedCipher();
        try {
            cipher.init(1, key);
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to initialize spill cipher for encryption: " + e.getMessage(), (Throwable)e);
        }
    }

    private Cipher createDecryptCipher(IvParameterSpec iv) {
        SecretKey key = this.verifyKeyNotDestroyed();
        Cipher cipher = AesSpillCipher.createUninitializedCipher();
        try {
            cipher.init(2, (Key)key, iv);
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to initialize spill cipher for decryption: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] unwrapOrCopyToByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.capacity() == buffer.remaining()) {
            return buffer.array();
        }
        byte[] copy = new byte[buffer.remaining()];
        buffer.get(copy);
        return copy;
    }

    private static Cipher createUninitializedCipher() {
        try {
            return Cipher.getInstance(CIPHER_NAME);
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create spill cipher: " + e.getMessage(), (Throwable)e);
        }
    }

    private static SecretKey generateNewSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to generate new secret key: " + e.getMessage(), (Throwable)e);
        }
    }
}

