/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.testing;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.discovery.client.Announcer;
import com.facebook.airlift.discovery.client.DiscoveryModule;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.discovery.client.ServiceSelectorManager;
import com.facebook.airlift.discovery.client.testing.TestingDiscoveryModule;
import com.facebook.airlift.event.client.EventModule;
import com.facebook.airlift.http.server.TheServlet;
import com.facebook.airlift.http.server.testing.TestingHttpServer;
import com.facebook.airlift.http.server.testing.TestingHttpServerModule;
import com.facebook.airlift.jaxrs.JaxrsModule;
import com.facebook.airlift.jmx.testing.TestingJmxModule;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.json.smile.SmileModule;
import com.facebook.airlift.node.testing.TestingNodeModule;
import com.facebook.airlift.tracetoken.TraceTokenModule;
import com.facebook.drift.server.DriftServer;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransport;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.dispatcher.QueryPrerequisitesManagerModule;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroupManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.server.GracefulShutdownHandler;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.ServerInfoResource;
import com.facebook.presto.server.ServerMainModule;
import com.facebook.presto.server.ShutdownAction;
import com.facebook.presto.server.security.ServerSecurityModule;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.planner.ConnectorPlanOptimizerManager;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.storage.TempStorageManager;
import com.facebook.presto.testing.ProcedureTester;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingEventListenerManager;
import com.facebook.presto.testing.TestingTempStorageManager;
import com.facebook.presto.testing.TestingWarningCollectorModule;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.ttl.clusterttlprovidermanagers.ClusterTtlProviderManagerModule;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManagerModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.net.HostAndPort;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.weakref.jmx.guice.MBeanModule;

public class TestingPrestoServer
implements Closeable {
    private final Injector injector;
    private final Path baseDataDir;
    private final boolean preserveData;
    private final LifeCycleManager lifeCycleManager;
    private final PluginManager pluginManager;
    private final ConnectorManager connectorManager;
    private final TestingHttpServer server;
    private final CatalogManager catalogManager;
    private final TransactionManager transactionManager;
    private final SqlParser sqlParser;
    private final Metadata metadata;
    private final StatsCalculator statsCalculator;
    private final TestingEventListenerManager eventListenerManager;
    private final TestingAccessControlManager accessControl;
    private final ProcedureTester procedureTester;
    private final Optional<InternalResourceGroupManager<?>> resourceGroupManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final ConnectorPlanOptimizerManager planOptimizerManager;
    private final ClusterMemoryPoolManager clusterMemoryManager;
    private final LocalMemoryManager localMemoryManager;
    private final InternalNodeManager nodeManager;
    private final ServiceSelectorManager serviceSelectorManager;
    private final Announcer announcer;
    private final DispatchManager dispatchManager;
    private final QueryManager queryManager;
    private final TaskManager taskManager;
    private final GracefulShutdownHandler gracefulShutdownHandler;
    private final ShutdownAction shutdownAction;
    private final RequestBlocker requestBlocker;
    private final boolean resourceManager;
    private final boolean coordinator;
    private final ServerInfoResource serverInfoResource;
    private final ResourceManagerClusterStateProvider clusterStateProvider;

    public TestingPrestoServer() throws Exception {
        this((List<Module>)ImmutableList.of());
    }

    public TestingPrestoServer(List<Module> additionalModules) throws Exception {
        this(true, (Map<String, String>)ImmutableMap.of(), null, null, new SqlParserOptions(), additionalModules);
    }

    public TestingPrestoServer(boolean coordinator, Map<String, String> properties, String environment, URI discoveryUri, SqlParserOptions parserOptions, List<Module> additionalModules) throws Exception {
        this(coordinator, properties, environment, discoveryUri, parserOptions, additionalModules, Optional.empty());
    }

    public TestingPrestoServer(boolean coordinator, Map<String, String> properties, String environment, URI discoveryUri, SqlParserOptions parserOptions, List<Module> additionalModules, Optional<Path> baseDataDir) throws Exception {
        this(false, false, coordinator, properties, environment, discoveryUri, parserOptions, additionalModules, baseDataDir);
    }

    public TestingPrestoServer(boolean resourceManager, boolean resourceManagerEnabled, boolean coordinator, Map<String, String> properties, String environment, URI discoveryUri, SqlParserOptions parserOptions, List<Module> additionalModules, Optional<Path> baseDataDir) throws Exception {
        this.resourceManager = resourceManager;
        this.coordinator = coordinator;
        this.baseDataDir = baseDataDir.orElseGet(TestingPrestoServer::tempDirectory);
        this.preserveData = baseDataDir.isPresent();
        properties = new HashMap<String, String>(properties);
        String coordinatorPort = properties.remove("http-server.http.port");
        if (coordinatorPort == null) {
            coordinatorPort = "0";
        }
        Map<String, String> serverProperties = this.getServerProperties(resourceManagerEnabled, properties, environment, discoveryUri);
        ImmutableList.Builder modules = ImmutableList.builder().add((Object)new TestingNodeModule(Optional.ofNullable(environment))).add((Object)new TestingHttpServerModule(Integer.parseInt(coordinator ? coordinatorPort : "0"))).add((Object)new JsonModule()).add((Object)ConditionalModule.installModuleIf(FeaturesConfig.class, FeaturesConfig::isJsonSerdeCodeGenerationEnabled, binder -> JsonBinder.jsonBinder((Binder)binder).addModuleBinding().to(AfterburnerModule.class))).add((Object)new SmileModule()).add((Object)new JaxrsModule(true)).add((Object)new MBeanModule()).add((Object)new TestingJmxModule()).add((Object)new EventModule()).add((Object)new TraceTokenModule()).add((Object)new ServerSecurityModule()).add((Object)new ServerMainModule(parserOptions)).add((Object)new TestingWarningCollectorModule()).add((Object)new QueryPrerequisitesManagerModule()).add((Object)new NodeTtlFetcherManagerModule()).add((Object)new ClusterTtlProviderManagerModule()).add(binder -> {
            binder.bind(TestingAccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(TestingEventListenerManager.class).in(Scopes.SINGLETON);
            binder.bind(TestingTempStorageManager.class).in(Scopes.SINGLETON);
            binder.bind(AccessControlManager.class).to(TestingAccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(EventListenerManager.class).to(TestingEventListenerManager.class).in(Scopes.SINGLETON);
            binder.bind(TempStorageManager.class).to(TestingTempStorageManager.class).in(Scopes.SINGLETON);
            binder.bind(AccessControl.class).to(AccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(ShutdownAction.class).to(TestShutdownAction.class).in(Scopes.SINGLETON);
            binder.bind(GracefulShutdownHandler.class).in(Scopes.SINGLETON);
            binder.bind(ProcedureTester.class).in(Scopes.SINGLETON);
            binder.bind(RequestBlocker.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(RequestBlocker.class).in(Scopes.SINGLETON);
        });
        if (discoveryUri != null) {
            Objects.requireNonNull(environment, "environment required when discoveryUri is present");
            modules.add((Object)new DiscoveryModule());
        } else {
            modules.add((Object)new TestingDiscoveryModule());
        }
        modules.addAll(additionalModules);
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        HashMap<String, String> optionalProperties = new HashMap<String, String>();
        if (environment != null) {
            optionalProperties.put("node.environment", environment);
        }
        this.injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(serverProperties).setOptionalConfigurationProperties(optionalProperties).quiet().initialize();
        ((Announcer)this.injector.getInstance(Announcer.class)).start();
        this.lifeCycleManager = (LifeCycleManager)this.injector.getInstance(LifeCycleManager.class);
        this.pluginManager = (PluginManager)this.injector.getInstance(PluginManager.class);
        this.connectorManager = (ConnectorManager)this.injector.getInstance(ConnectorManager.class);
        this.server = (TestingHttpServer)this.injector.getInstance(TestingHttpServer.class);
        this.catalogManager = (CatalogManager)this.injector.getInstance(CatalogManager.class);
        this.transactionManager = (TransactionManager)this.injector.getInstance(TransactionManager.class);
        this.sqlParser = (SqlParser)this.injector.getInstance(SqlParser.class);
        this.metadata = (Metadata)this.injector.getInstance(Metadata.class);
        this.accessControl = (TestingAccessControlManager)this.injector.getInstance(TestingAccessControlManager.class);
        this.procedureTester = (ProcedureTester)this.injector.getInstance(ProcedureTester.class);
        this.splitManager = (SplitManager)this.injector.getInstance(SplitManager.class);
        this.pageSourceManager = (PageSourceManager)this.injector.getInstance(PageSourceManager.class);
        if (coordinator) {
            this.dispatchManager = (DispatchManager)this.injector.getInstance(DispatchManager.class);
            this.queryManager = (QueryManager)this.injector.getInstance(QueryManager.class);
            ResourceGroupManager resourceGroupManager = (ResourceGroupManager)this.injector.getInstance(ResourceGroupManager.class);
            this.resourceGroupManager = resourceGroupManager instanceof InternalResourceGroupManager ? Optional.of((InternalResourceGroupManager)resourceGroupManager) : Optional.empty();
            this.nodePartitioningManager = (NodePartitioningManager)this.injector.getInstance(NodePartitioningManager.class);
            this.planOptimizerManager = (ConnectorPlanOptimizerManager)this.injector.getInstance(ConnectorPlanOptimizerManager.class);
            this.clusterMemoryManager = (ClusterMemoryPoolManager)this.injector.getInstance(ClusterMemoryManager.class);
            this.statsCalculator = (StatsCalculator)this.injector.getInstance(StatsCalculator.class);
            this.eventListenerManager = (TestingEventListenerManager)this.injector.getInstance(EventListenerManager.class);
            this.clusterStateProvider = null;
        } else if (resourceManager) {
            this.dispatchManager = null;
            this.queryManager = (QueryManager)this.injector.getInstance(QueryManager.class);
            this.resourceGroupManager = Optional.empty();
            this.nodePartitioningManager = (NodePartitioningManager)this.injector.getInstance(NodePartitioningManager.class);
            this.planOptimizerManager = (ConnectorPlanOptimizerManager)this.injector.getInstance(ConnectorPlanOptimizerManager.class);
            this.clusterMemoryManager = null;
            this.statsCalculator = null;
            this.eventListenerManager = (TestingEventListenerManager)this.injector.getInstance(EventListenerManager.class);
            this.clusterStateProvider = (ResourceManagerClusterStateProvider)this.injector.getInstance(ResourceManagerClusterStateProvider.class);
        } else {
            this.dispatchManager = null;
            this.queryManager = null;
            this.resourceGroupManager = Optional.empty();
            this.nodePartitioningManager = null;
            this.planOptimizerManager = null;
            this.clusterMemoryManager = null;
            this.statsCalculator = null;
            this.eventListenerManager = null;
            this.clusterStateProvider = null;
        }
        this.localMemoryManager = (LocalMemoryManager)this.injector.getInstance(LocalMemoryManager.class);
        this.nodeManager = (InternalNodeManager)this.injector.getInstance(InternalNodeManager.class);
        this.serviceSelectorManager = (ServiceSelectorManager)this.injector.getInstance(ServiceSelectorManager.class);
        this.gracefulShutdownHandler = (GracefulShutdownHandler)this.injector.getInstance(GracefulShutdownHandler.class);
        this.taskManager = (TaskManager)this.injector.getInstance(TaskManager.class);
        this.shutdownAction = (ShutdownAction)this.injector.getInstance(ShutdownAction.class);
        this.announcer = (Announcer)this.injector.getInstance(Announcer.class);
        this.requestBlocker = (RequestBlocker)this.injector.getInstance(RequestBlocker.class);
        this.serverInfoResource = (ServerInfoResource)this.injector.getInstance(ServerInfoResource.class);
        DriftServer driftServer = (DriftServer)this.injector.getInstance(DriftServer.class);
        driftServer.start();
        TestingPrestoServer.updateThriftServerAddressAnnouncement(this.announcer, TestingPrestoServer.driftServerPort(driftServer), this.nodeManager);
        this.announcer.forceAnnounce();
        this.refreshNodes();
    }

    private Map<String, String> getServerProperties(boolean resourceManagerEnabled, Map<String, String> properties, String environment, URI discoveryUri) {
        HashMap<String, String> serverProperties = new HashMap<String, String>();
        serverProperties.put("coordinator", String.valueOf(this.coordinator));
        serverProperties.put("resource-manager", String.valueOf(this.resourceManager));
        serverProperties.put("resource-manager-enabled", String.valueOf(resourceManagerEnabled));
        serverProperties.put("presto.version", "testversion");
        serverProperties.put("task.concurrency", "4");
        serverProperties.put("task.max-worker-threads", "4");
        serverProperties.put("exchange.client-threads", "4");
        serverProperties.put("optimizer.ignore-stats-calculator-failures", "false");
        if (this.coordinator || this.resourceManager) {
            serverProperties.put("failure-detector.enabled", "false");
        }
        if (discoveryUri != null) {
            Objects.requireNonNull(environment, "environment required when discoveryUri is present");
            serverProperties.put("discovery.uri", discoveryUri.toString());
        }
        serverProperties.putAll(properties);
        return ImmutableMap.copyOf(serverProperties);
    }

    @Override
    public void close() throws IOException {
        block6: {
            try {
                if (this.lifeCycleManager == null) break block6;
                this.lifeCycleManager.stop();
            }
            catch (Exception e) {
                try {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (Files.isDirectory(this.baseDataDir, new LinkOption[0]) && !this.preserveData) {
                        MoreFiles.deleteRecursively((Path)this.baseDataDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                    }
                    throw throwable;
                }
            }
        }
        if (Files.isDirectory(this.baseDataDir, new LinkOption[0]) && !this.preserveData) {
            MoreFiles.deleteRecursively((Path)this.baseDataDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin);
    }

    public DispatchManager getDispatchManager() {
        return this.dispatchManager;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public Plan getQueryPlan(QueryId queryId) {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        Preconditions.checkState((boolean)(this.queryManager instanceof SqlQueryManager));
        return ((SqlQueryManager)this.queryManager).getQueryPlan(queryId);
    }

    public void addFinalQueryInfoListener(QueryId queryId, StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        Preconditions.checkState((boolean)(this.queryManager instanceof SqlQueryManager));
        ((SqlQueryManager)this.queryManager).addFinalQueryInfoListener(queryId, stateChangeListener);
    }

    public ConnectorId createCatalog(String catalogName, String connectorName) {
        return this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public ConnectorId createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        ConnectorId connectorId = this.connectorManager.createConnection(catalogName, connectorName, properties);
        TestingPrestoServer.updateConnectorIdAnnouncement(this.announcer, connectorId, this.nodeManager);
        return connectorId;
    }

    public Path getBaseDataDir() {
        return this.baseDataDir;
    }

    public URI getBaseUrl() {
        return this.server.getBaseUrl();
    }

    public URI resolve(String path) {
        return this.server.getBaseUrl().resolve(path);
    }

    public HostAndPort getAddress() {
        return HostAndPort.fromParts((String)this.getBaseUrl().getHost(), (int)this.getBaseUrl().getPort());
    }

    public HostAndPort getHttpsAddress() {
        URI httpsUri = this.server.getHttpServerInfo().getHttpsUri();
        return HostAndPort.fromParts((String)httpsUri.getHost(), (int)httpsUri.getPort());
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public StatsCalculator getStatsCalculator() {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        return this.statsCalculator;
    }

    public Optional<EventListener> getEventListener() {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        return this.eventListenerManager.getEventListener();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public ProcedureTester getProcedureTester() {
        return this.procedureTester;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public Optional<InternalResourceGroupManager<?>> getResourceGroupManager() {
        return this.resourceGroupManager;
    }

    public InternalNodeManager getNodeManager() {
        return this.nodeManager;
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    public ConnectorPlanOptimizerManager getPlanOptimizerManager() {
        return this.planOptimizerManager;
    }

    public LocalMemoryManager getLocalMemoryManager() {
        return this.localMemoryManager;
    }

    public ClusterMemoryManager getClusterMemoryManager() {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        Preconditions.checkState((boolean)(this.clusterMemoryManager instanceof ClusterMemoryManager));
        return (ClusterMemoryManager)this.clusterMemoryManager;
    }

    public GracefulShutdownHandler getGracefulShutdownHandler() {
        return this.gracefulShutdownHandler;
    }

    public ServerInfoResource getServerInfoResource() {
        return this.serverInfoResource;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public ShutdownAction getShutdownAction() {
        return this.shutdownAction;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public boolean isResourceManager() {
        return this.resourceManager;
    }

    public final AllNodes refreshNodes() {
        this.serviceSelectorManager.forceRefresh();
        this.nodeManager.refreshNodes();
        return this.nodeManager.getAllNodes();
    }

    public final ResourceManagerClusterStateProvider getClusterStateProvider() {
        return this.clusterStateProvider;
    }

    public Set<InternalNode> getActiveNodesWithConnector(ConnectorId connectorId) {
        return this.nodeManager.getActiveConnectorNodes(connectorId);
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.injector.getInstance(key);
    }

    public void stopResponding() {
        this.requestBlocker.block();
    }

    public void startResponding() {
        this.requestBlocker.unblock();
    }

    private static void updateConnectorIdAnnouncement(Announcer announcer, ConnectorId connectorId, InternalNodeManager nodeManager) {
        ServiceAnnouncement announcement = TestingPrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(announcement.getProperties());
        String property = Strings.nullToEmpty((String)((String)properties.get("connectorIds")));
        LinkedHashSet<String> connectorIds = new LinkedHashSet<String>(Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)property));
        connectorIds.add(connectorId.toString());
        properties.put("connectorIds", Joiner.on((char)',').join(connectorIds));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)announcement.getType()).addProperties(properties).build());
        announcer.forceAnnounce();
        nodeManager.refreshNodes();
    }

    private static void updateThriftServerAddressAnnouncement(Announcer announcer, int thriftPort, InternalNodeManager nodeManager) {
        ServiceAnnouncement announcement = TestingPrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(announcement.getProperties());
        properties.put("thriftServerPort", String.valueOf(thriftPort));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)announcement.getType()).addProperties(properties).build());
        announcer.forceAnnounce();
        nodeManager.refreshNodes();
    }

    private static ServiceAnnouncement getPrestoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("presto")) continue;
            return announcement;
        }
        throw new RuntimeException("Presto announcement not found: " + announcements);
    }

    private static Path tempDirectory() {
        try {
            return Files.createTempDirectory("PrestoTest", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int driftServerPort(DriftServer server) {
        return ((DriftNettyServerTransport)server.getServerTransport()).getPort();
    }

    private static class RequestBlocker
    implements Filter {
        private static final Object monitor = new Object();
        private volatile boolean blocked;

        private RequestBlocker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            Object object = monitor;
            synchronized (object) {
                while (this.blocked) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }
            chain.doFilter(request, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void block() {
            Object object = monitor;
            synchronized (object) {
                this.blocked = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unblock() {
            Object object = monitor;
            synchronized (object) {
                this.blocked = false;
                monitor.notifyAll();
            }
        }

        public void init(FilterConfig filterConfig) {
        }

        public void destroy() {
        }
    }

    public static class TestShutdownAction
    implements ShutdownAction {
        private final CountDownLatch shutdownCalled = new CountDownLatch(1);
        @GuardedBy(value="this")
        private boolean isShutdown;

        @Override
        public synchronized void onShutdown() {
            this.isShutdown = true;
            this.shutdownCalled.countDown();
        }

        public void waitForShutdownComplete(long millis) throws InterruptedException {
            this.shutdownCalled.await(millis, TimeUnit.MILLISECONDS);
        }

        public synchronized boolean isShutdown() {
            return this.isShutdown;
        }
    }
}

