/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.airlift.http.server.CertificateAuthenticator;
import com.facebook.airlift.http.server.HttpServer;
import com.facebook.airlift.http.server.JsonWebTokenAuthenticator;
import com.facebook.airlift.http.server.JsonWebTokenConfig;
import com.facebook.airlift.http.server.KerberosAuthenticator;
import com.facebook.airlift.http.server.KerberosConfig;
import com.facebook.presto.server.security.PasswordAuthenticator;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.server.security.SecurityConfig;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import java.util.List;

public class ServerSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(PasswordAuthenticatorManager.class).in(Scopes.SINGLETON);
        List<SecurityConfig.AuthenticationType> authTypes = ((SecurityConfig)this.buildConfigObject(SecurityConfig.class)).getAuthenticationTypes();
        Multibinder authBinder = Multibinder.newSetBinder((Binder)binder, Authenticator.class);
        for (SecurityConfig.AuthenticationType authType : authTypes) {
            if (authType == SecurityConfig.AuthenticationType.CERTIFICATE) {
                OptionalBinder.newOptionalBinder((Binder)binder, HttpServer.ClientCertificate.class).setBinding().toInstance((Object)HttpServer.ClientCertificate.REQUESTED);
                authBinder.addBinding().to(CertificateAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.KERBEROS) {
                ConfigBinder.configBinder((Binder)binder).bindConfig(KerberosConfig.class);
                authBinder.addBinding().to(KerberosAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.PASSWORD) {
                authBinder.addBinding().to(PasswordAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.JWT) {
                ConfigBinder.configBinder((Binder)binder).bindConfig(JsonWebTokenConfig.class);
                authBinder.addBinding().to(JsonWebTokenAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            throw new AssertionError((Object)("Unhandled auth type: " + (Object)((Object)authType)));
        }
    }
}

