/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public class DenyAllAccessControl
implements AccessControl {
    @Override
    public void checkCanSetUser(Identity identity, AccessControlContext context, Optional<Principal> principal, String userName) {
        AccessDeniedException.denySetUser(principal, (String)userName);
    }

    @Override
    public void checkQueryIntegrity(Identity identity, AccessControlContext context, String query) {
        AccessDeniedException.denyQueryIntegrityCheck();
    }

    @Override
    public Set<String> filterCatalogs(Identity identity, AccessControlContext context, Set<String> catalogs) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanAccessCatalog(Identity identity, AccessControlContext context, String catalogName) {
        AccessDeniedException.denyCatalogAccess((String)catalogName);
    }

    @Override
    public void checkCanCreateSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName) {
        AccessDeniedException.denyCreateSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanDropSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName) {
        AccessDeniedException.denyDropSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanRenameSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema((String)schemaName.toString(), (String)newSchemaName);
    }

    @Override
    public void checkCanCreateTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyCreateTable((String)tableName.toString());
    }

    @Override
    public void checkCanDropTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDropTable((String)tableName.toString());
    }

    @Override
    public void checkCanRenameTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
    }

    @Override
    public void checkCanShowTablesMetadata(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyShowTablesMetadata((String)schema.toString());
    }

    @Override
    public Set<SchemaTableName> filterTables(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanShowSchemas(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName) {
        AccessDeniedException.denyShowSchemas();
    }

    @Override
    public Set<String> filterSchemas(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName, Set<String> schemaNames) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanAddColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyAddColumn((String)tableName.toString());
    }

    @Override
    public void checkCanRenameColumn(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyRenameColumn((String)tableName.toString());
    }

    @Override
    public void checkCanDropColumn(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDropColumn((String)tableName.toString());
    }

    @Override
    public void checkCanInsertIntoTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyInsertTable((String)tableName.toString());
    }

    @Override
    public void checkCanDeleteFromTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDeleteTable((String)tableName.toString());
    }

    @Override
    public void checkCanTruncateTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyTruncateTable((String)tableName.toString());
    }

    @Override
    public void checkCanCreateView(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName viewName) {
        AccessDeniedException.denyCreateView((String)viewName.toString());
    }

    @Override
    public void checkCanDropView(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName viewName) {
        AccessDeniedException.denyDropView((String)viewName.toString());
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (Identity)identity);
    }

    @Override
    public void checkCanGrantTablePrivilege(TransactionId transactionId, Identity identity, AccessControlContext context, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanRevokeTablePrivilege(TransactionId transactionId, Identity identity, AccessControlContext context, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
    }

    @Override
    public void checkCanSetCatalogSessionProperty(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
    }

    @Override
    public void checkCanSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<Subfield> columnOrSubfieldNames) {
        AccessDeniedException.denySelectColumns((String)tableName.toString(), (Collection)((Collection)columnOrSubfieldNames.stream().map(subfield -> subfield.getRootName()).collect(ImmutableSet.toImmutableSet())));
    }

    @Override
    public void checkCanCreateRole(TransactionId transactionId, Identity identity, AccessControlContext context, String role, Optional<PrestoPrincipal> grantor, String catalogName) {
        AccessDeniedException.denyCreateRole((String)role);
    }

    @Override
    public void checkCanDropRole(TransactionId transactionId, Identity identity, AccessControlContext context, String role, String catalogName) {
        AccessDeniedException.denyDropRole((String)role);
    }

    @Override
    public void checkCanGrantRoles(TransactionId transactionId, Identity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    @Override
    public void checkCanRevokeRoles(TransactionId transactionId, Identity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    @Override
    public void checkCanSetRole(TransactionId requiredTransactionId, Identity identity, AccessControlContext context, String role, String catalog) {
        AccessDeniedException.denySetRole((String)role);
    }

    @Override
    public void checkCanShowRoles(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName) {
        AccessDeniedException.denyShowRoles((String)catalogName);
    }

    @Override
    public void checkCanShowCurrentRoles(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName) {
        AccessDeniedException.denyShowCurrentRoles((String)catalogName);
    }

    @Override
    public void checkCanShowRoleGrants(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName) {
        AccessDeniedException.denyShowRoleGrants((String)catalogName);
    }
}

