/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HeaderName;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.server.AsyncResponseHandler;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.airlift.units.Duration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;

public class ResourceManagerProxy {
    private final InternalNodeManager internalNodeManager;
    private final HttpClient httpClient;
    private final Duration asyncTimeout;
    private final Executor executor;

    @Inject
    private ResourceManagerProxy(InternalNodeManager internalNodeManager, @ForResourceManager HttpClient httpClient, ResourceManagerConfig resourceManagerConfig, @ForResourceManager ListeningExecutorService executor) {
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.asyncTimeout = Objects.requireNonNull(resourceManagerConfig, "resourceManagerConfig is null").getProxyAsyncTimeout();
        this.executor = (Executor)Objects.requireNonNull(executor, "executor is null");
    }

    public void performRequest(HttpServletRequest servletRequest, AsyncResponse asyncResponse, URI remoteUri) {
        try {
            InputStreamBodyGenerator bodyGenerator = new InputStreamBodyGenerator((InputStream)servletRequest.getInputStream());
            Request request = this.createRequest(servletRequest, servletRequest.getMethod(), remoteUri, bodyGenerator);
            HttpClient.HttpResponseFuture proxyResponse = this.httpClient.executeAsync(request, (com.facebook.airlift.http.client.ResponseHandler)new ResponseHandler());
            ListenableFuture future = Futures.transform((ListenableFuture)proxyResponse, this::toResponse, (Executor)this.executor);
            this.setupAsyncResponse(servletRequest, asyncResponse, (ListenableFuture<Response>)future);
        }
        catch (IOException e) {
            asyncResponse.resume((Throwable)e);
        }
    }

    private Request createRequest(HttpServletRequest servletRequest, String httpMethod, URI remoteUri, BodyGenerator bodyGenerator) {
        Request.Builder requestBuilder = new Request.Builder().setMethod(httpMethod).setUri(remoteUri).setPreserveAuthorizationOnRedirect(true).setBodyGenerator(bodyGenerator);
        for (String name : Collections.list(servletRequest.getHeaderNames())) {
            if (ResourceManagerProxy.isPrestoHeader(name) || name.equalsIgnoreCase("Cookie")) {
                for (String value : Collections.list(servletRequest.getHeaders(name))) {
                    requestBuilder.addHeader(name, value);
                }
                continue;
            }
            if (!name.equalsIgnoreCase("User-Agent")) continue;
            for (String value : Collections.list(servletRequest.getHeaders(name))) {
                requestBuilder.addHeader(name, "[Resource Manager] " + value);
            }
        }
        StringBuilder xForwardedFor = new StringBuilder();
        if (servletRequest.getHeader("X-Forwarded-For") != null) {
            xForwardedFor.append(servletRequest.getHeader("X-Forwarded-For") + ",");
        }
        xForwardedFor.append(servletRequest.getRemoteAddr());
        requestBuilder.addHeader("X-Forwarded-For", xForwardedFor.toString());
        return requestBuilder.build();
    }

    private static boolean isPrestoHeader(String name) {
        return name.toLowerCase(Locale.ENGLISH).startsWith("x-presto-");
    }

    private Response toResponse(ProxyResponse input) {
        Response.ResponseBuilder entity = Response.status((int)input.getStatusCode()).entity((Object)input.getBody());
        input.getHeaders().forEach((headerName, value) -> entity.header(headerName.toString(), value));
        return entity.build();
    }

    private void setupAsyncResponse(HttpServletRequest servletRequest, AsyncResponse asyncResponse, ListenableFuture<Response> future) {
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, future, (Executor)this.executor).withTimeout(this.asyncTimeout, () -> Response.status((Response.Status)Response.Status.GATEWAY_TIMEOUT).type("text/plain").entity((Object)String.format("Request to remote Presto server (%s), current node (%s), timed out after %s", servletRequest.getRemoteAddr(), this.internalNodeManager.getCurrentNode().getNodeIdentifier(), this.asyncTimeout.toString())).build());
    }

    private static class ProxyResponse {
        private final int statusCode;
        private final ListMultimap<HeaderName, String> headers;
        private final InputStream body;

        ProxyResponse(int statusCode, ListMultimap<HeaderName, String> headers, InputStream body) {
            this.statusCode = statusCode;
            this.headers = Objects.requireNonNull(headers, "headers is null");
            this.body = Objects.requireNonNull(body, "body is null");
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public ListMultimap<HeaderName, String> getHeaders() {
            return this.headers;
        }

        public InputStream getBody() {
            return this.body;
        }
    }

    private static class ResponseHandler
    implements com.facebook.airlift.http.client.ResponseHandler {
        private ResponseHandler() {
        }

        public ProxyResponse handleException(Request request, Exception exception) {
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            String message = String.format("Exception receiving response from %s: %s", request.getUri(), sw.toString());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
            return new ProxyResponse(HttpStatus.INTERNAL_SERVER_ERROR.code(), (ListMultimap<HeaderName, String>)ImmutableListMultimap.of((Object)HeaderName.of((String)"Content-Type"), (Object)"text/plain"), inputStream);
        }

        public ProxyResponse handle(Request request, com.facebook.airlift.http.client.Response response) {
            try {
                return new ProxyResponse(response.getStatusCode(), (ListMultimap<HeaderName, String>)response.getHeaders(), response.getInputStream());
            }
            catch (IOException e) {
                return this.handleException(request, e);
            }
        }
    }

    private static class InputStreamBodyGenerator
    implements BodyGenerator {
        private final InputStream inputStream;
        private final AtomicBoolean called = new AtomicBoolean();

        public InputStreamBodyGenerator(InputStream inputStream) {
            this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
        }

        public void write(OutputStream outputStream) throws Exception {
            Verify.verify((boolean)this.called.compareAndSet(false, true), (String)"Already read servlet request body", (Object[])new Object[0]);
            try {
                ByteStreams.copy((InputStream)this.inputStream, (OutputStream)outputStream);
            }
            finally {
                this.inputStream.close();
            }
        }
    }
}

