/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;

@ScalarFunction(value="repeat", calledOnNullInput=true)
@Description(value="Repeat an element for a given number of times")
public final class RepeatFunction {
    private static final long MAX_RESULT_ENTRIES = 10000L;
    private static final long MAX_SIZE_IN_BYTES = 1000000L;

    private RepeatFunction() {
    }

    @SqlType(value="array(unknown)")
    public static Block repeat(@SqlNullable @SqlType(value="unknown") Boolean element, @SqlType(value="integer") long count) {
        Failures.checkCondition(element == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "expect null values", new Object[0]);
        BlockBuilder blockBuilder = RepeatFunction.createBlockBuilder((Type)UnknownType.UNKNOWN, count);
        return RepeatFunction.repeatNullValues(blockBuilder, count);
    }

    @TypeParameter(value="T")
    @SqlType(value="array(T)")
    public static Block repeat(@TypeParameter(value="T") Type type, @SqlNullable @SqlType(value="T") Object element, @SqlType(value="integer") long count) {
        BlockBuilder blockBuilder = RepeatFunction.createBlockBuilder(type, count);
        if (element == null) {
            return RepeatFunction.repeatNullValues(blockBuilder, count);
        }
        if (count > 0L) {
            type.writeObject(blockBuilder, element);
            RepeatFunction.checkMaxSize(blockBuilder.getSizeInBytes(), count);
        }
        int i = 1;
        while ((long)i < count) {
            type.writeObject(blockBuilder, element);
            ++i;
        }
        return blockBuilder.build();
    }

    @TypeParameter(value="T")
    @SqlType(value="array(T)")
    public static Block repeat(@TypeParameter(value="T") Type type, @SqlNullable @SqlType(value="T") Long element, @SqlType(value="integer") long count) {
        BlockBuilder blockBuilder = RepeatFunction.createBlockBuilder(type, count);
        if (element == null) {
            return RepeatFunction.repeatNullValues(blockBuilder, count);
        }
        int i = 0;
        while ((long)i < count) {
            type.writeLong(blockBuilder, element.longValue());
            ++i;
        }
        return blockBuilder.build();
    }

    @TypeParameter(value="T")
    @SqlType(value="array(T)")
    public static Block repeat(@TypeParameter(value="T") Type type, @SqlNullable @SqlType(value="T") Slice element, @SqlType(value="integer") long count) {
        BlockBuilder blockBuilder = RepeatFunction.createBlockBuilder(type, count);
        if (element == null) {
            return RepeatFunction.repeatNullValues(blockBuilder, count);
        }
        if (count > 0L) {
            type.writeSlice(blockBuilder, element);
            RepeatFunction.checkMaxSize(blockBuilder.getSizeInBytes(), count);
        }
        int i = 1;
        while ((long)i < count) {
            type.writeSlice(blockBuilder, element);
            ++i;
        }
        return blockBuilder.build();
    }

    @TypeParameter(value="T")
    @SqlType(value="array(T)")
    public static Block repeat(@TypeParameter(value="T") Type type, @SqlNullable @SqlType(value="T") Boolean element, @SqlType(value="integer") long count) {
        BlockBuilder blockBuilder = RepeatFunction.createBlockBuilder(type, count);
        if (element == null) {
            return RepeatFunction.repeatNullValues(blockBuilder, count);
        }
        int i = 0;
        while ((long)i < count) {
            type.writeBoolean(blockBuilder, element.booleanValue());
            ++i;
        }
        return blockBuilder.build();
    }

    @TypeParameter(value="T")
    @SqlType(value="array(T)")
    public static Block repeat(@TypeParameter(value="T") Type type, @SqlNullable @SqlType(value="T") Double element, @SqlType(value="integer") long count) {
        BlockBuilder blockBuilder = RepeatFunction.createBlockBuilder(type, count);
        if (element == null) {
            return RepeatFunction.repeatNullValues(blockBuilder, count);
        }
        int i = 0;
        while ((long)i < count) {
            type.writeDouble(blockBuilder, element.doubleValue());
            ++i;
        }
        return blockBuilder.build();
    }

    private static BlockBuilder createBlockBuilder(Type type, long count) {
        Failures.checkCondition(count <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "count argument of repeat function must be less than or equal to 10000", new Object[0]);
        Failures.checkCondition(count >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "count argument of repeat function must be greater than or equal to 0", new Object[0]);
        return type.createBlockBuilder(null, Math.toIntExact(count));
    }

    private static Block repeatNullValues(BlockBuilder blockBuilder, long count) {
        int i = 0;
        while ((long)i < count) {
            blockBuilder.appendNull();
            ++i;
        }
        return blockBuilder.build();
    }

    private static void checkMaxSize(long bytes, long count) {
        Failures.checkCondition(bytes <= (1000000L + count) / count, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of repeat function must not take more than 1000000 bytes", new Object[0]);
    }
}

