/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public class MapSubscriptOperator
extends SqlOperator {
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, MissingKeyExceptionFactory.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Type.class, SqlFunctionProperties.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, MissingKeyExceptionFactory.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Type.class, SqlFunctionProperties.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, MissingKeyExceptionFactory.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Type.class, SqlFunctionProperties.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, MissingKeyExceptionFactory.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Type.class, SqlFunctionProperties.class, Block.class, Slice.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, MissingKeyExceptionFactory.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Type.class, SqlFunctionProperties.class, Block.class, Object.class);
    private final boolean legacyMissingKey;

    public MapSubscriptOperator(boolean legacyMissingKey) {
        super(OperatorType.SUBSCRIPT, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"K"), (Object)Signature.typeVariable((String)"V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"V"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V)"), (Object)TypeSignature.parseTypeSignature((String)"K")));
        this.legacyMissingKey = legacyMissingKey;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        MethodHandle keyNativeHashCode = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.HASH_CODE, TypeSignatureProvider.fromTypes(keyType))).getMethodHandle();
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyNativeEquals = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(keyType, keyType))).getMethodHandle();
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle methodHandle = keyType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (keyType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (keyType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (keyType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        methodHandle = MethodHandles.insertArguments(methodHandle, 0, this.legacyMissingKey);
        MissingKeyExceptionFactory missingKeyExceptionFactory = new MissingKeyExceptionFactory(functionAndTypeManager, keyType);
        methodHandle = methodHandle.bindTo(missingKeyExceptionFactory).bindTo(keyNativeHashCode).bindTo(keyBlockNativeEquals).bindTo(keyBlockHashCode).bindTo(valueType);
        methodHandle = methodHandle.asType(methodHandle.type().changeReturnType(Primitives.wrap((Class)valueType.getJavaType())));
        return new BuiltInScalarFunctionImplementation(true, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, MissingKeyExceptionFactory missingKeyExceptionFactory, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode, Type valueType, SqlFunctionProperties properties, Block map, boolean key) {
        int valuePosition;
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        try {
            valuePosition = mapBlock.seekKeyExact(key, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
        if (valuePosition == -1) {
            if (legacyMissingKey) {
                return null;
            }
            throw missingKeyExceptionFactory.create(properties, key);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, MissingKeyExceptionFactory missingKeyExceptionFactory, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode, Type valueType, SqlFunctionProperties properties, Block map, long key) {
        int valuePosition;
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        try {
            valuePosition = mapBlock.seekKeyExact(key, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
        if (valuePosition == -1) {
            if (legacyMissingKey) {
                return null;
            }
            throw missingKeyExceptionFactory.create(properties, key);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, MissingKeyExceptionFactory missingKeyExceptionFactory, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode, Type valueType, SqlFunctionProperties properties, Block map, double key) {
        int valuePosition;
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        try {
            valuePosition = mapBlock.seekKeyExact(key, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
        if (valuePosition == -1) {
            if (legacyMissingKey) {
                return null;
            }
            throw missingKeyExceptionFactory.create(properties, key);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, MissingKeyExceptionFactory missingKeyExceptionFactory, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode, Type valueType, SqlFunctionProperties properties, Block map, Slice key) {
        int valuePosition;
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        try {
            valuePosition = mapBlock.seekKeyExact(key, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
        if (valuePosition == -1) {
            if (legacyMissingKey) {
                return null;
            }
            throw missingKeyExceptionFactory.create(properties, key);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, MissingKeyExceptionFactory missingKeyExceptionFactory, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode, Type valueType, SqlFunctionProperties properties, Block map, Object key) {
        int valuePosition;
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        try {
            valuePosition = mapBlock.seekKeyExact((Block)key, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
        if (valuePosition == -1) {
            if (legacyMissingKey) {
                return null;
            }
            throw missingKeyExceptionFactory.create(properties, key);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    private static class MissingKeyExceptionFactory {
        private final InterpretedFunctionInvoker functionInvoker;
        private final FunctionHandle castFunction;

        public MissingKeyExceptionFactory(FunctionAndTypeManager functionAndTypeManager, Type keyType) {
            this.functionInvoker = new InterpretedFunctionInvoker(functionAndTypeManager);
            FunctionHandle castFunction = null;
            try {
                castFunction = functionAndTypeManager.lookupCast(CastType.CAST, keyType, (Type)VarcharType.VARCHAR);
            }
            catch (PrestoException prestoException) {
                // empty catch block
            }
            this.castFunction = castFunction;
        }

        public PrestoException create(SqlFunctionProperties properties, Object value) {
            if (this.castFunction != null) {
                try {
                    Slice varcharValue = (Slice)this.functionInvoker.invoke(this.castFunction, properties, value);
                    return new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Key not present in map: %s", varcharValue.toStringUtf8()));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key not present in map");
        }
    }
}

