/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.AbstractVariableWidthBlock;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.operator.MoreByteArrays;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class VariableWidthBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 5;
    private static final String NAME = "VARIABLE_WIDTH";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlockEncodingBuffer.class).instanceSize();
    private byte[] sliceBuffer;
    private int sliceBufferIndex;
    private int estimatedSliceBufferMaxCapacity;
    private byte[] offsetsBuffer;
    private int offsetsBufferIndex;
    private int estimatedOffsetBufferMaxCapacity;
    private int lastOffset;

    public VariableWidthBlockEncodingBuffer(ArrayAllocator bufferAllocator, boolean isNested) {
        super(bufferAllocator, isNested);
    }

    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        int[] positions = this.getPositions();
        for (int i = 0; i < this.positionCount; ++i) {
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + (5 + this.decodedBlock.getSliceLength(positions[i]));
        }
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendOffsetsAndSlices();
        this.appendNulls();
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        VariableWidthBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        output.writeInt(this.bufferedPositionCount);
        if (this.offsetsBufferIndex > 0) {
            output.appendBytes(this.offsetsBuffer, 0, this.offsetsBufferIndex);
        }
        this.serializeNullsTo(output);
        output.writeInt(this.sliceBufferIndex);
        if (this.sliceBufferIndex > 0) {
            output.appendBytes(this.sliceBuffer, 0, this.sliceBufferIndex);
        }
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.sliceBufferIndex = 0;
        this.offsetsBufferIndex = 0;
        this.lastOffset = 0;
        this.flushed = true;
        this.resetNullsBuffer();
    }

    @Override
    public void noMoreBatches() {
        super.noMoreBatches();
        if (this.flushed) {
            if (this.sliceBuffer != null) {
                this.bufferAllocator.returnArray(this.sliceBuffer);
                this.sliceBuffer = null;
            }
            if (this.offsetsBuffer != null) {
                this.bufferAllocator.returnArray(this.offsetsBuffer);
                this.offsetsBuffer = null;
            }
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public long getSerializedSizeInBytes() {
        return (long)(NAME.length() + 4 + 4 + this.offsetsBufferIndex + 4 + this.sliceBufferIndex) + this.getNullsBufferSerializedSizeInBytes();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("estimatedSliceBufferMaxCapacity", this.estimatedSliceBufferMaxCapacity).add("sliceBufferCapacity", this.sliceBuffer == null ? 0 : this.sliceBuffer.length).add("sliceBufferIndex", this.sliceBufferIndex).add("estimatedOffsetBufferMaxCapacity", this.estimatedOffsetBufferMaxCapacity).add("offsetsBufferCapacity", this.offsetsBuffer == null ? 0 : this.offsetsBuffer.length).add("offsetsBufferIndex", this.offsetsBufferIndex).toString();
    }

    @VisibleForTesting
    int getEstimatedOffsetBufferMaxCapacity() {
        return this.estimatedOffsetBufferMaxCapacity;
    }

    @VisibleForTesting
    int getEstimatedSliceBufferMaxCapacity() {
        return this.estimatedSliceBufferMaxCapacity;
    }

    @Override
    int getEstimatedValueBufferMaxCapacity() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setupDecodedBlockAndMapPositions(DecodedBlockNode decodedBlockNode, int partitionBufferCapacity, double decodedBlockPageSizeFraction) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        this.decodedBlock = (Block)this.mapPositionsToNestedBlock(decodedBlockNode).getDecodedBlock();
        double targetBufferSize = (double)partitionBufferCapacity * decodedBlockPageSizeFraction;
        int positionCount = this.decodedBlock.getPositionCount();
        if (positionCount == 0) {
            this.estimatedSliceBufferMaxCapacity = 0;
            this.setEstimatedNullsBufferMaxCapacity(0);
            this.estimatedOffsetBufferMaxCapacity = 0;
        } else {
            int inclusivePositionSize = Math.toIntExact(this.decodedBlock.getLogicalSizeInBytes() / (long)positionCount);
            this.estimatedSliceBufferMaxCapacity = VariableWidthBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, (((VariableWidthBlock)this.decodedBlock).getPositionOffset(this.decodedBlock.getPositionCount()) - ((VariableWidthBlock)this.decodedBlock).getPositionOffset(0)) / positionCount, inclusivePositionSize);
            this.setEstimatedNullsBufferMaxCapacity(VariableWidthBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 1, inclusivePositionSize));
            this.estimatedOffsetBufferMaxCapacity = VariableWidthBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 4, inclusivePositionSize);
        }
    }

    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        if (this.positionCount == 0) {
            return;
        }
        int[] positions = this.getPositions();
        for (int i = 0; i < positionCount; ++i) {
            for (int j = positionOffsets[i]; j < positionOffsets[i + 1]; ++j) {
                int n = i;
                serializedRowSizes[n] = serializedRowSizes[n] + (5 + this.decodedBlock.getSliceLength(positions[j]));
            }
        }
    }

    private void appendOffsetsAndSlices() {
        int position;
        int i;
        this.offsetsBuffer = Arrays.ensureCapacity((byte[])this.offsetsBuffer, (int)(this.offsetsBufferIndex + this.batchSize * Unsafe.ARRAY_INT_INDEX_SCALE), (int)this.estimatedOffsetBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        AbstractVariableWidthBlock variableWidthBlock = (AbstractVariableWidthBlock)this.decodedBlock;
        int[] positions = this.getPositions();
        Slice rawSlice = variableWidthBlock.getRawSlice(0);
        byte[] sliceBase = (byte[])rawSlice.getBase();
        int sliceAddress = (int)rawSlice.getAddress() - Unsafe.ARRAY_BYTE_BASE_OFFSET;
        int totalSliceLength = 0;
        for (i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            position = positions[i];
            totalSliceLength += variableWidthBlock.getPositionOffset(position + 1) - variableWidthBlock.getPositionOffset(position);
        }
        this.sliceBuffer = Arrays.ensureCapacity((byte[])this.sliceBuffer, (int)(this.sliceBufferIndex + totalSliceLength), (int)this.estimatedSliceBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.MEDIUM, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        for (i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            position = positions[i];
            int beginOffset = variableWidthBlock.getPositionOffset(position);
            int endOffset = variableWidthBlock.getPositionOffset(position + 1);
            int length = endOffset - beginOffset;
            this.lastOffset += length;
            this.offsetsBufferIndex = UncheckedByteArrays.setIntUnchecked(this.offsetsBuffer, this.offsetsBufferIndex, this.lastOffset);
            if (length <= 0) continue;
            this.sliceBufferIndex = MoreByteArrays.setBytes(this.sliceBuffer, this.sliceBufferIndex, sliceBase, beginOffset + sliceAddress, length);
        }
    }
}

