/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.StatisticalDigest;
import com.facebook.presto.operator.aggregation.StatisticalDigestFactory;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.tdigest.TDigest;
import io.airlift.slice.Slice;
import java.util.Objects;
import java.util.function.Function;
import org.openjdk.jol.info.ClassLayout;

public class StatisticalDigestStateFactory<T>
implements AccumulatorStateFactory<StatisticalDigestState> {
    private final Function<Slice, StatisticalDigest<T>> deserializer;

    public static StatisticalDigestStateFactory<TDigest> createTDigestFactory() {
        return new StatisticalDigestStateFactory<TDigest>(slice -> StatisticalDigestFactory.createStatisticalTDigest(TDigest.createTDigest(slice)));
    }

    public static StatisticalDigestStateFactory<QuantileDigest> createQuantileDigestFactory() {
        return new StatisticalDigestStateFactory<QuantileDigest>(slice -> StatisticalDigestFactory.createStatisticalQuantileDigest(new QuantileDigest(slice)));
    }

    private StatisticalDigestStateFactory(Function<Slice, StatisticalDigest<T>> deserializer) {
        this.deserializer = deserializer;
    }

    public StatisticalDigestState createSingleState() {
        return new SingleStatisticalDigestState<T>(this.deserializer);
    }

    public Class<? extends StatisticalDigestState> getSingleStateClass() {
        return SingleStatisticalDigestState.class;
    }

    public StatisticalDigestState createGroupedState() {
        return new GroupedStatisticalDigestState<T>(this.deserializer);
    }

    public Class<? extends StatisticalDigestState> getGroupedStateClass() {
        return GroupedStatisticalDigestState.class;
    }

    public static class SingleStatisticalDigestState<T>
    implements StatisticalDigestState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleStatisticalDigestState.class).instanceSize();
        private final Function<Slice, StatisticalDigest<T>> deserializer;
        private StatisticalDigest<T> digest;

        public SingleStatisticalDigestState(Function<Slice, StatisticalDigest<T>> deserializer) {
            this.deserializer = deserializer;
        }

        public StatisticalDigest getStatisticalDigest() {
            return this.digest;
        }

        public void setStatisticalDigest(StatisticalDigest value) {
            this.digest = value;
        }

        @Override
        public void addMemoryUsage(long value) {
        }

        public StatisticalDigest deserialize(Slice slice) {
            return this.deserializer.apply(slice);
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.digest != null) {
                estimatedSize += this.digest.estimatedInMemorySizeInBytes();
            }
            return estimatedSize;
        }
    }

    public static class GroupedStatisticalDigestState<T>
    extends AbstractGroupedAccumulatorState
    implements StatisticalDigestState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedStatisticalDigestState.class).instanceSize();
        private final ObjectBigArray<StatisticalDigest<T>> digests = new ObjectBigArray();
        private long size;
        private final Function<Slice, StatisticalDigest<T>> deserializer;

        public GroupedStatisticalDigestState(Function<Slice, StatisticalDigest<T>> deserializer) {
            this.deserializer = deserializer;
        }

        public void ensureCapacity(long size) {
            this.digests.ensureCapacity(size);
        }

        public StatisticalDigest getStatisticalDigest() {
            return (StatisticalDigest)this.digests.get(this.getGroupId());
        }

        public void setStatisticalDigest(StatisticalDigest value) {
            Objects.requireNonNull(value, "value is null");
            this.digests.set(this.getGroupId(), (Object)value);
        }

        @Override
        public void addMemoryUsage(long value) {
            this.size += value;
        }

        public StatisticalDigest deserialize(Slice slice) {
            return this.deserializer.apply(slice);
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.digests.sizeOf();
        }
    }
}

