/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.multimapagg;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.multimapagg.GroupedMultimapAggregationState;
import com.facebook.presto.operator.aggregation.multimapagg.LegacyGroupedMultimapAggregationState;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationState;
import com.facebook.presto.operator.aggregation.multimapagg.SingleMultimapAggregationState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class MultimapAggregationStateFactory
implements AccumulatorStateFactory<MultimapAggregationState> {
    private final Type keyType;
    private final Type valueType;
    private final MultimapAggGroupImplementation implementation;

    public MultimapAggregationStateFactory(Type keyType, Type valueType, MultimapAggGroupImplementation implementation) {
        this.keyType = Objects.requireNonNull(keyType);
        this.valueType = Objects.requireNonNull(valueType);
        this.implementation = Objects.requireNonNull(implementation);
    }

    public MultimapAggregationState createSingleState() {
        return new SingleMultimapAggregationState(this.keyType, this.valueType);
    }

    public Class<? extends MultimapAggregationState> getSingleStateClass() {
        return SingleMultimapAggregationState.class;
    }

    public MultimapAggregationState createGroupedState() {
        switch (this.implementation) {
            case NEW: {
                return new GroupedMultimapAggregationState(this.keyType, this.valueType);
            }
            case LEGACY: {
                return new LegacyGroupedMultimapAggregationState(this.keyType, this.valueType);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Unexpected group enum type %s", new Object[]{this.implementation}));
    }

    public Class<? extends MultimapAggregationState> getGroupedStateClass() {
        switch (this.implementation) {
            case NEW: {
                return GroupedMultimapAggregationState.class;
            }
            case LEGACY: {
                return LegacyGroupedMultimapAggregationState.class;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Unexpected group enum type %s", new Object[]{this.implementation}));
    }
}

