/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.arrayagg;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.SetOfValues;
import com.facebook.presto.operator.aggregation.arrayagg.SetAggregationStateSerializer;
import com.facebook.presto.operator.aggregation.state.SetAggregationState;
import com.facebook.presto.operator.aggregation.state.SetAggregationStateFactory;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class SetAggregationFunction
extends SqlAggregationFunction {
    public static final SetAggregationFunction SET_AGG = new SetAggregationFunction();
    private static final String NAME = "set_agg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(SetAggregationFunction.class, "input", Type.class, SetAggregationState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(SetAggregationFunction.class, "combine", SetAggregationState.class, SetAggregationState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(SetAggregationFunction.class, "output", SetAggregationState.class, BlockBuilder.class);

    public SetAggregationFunction() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    public String getDescription() {
        return "return an array of values";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type type = boundVariables.getTypeVariable("T");
        ArrayType outputType = (ArrayType)functionAndTypeManager.getParameterizedType("array", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)type.getTypeSignature())));
        return SetAggregationFunction.generateAggregation(type, outputType);
    }

    @Override
    public boolean isCalledOnNullInput() {
        return true;
    }

    private static InternalAggregationFunction generateAggregation(Type type, ArrayType outputType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(SetAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        SetAggregationStateSerializer stateSerializer = new SetAggregationStateSerializer(outputType);
        SetAggregationStateFactory stateFactory = new SetAggregationStateFactory(type);
        Type intermediateType = stateSerializer.getSerializedType();
        List<AggregationMetadata.ParameterMetadata> inputParameterMetadata = SetAggregationFunction.createInputParameterMetadata(type);
        Class<SetAggregationState> stateInterface = SetAggregationState.class;
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), inputParameterMetadata, INPUT_FUNCTION.bindTo(type), COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, stateFactory)), (Type)outputType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)outputType, true, true, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type type, SetAggregationState state, Block block, int position) {
        SetOfValues set = state.get();
        if (set == null) {
            set = new SetOfValues(type);
            state.set(set);
        }
        long startSize = set.estimatedInMemorySize();
        set.add(block, position);
        state.addMemoryUsage(set.estimatedInMemorySize() - startSize);
    }

    public static void combine(SetAggregationState state, SetAggregationState otherState) {
        if (state.get() != null && otherState.get() != null) {
            SetOfValues otherSet = otherState.get();
            Block otherValues = otherSet.getvalues();
            SetOfValues set = state.get();
            long startSize = set.estimatedInMemorySize();
            for (int i = 0; i < otherValues.getPositionCount(); ++i) {
                set.add(otherValues, i);
            }
            state.addMemoryUsage(set.estimatedInMemorySize() - startSize);
        } else if (state.get() == null) {
            state.set(otherState.get());
        }
    }

    public static void output(SetAggregationState state, BlockBuilder out) {
        SetOfValues set = state.get();
        if (set == null) {
            out.appendNull();
        } else {
            set.serialize(out);
        }
    }
}

