/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.client.DriftClient;
import com.facebook.drift.transport.client.MessageTooLargeException;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.ThriftBufferResult;
import com.facebook.presto.operator.PageBufferClient;
import com.facebook.presto.operator.PageTooLargeException;
import com.facebook.presto.operator.RpcShuffleClient;
import com.facebook.presto.server.thrift.ThriftTaskClient;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ThriftRpcShuffleClient
implements RpcShuffleClient {
    private final ThriftTaskClient thriftClient;
    private final TaskId taskId;
    private final OutputBuffers.OutputBufferId outputBufferId;

    public ThriftRpcShuffleClient(DriftClient<ThriftTaskClient> driftClient, URI location) {
        Objects.requireNonNull(location, "location is null");
        this.thriftClient = (ThriftTaskClient)Objects.requireNonNull(driftClient, "thriftClient is null").get(Optional.of(location.getAuthority()));
        String[] paths = location.getPath().split("/");
        this.taskId = TaskId.valueOf(paths[3]);
        this.outputBufferId = OutputBuffers.OutputBufferId.fromString(paths[5]);
    }

    @Override
    public ListenableFuture<PageBufferClient.PagesResponse> getResults(long token, DataSize maxResponseSize) {
        ListenableFuture<ThriftBufferResult> future = this.thriftClient.getResults(this.taskId, this.outputBufferId, token, maxResponseSize.toBytes());
        return Futures.transform(future, result -> PageBufferClient.PagesResponse.createPagesResponse(result.getTaskInstanceId(), result.getToken(), result.getNextToken(), result.getSerializedPages(), result.isBufferComplete()), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void acknowledgeResultsAsync(long nextToken) {
        this.thriftClient.acknowledgeResults(this.taskId, this.outputBufferId, nextToken);
    }

    @Override
    public ListenableFuture<?> abortResults() {
        return this.thriftClient.abortResults(this.taskId, this.outputBufferId);
    }

    @Override
    public Throwable rewriteException(Throwable throwable) {
        if (throwable instanceof MessageTooLargeException) {
            return new PageTooLargeException(throwable);
        }
        return throwable;
    }
}

