/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorInfoUnion;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@ThriftStruct
@Immutable
public class OperatorStats {
    private final int stageId;
    private final int stageExecutionId;
    private final int pipelineId;
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final long totalDrivers;
    private final long addInputCalls;
    private final Duration addInputWall;
    private final Duration addInputCpu;
    private final DataSize addInputAllocation;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize inputDataSize;
    private final long inputPositions;
    private final double sumSquaredInputPositions;
    private final long getOutputCalls;
    private final Duration getOutputWall;
    private final Duration getOutputCpu;
    private final DataSize getOutputAllocation;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final Duration additionalCpu;
    private final Duration blockedWall;
    private final long finishCalls;
    private final Duration finishWall;
    private final Duration finishCpu;
    private final DataSize finishAllocation;
    private final DataSize userMemoryReservation;
    private final DataSize revocableMemoryReservation;
    private final DataSize systemMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakSystemMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize spilledDataSize;
    private final Optional<BlockedReason> blockedReason;
    @Nullable
    private final OperatorInfo info;
    @Nullable
    private final OperatorInfoUnion infoUnion;
    private final RuntimeStats runtimeStats;

    @JsonCreator
    public OperatorStats(@JsonProperty(value="stageId") int stageId, @JsonProperty(value="stageExecutionId") int stageExecutionId, @JsonProperty(value="pipelineId") int pipelineId, @JsonProperty(value="operatorId") int operatorId, @JsonProperty(value="planNodeId") PlanNodeId planNodeId, @JsonProperty(value="operatorType") String operatorType, @JsonProperty(value="totalDrivers") long totalDrivers, @JsonProperty(value="addInputCalls") long addInputCalls, @JsonProperty(value="addInputWall") Duration addInputWall, @JsonProperty(value="addInputCpu") Duration addInputCpu, @JsonProperty(value="addInputAllocation") DataSize addInputAllocation, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="inputDataSize") DataSize inputDataSize, @JsonProperty(value="inputPositions") long inputPositions, @JsonProperty(value="sumSquaredInputPositions") double sumSquaredInputPositions, @JsonProperty(value="getOutputCalls") long getOutputCalls, @JsonProperty(value="getOutputWall") Duration getOutputWall, @JsonProperty(value="getOutputCpu") Duration getOutputCpu, @JsonProperty(value="getOutputAllocation") DataSize getOutputAllocation, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="additionalCpu") Duration additionalCpu, @JsonProperty(value="blockedWall") Duration blockedWall, @JsonProperty(value="finishCalls") long finishCalls, @JsonProperty(value="finishWall") Duration finishWall, @JsonProperty(value="finishCpu") Duration finishCpu, @JsonProperty(value="finishAllocation") DataSize finishAllocation, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="revocableMemoryReservation") DataSize revocableMemoryReservation, @JsonProperty(value="systemMemoryReservation") DataSize systemMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakSystemMemoryReservation") DataSize peakSystemMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="spilledDataSize") DataSize spilledDataSize, @JsonProperty(value="blockedReason") Optional<BlockedReason> blockedReason, @Nullable @JsonProperty(value="info") OperatorInfo info, @JsonProperty(value="runtimeStats") RuntimeStats runtimeStats) {
        this.stageId = stageId;
        this.stageExecutionId = stageExecutionId;
        this.pipelineId = pipelineId;
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.totalDrivers = totalDrivers;
        this.addInputCalls = addInputCalls;
        this.addInputWall = Objects.requireNonNull(addInputWall, "addInputWall is null");
        this.addInputCpu = Objects.requireNonNull(addInputCpu, "addInputCpu is null");
        this.addInputAllocation = Objects.requireNonNull(addInputAllocation, "addInputAllocation is null");
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.rawInputPositions = Objects.requireNonNull(Long.valueOf(rawInputPositions), "rawInputPositions is null");
        this.inputDataSize = Objects.requireNonNull(inputDataSize, "inputDataSize is null");
        Preconditions.checkArgument((inputPositions >= 0L ? 1 : 0) != 0, (Object)"inputPositions is negative");
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = Objects.requireNonNull(getOutputWall, "getOutputWall is null");
        this.getOutputCpu = Objects.requireNonNull(getOutputCpu, "getOutputCpu is null");
        this.getOutputAllocation = Objects.requireNonNull(getOutputAllocation, "getOutputAllocation is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "writtenDataSize is null");
        this.additionalCpu = Objects.requireNonNull(additionalCpu, "additionalCpu is null");
        this.blockedWall = Objects.requireNonNull(blockedWall, "blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = Objects.requireNonNull(finishWall, "finishWall is null");
        this.finishCpu = Objects.requireNonNull(finishCpu, "finishCpu is null");
        this.finishAllocation = Objects.requireNonNull(finishAllocation, "finishAllocation is null");
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakSystemMemoryReservation = Objects.requireNonNull(peakSystemMemoryReservation, "peakSystemMemoryReservation is null");
        this.peakTotalMemoryReservation = Objects.requireNonNull(peakTotalMemoryReservation, "peakTotalMemoryReservation is null");
        this.spilledDataSize = Objects.requireNonNull(spilledDataSize, "spilledDataSize is null");
        this.runtimeStats = runtimeStats;
        this.blockedReason = blockedReason;
        this.info = info;
        this.infoUnion = null;
    }

    @ThriftConstructor
    public OperatorStats(int stageId, int stageExecutionId, int pipelineId, int operatorId, PlanNodeId planNodeId, String operatorType, long totalDrivers, long addInputCalls, Duration addInputWall, Duration addInputCpu, DataSize addInputAllocation, DataSize rawInputDataSize, long rawInputPositions, DataSize inputDataSize, long inputPositions, double sumSquaredInputPositions, long getOutputCalls, Duration getOutputWall, Duration getOutputCpu, DataSize getOutputAllocation, DataSize outputDataSize, long outputPositions, DataSize physicalWrittenDataSize, Duration additionalCpu, Duration blockedWall, long finishCalls, Duration finishWall, Duration finishCpu, DataSize finishAllocation, DataSize userMemoryReservation, DataSize revocableMemoryReservation, DataSize systemMemoryReservation, DataSize peakUserMemoryReservation, DataSize peakSystemMemoryReservation, DataSize peakTotalMemoryReservation, DataSize spilledDataSize, Optional<BlockedReason> blockedReason, RuntimeStats runtimeStats, @Nullable OperatorInfoUnion infoUnion) {
        this.stageId = stageId;
        this.stageExecutionId = stageExecutionId;
        this.pipelineId = pipelineId;
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.totalDrivers = totalDrivers;
        this.addInputCalls = addInputCalls;
        this.addInputWall = Objects.requireNonNull(addInputWall, "addInputWall is null");
        this.addInputCpu = Objects.requireNonNull(addInputCpu, "addInputCpu is null");
        this.addInputAllocation = Objects.requireNonNull(addInputAllocation, "addInputAllocation is null");
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.rawInputPositions = Objects.requireNonNull(Long.valueOf(rawInputPositions), "rawInputPositions is null");
        this.inputDataSize = Objects.requireNonNull(inputDataSize, "inputDataSize is null");
        Preconditions.checkArgument((inputPositions >= 0L ? 1 : 0) != 0, (Object)"inputPositions is negative");
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = Objects.requireNonNull(getOutputWall, "getOutputWall is null");
        this.getOutputCpu = Objects.requireNonNull(getOutputCpu, "getOutputCpu is null");
        this.getOutputAllocation = Objects.requireNonNull(getOutputAllocation, "getOutputAllocation is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "writtenDataSize is null");
        this.additionalCpu = Objects.requireNonNull(additionalCpu, "additionalCpu is null");
        this.blockedWall = Objects.requireNonNull(blockedWall, "blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = Objects.requireNonNull(finishWall, "finishWall is null");
        this.finishCpu = Objects.requireNonNull(finishCpu, "finishCpu is null");
        this.finishAllocation = Objects.requireNonNull(finishAllocation, "finishAllocation is null");
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakSystemMemoryReservation = Objects.requireNonNull(peakSystemMemoryReservation, "peakSystemMemoryReservation is null");
        this.peakTotalMemoryReservation = Objects.requireNonNull(peakTotalMemoryReservation, "peakTotalMemoryReservation is null");
        this.spilledDataSize = Objects.requireNonNull(spilledDataSize, "spilledDataSize is null");
        this.runtimeStats = runtimeStats;
        this.blockedReason = blockedReason;
        this.infoUnion = infoUnion;
        this.info = null;
    }

    @JsonProperty
    @ThriftField(value=1)
    public int getStageId() {
        return this.stageId;
    }

    @JsonProperty
    @ThriftField(value=2)
    public int getStageExecutionId() {
        return this.stageExecutionId;
    }

    @JsonProperty
    @ThriftField(value=3)
    public int getPipelineId() {
        return this.pipelineId;
    }

    @JsonProperty
    @ThriftField(value=4)
    public int getOperatorId() {
        return this.operatorId;
    }

    @JsonProperty
    @ThriftField(value=5)
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @JsonProperty
    @ThriftField(value=6)
    public String getOperatorType() {
        return this.operatorType;
    }

    @JsonProperty
    @ThriftField(value=7)
    public long getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    @ThriftField(value=8)
    public long getAddInputCalls() {
        return this.addInputCalls;
    }

    @JsonProperty
    @ThriftField(value=9)
    public Duration getAddInputWall() {
        return this.addInputWall;
    }

    @JsonProperty
    @ThriftField(value=10)
    public Duration getAddInputCpu() {
        return this.addInputCpu;
    }

    @JsonProperty
    @ThriftField(value=11)
    public DataSize getAddInputAllocation() {
        return this.addInputAllocation;
    }

    @JsonProperty
    @ThriftField(value=12)
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    @ThriftField(value=13)
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    @ThriftField(value=14)
    public DataSize getInputDataSize() {
        return this.inputDataSize;
    }

    @JsonProperty
    @ThriftField(value=15)
    public long getInputPositions() {
        return this.inputPositions;
    }

    @JsonProperty
    @ThriftField(value=16)
    public double getSumSquaredInputPositions() {
        return this.sumSquaredInputPositions;
    }

    @JsonProperty
    @ThriftField(value=17)
    public long getGetOutputCalls() {
        return this.getOutputCalls;
    }

    @JsonProperty
    @ThriftField(value=18)
    public Duration getGetOutputWall() {
        return this.getOutputWall;
    }

    @JsonProperty
    @ThriftField(value=19)
    public Duration getGetOutputCpu() {
        return this.getOutputCpu;
    }

    @JsonProperty
    @ThriftField(value=20)
    public DataSize getGetOutputAllocation() {
        return this.getOutputAllocation;
    }

    @JsonProperty
    @ThriftField(value=21)
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    @ThriftField(value=22)
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    @ThriftField(value=23)
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    @ThriftField(value=24)
    public Duration getAdditionalCpu() {
        return this.additionalCpu;
    }

    @JsonProperty
    @ThriftField(value=25)
    public Duration getBlockedWall() {
        return this.blockedWall;
    }

    @JsonProperty
    @ThriftField(value=26)
    public long getFinishCalls() {
        return this.finishCalls;
    }

    @JsonProperty
    @ThriftField(value=27)
    public Duration getFinishWall() {
        return this.finishWall;
    }

    @JsonProperty
    @ThriftField(value=28)
    public Duration getFinishCpu() {
        return this.finishCpu;
    }

    @JsonProperty
    @ThriftField(value=29)
    public DataSize getFinishAllocation() {
        return this.finishAllocation;
    }

    @JsonProperty
    @ThriftField(value=30)
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=31)
    public DataSize getRevocableMemoryReservation() {
        return this.revocableMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=32)
    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=33)
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=34)
    public DataSize getPeakSystemMemoryReservation() {
        return this.peakSystemMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=35)
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=36)
    public DataSize getSpilledDataSize() {
        return this.spilledDataSize;
    }

    @Nullable
    @JsonProperty
    @ThriftField(value=37)
    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    @JsonProperty
    @ThriftField(value=38)
    public Optional<BlockedReason> getBlockedReason() {
        return this.blockedReason;
    }

    @Nullable
    @JsonProperty
    public OperatorInfo getInfo() {
        return this.info;
    }

    @ThriftField(value=39)
    public OperatorInfoUnion getInfoUnion() {
        return this.infoUnion;
    }

    public OperatorStats add(OperatorStats operatorStats) {
        return this.add((Iterable<OperatorStats>)ImmutableList.of((Object)operatorStats));
    }

    public OperatorStats add(Iterable<OperatorStats> operators) {
        long totalDrivers = this.totalDrivers;
        long addInputCalls = this.addInputCalls;
        long addInputWall = this.addInputWall.roundTo(TimeUnit.NANOSECONDS);
        long addInputCpu = this.addInputCpu.roundTo(TimeUnit.NANOSECONDS);
        long addInputAllocation = this.addInputAllocation.toBytes();
        long rawInputDataSize = this.rawInputDataSize.toBytes();
        long rawInputPositions = this.rawInputPositions;
        long inputDataSize = this.inputDataSize.toBytes();
        long inputPositions = this.inputPositions;
        double sumSquaredInputPositions = this.sumSquaredInputPositions;
        long getOutputCalls = this.getOutputCalls;
        long getOutputWall = this.getOutputWall.roundTo(TimeUnit.NANOSECONDS);
        long getOutputCpu = this.getOutputCpu.roundTo(TimeUnit.NANOSECONDS);
        long getOutputAllocation = this.getOutputAllocation.toBytes();
        long outputDataSize = this.outputDataSize.toBytes();
        long outputPositions = this.outputPositions;
        long physicalWrittenDataSize = this.physicalWrittenDataSize.toBytes();
        long additionalCpu = this.additionalCpu.roundTo(TimeUnit.NANOSECONDS);
        long blockedWall = this.blockedWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCalls = this.finishCalls;
        long finishWall = this.finishWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCpu = this.finishCpu.roundTo(TimeUnit.NANOSECONDS);
        long finishAllocation = this.finishAllocation.toBytes();
        long memoryReservation = this.userMemoryReservation.toBytes();
        long revocableMemoryReservation = this.revocableMemoryReservation.toBytes();
        long systemMemoryReservation = this.systemMemoryReservation.toBytes();
        long peakUserMemory = this.peakUserMemoryReservation.toBytes();
        long peakSystemMemory = this.peakSystemMemoryReservation.toBytes();
        long peakTotalMemory = this.peakTotalMemoryReservation.toBytes();
        long spilledDataSize = this.spilledDataSize.toBytes();
        Optional<BlockedReason> blockedReason = this.blockedReason;
        RuntimeStats runtimeStats = RuntimeStats.copyOf((RuntimeStats)this.runtimeStats);
        Mergeable<OperatorInfo> base = OperatorStats.getMergeableInfoOrNull(this.info);
        for (OperatorStats operator : operators) {
            Preconditions.checkArgument((operator.getOperatorId() == this.operatorId ? 1 : 0) != 0, (String)"Expected operatorId to be %s but was %s", (int)this.operatorId, (int)operator.getOperatorId());
            totalDrivers += operator.totalDrivers;
            addInputCalls += operator.getAddInputCalls();
            addInputWall += operator.getAddInputWall().roundTo(TimeUnit.NANOSECONDS);
            addInputCpu += operator.getAddInputCpu().roundTo(TimeUnit.NANOSECONDS);
            addInputAllocation += operator.getAddInputAllocation().toBytes();
            rawInputDataSize += operator.getRawInputDataSize().toBytes();
            rawInputPositions += operator.getRawInputPositions();
            inputDataSize += operator.getInputDataSize().toBytes();
            inputPositions += operator.getInputPositions();
            sumSquaredInputPositions += operator.getSumSquaredInputPositions();
            getOutputCalls += operator.getGetOutputCalls();
            getOutputWall += operator.getGetOutputWall().roundTo(TimeUnit.NANOSECONDS);
            getOutputCpu += operator.getGetOutputCpu().roundTo(TimeUnit.NANOSECONDS);
            getOutputAllocation += operator.getGetOutputAllocation().toBytes();
            outputDataSize += operator.getOutputDataSize().toBytes();
            outputPositions += operator.getOutputPositions();
            physicalWrittenDataSize += operator.getPhysicalWrittenDataSize().toBytes();
            finishCalls += operator.getFinishCalls();
            finishWall += operator.getFinishWall().roundTo(TimeUnit.NANOSECONDS);
            finishCpu += operator.getFinishCpu().roundTo(TimeUnit.NANOSECONDS);
            finishAllocation += operator.getFinishAllocation().toBytes();
            additionalCpu += operator.getAdditionalCpu().roundTo(TimeUnit.NANOSECONDS);
            blockedWall += operator.getBlockedWall().roundTo(TimeUnit.NANOSECONDS);
            memoryReservation += operator.getUserMemoryReservation().toBytes();
            revocableMemoryReservation += operator.getRevocableMemoryReservation().toBytes();
            systemMemoryReservation += operator.getSystemMemoryReservation().toBytes();
            peakUserMemory = Math.max(peakUserMemory, operator.getPeakUserMemoryReservation().toBytes());
            peakSystemMemory = Math.max(peakSystemMemory, operator.getPeakSystemMemoryReservation().toBytes());
            peakTotalMemory = Math.max(peakTotalMemory, operator.getPeakTotalMemoryReservation().toBytes());
            spilledDataSize += operator.getSpilledDataSize().toBytes();
            if (operator.getBlockedReason().isPresent()) {
                blockedReason = operator.getBlockedReason();
            }
            OperatorInfo info = operator.getInfo();
            if (base != null && info != null && base.getClass() == info.getClass()) {
                base = OperatorStats.mergeInfo(base, info);
            }
            runtimeStats.mergeWith(operator.getRuntimeStats());
        }
        return new OperatorStats(this.stageId, this.stageExecutionId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, totalDrivers, addInputCalls, Duration.succinctNanos((long)addInputWall), Duration.succinctNanos((long)addInputCpu), DataSize.succinctBytes((long)addInputAllocation), DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)inputDataSize), inputPositions, sumSquaredInputPositions, getOutputCalls, Duration.succinctNanos((long)getOutputWall), Duration.succinctNanos((long)getOutputCpu), DataSize.succinctBytes((long)getOutputAllocation), DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), Duration.succinctNanos((long)additionalCpu), Duration.succinctNanos((long)blockedWall), finishCalls, Duration.succinctNanos((long)finishWall), Duration.succinctNanos((long)finishCpu), DataSize.succinctBytes((long)finishAllocation), DataSize.succinctBytes((long)memoryReservation), DataSize.succinctBytes((long)revocableMemoryReservation), DataSize.succinctBytes((long)systemMemoryReservation), DataSize.succinctBytes((long)peakUserMemory), DataSize.succinctBytes((long)peakSystemMemory), DataSize.succinctBytes((long)peakTotalMemory), DataSize.succinctBytes((long)spilledDataSize), blockedReason, (OperatorInfo)((Object)base), runtimeStats);
    }

    private static Mergeable<OperatorInfo> getMergeableInfoOrNull(OperatorInfo info) {
        Mergeable base = null;
        if (info instanceof Mergeable) {
            base = (Mergeable)((Object)info);
        }
        return base;
    }

    private static <T> Mergeable<T> mergeInfo(Mergeable<T> base, T other) {
        return (Mergeable)base.mergeWith(other);
    }

    public OperatorStats summarize() {
        if (this.info == null || this.info.isFinal()) {
            return this;
        }
        OperatorInfo info = null;
        return new OperatorStats(this.stageId, this.stageExecutionId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, this.totalDrivers, this.addInputCalls, this.addInputWall, this.addInputCpu, this.addInputAllocation, this.rawInputDataSize, this.rawInputPositions, this.inputDataSize, this.inputPositions, this.sumSquaredInputPositions, this.getOutputCalls, this.getOutputWall, this.getOutputCpu, this.getOutputAllocation, this.outputDataSize, this.outputPositions, this.physicalWrittenDataSize, this.additionalCpu, this.blockedWall, this.finishCalls, this.finishWall, this.finishCpu, this.finishAllocation, this.userMemoryReservation, this.revocableMemoryReservation, this.systemMemoryReservation, this.peakUserMemoryReservation, this.peakSystemMemoryReservation, this.peakTotalMemoryReservation, this.spilledDataSize, this.blockedReason, info, this.runtimeStats);
    }
}

