/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import java.lang.reflect.Field;
import java.util.Objects;
import sun.misc.Unsafe;

public class MoreByteArrays {
    private static final Unsafe unsafe;

    public static byte getByte(byte[] bytes, int index) {
        MoreByteArrays.checkValidRange(index, 1, bytes.length);
        return unsafe.getByte(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
    }

    public static int fill(byte[] bytes, int index, int length, byte value) {
        Objects.requireNonNull(bytes, "bytes is null");
        MoreByteArrays.checkValidRange(index, length, bytes.length);
        unsafe.setMemory(bytes, index + Unsafe.ARRAY_BYTE_BASE_OFFSET, length, value);
        return index + length;
    }

    public static int setBytes(byte[] bytes, int index, byte[] values, int offset, int length) {
        Objects.requireNonNull(bytes, "bytes is null");
        Objects.requireNonNull(values, "values is null");
        MoreByteArrays.checkValidRange(index, length, bytes.length);
        MoreByteArrays.checkValidRange(offset, length, values.length);
        unsafe.copyMemory(values, (long)offset + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, length);
        return index + length;
    }

    public static int setInts(byte[] bytes, int index, int[] values, int offset, int length) {
        Objects.requireNonNull(bytes, "bytes is null");
        Objects.requireNonNull(values, "values is null");
        MoreByteArrays.checkValidRange(index, length * Unsafe.ARRAY_INT_INDEX_SCALE, bytes.length);
        MoreByteArrays.checkValidRange(offset, length, values.length);
        for (int i = offset; i < offset + length; ++i) {
            unsafe.putInt(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, values[i]);
            index += Unsafe.ARRAY_INT_INDEX_SCALE;
        }
        return index;
    }

    private static void checkValidRange(int start, int length, int size) {
        if (start < 0 || length < 0 || start + length > size) {
            throw new IndexOutOfBoundsException(String.format("Invalid start %s and length %s with array size %s", start, length, size));
        }
    }

    private MoreByteArrays() {
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe == null) {
                throw new RuntimeException("Unsafe access not available");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

