/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.TransformWork;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class MarkDistinctHash {
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public MarkDistinctHash(Session session, List<Type> types, int[] channels, Optional<Integer> hashChannel, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
        this(session, types, channels, hashChannel, 10000, joinCompiler, updateMemory);
    }

    public MarkDistinctHash(Session session, List<Type> types, int[] channels, Optional<Integer> hashChannel, int expectedDistinctValues, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
        this.groupByHash = GroupByHash.createGroupByHash(types, channels, hashChannel, expectedDistinctValues, SystemSessionProperties.isDictionaryAggregationEnabled(session), joinCompiler, updateMemory);
    }

    public long getEstimatedSize() {
        return this.groupByHash.getEstimatedSize();
    }

    public Work<Block> markDistinctRows(Page page) {
        return new TransformWork<GroupByIdBlock, Block>(this.groupByHash.getGroupIds(page), this::processNextGroupIds);
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    public List<Page> getDistinctPages() {
        return this.groupByHash.getBufferedPages();
    }

    private Block processNextGroupIds(GroupByIdBlock ids) {
        int positions = ids.getPositionCount();
        if (positions > 1) {
            if (this.nextDistinctId == ids.getGroupCount()) {
                return new RunLengthEncodedBlock(BooleanType.createBlockForSingleNonNullValue((boolean)false), positions);
            }
            if (this.nextDistinctId + (long)positions == ids.getGroupCount()) {
                this.nextDistinctId = ids.getGroupCount();
                return new RunLengthEncodedBlock(BooleanType.createBlockForSingleNonNullValue((boolean)true), positions);
            }
        }
        byte[] distinctMask = new byte[positions];
        for (int position = 0; position < distinctMask.length; ++position) {
            if (ids.getGroupId(position) == this.nextDistinctId) {
                distinctMask[position] = 1;
                ++this.nextDistinctId;
                continue;
            }
            distinctMask[position] = 0;
        }
        Preconditions.checkState((this.nextDistinctId == ids.getGroupCount() ? 1 : 0) != 0);
        return BooleanType.wrapByteArrayAsBooleanBlockWithoutNulls((byte[])distinctMask);
    }
}

