/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.BigintGroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.MultiChannelGroupByHash;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Optional;

public interface GroupByHash {
    public static GroupByHash createGroupByHash(Session session, List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, JoinCompiler joinCompiler) {
        return GroupByHash.createGroupByHash(hashTypes, hashChannels, inputHashChannel, expectedSize, SystemSessionProperties.isDictionaryAggregationEnabled(session), joinCompiler, UpdateMemory.NOOP);
    }

    public static GroupByHash createGroupByHash(List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, boolean processDictionary, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
        if (hashTypes.size() == 1 && hashTypes.get(0).equals(BigintType.BIGINT) && hashChannels.length == 1) {
            return new BigintGroupByHash(hashChannels[0], inputHashChannel.isPresent(), expectedSize, updateMemory);
        }
        return new MultiChannelGroupByHash(hashTypes, hashChannels, inputHashChannel, expectedSize, processDictionary, joinCompiler, updateMemory);
    }

    public long getEstimatedSize();

    public long getHashCollisions();

    public double getExpectedHashCollisions();

    public List<Type> getTypes();

    public int getGroupCount();

    public void appendValuesTo(int var1, PageBuilder var2, int var3);

    public Work<?> addPage(Page var1);

    public List<Page> getBufferedPages();

    public Work<GroupByIdBlock> getGroupIds(Page var1);

    public boolean contains(int var1, Page var2, int[] var3);

    public long getRawHash(int var1);

    @VisibleForTesting
    public int getCapacity();
}

