/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.PartialResultQueryManager;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class PartialResultQueryTaskTracker {
    private final PartialResultQueryManager partialResultQueryManager;
    private final double minCompletionRatioThreshold;
    private final double timeMultiplier;
    private final WarningCollector warningCollector;
    private final long startTime;
    private final Map<TaskId, RemoteTask> taskIdMap = new HashMap<TaskId, RemoteTask>();
    private final Set<TaskId> completedTaskIds = Sets.newConcurrentHashSet();
    private final AtomicBoolean addedToQueryManager = new AtomicBoolean();
    private long maxEndTime;
    private boolean taskSchedulingCompleted;

    public PartialResultQueryTaskTracker(PartialResultQueryManager partialResultQueryManager, double minCompletionRatioThreshold, double timeMultiplier, WarningCollector warningCollector) {
        this.partialResultQueryManager = Objects.requireNonNull(partialResultQueryManager, "partialResultQueryManager is null");
        this.minCompletionRatioThreshold = minCompletionRatioThreshold;
        this.timeMultiplier = timeMultiplier;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.startTime = System.nanoTime();
    }

    public double getTaskCompletionRatio() {
        if (this.completedTaskIds.isEmpty() || this.taskIdMap.isEmpty()) {
            return 0.0;
        }
        return (double)this.completedTaskIds.size() / (double)this.taskIdMap.size();
    }

    private void checkAndAddToQueryManager() {
        if (this.taskSchedulingCompleted && this.getTaskCompletionRatio() >= this.minCompletionRatioThreshold && this.addedToQueryManager.compareAndSet(false, true)) {
            long elapsedTime = System.nanoTime() - this.startTime;
            this.maxEndTime = this.startTime + (long)(this.timeMultiplier * (double)elapsedTime);
            this.partialResultQueryManager.addQueryTaskTracker(this);
        }
    }

    public void trackTask(RemoteTask task) {
        this.taskIdMap.put(task.getTaskId(), task);
    }

    public void recordTaskFinish(TaskInfo taskInfo) {
        this.completedTaskIds.add(taskInfo.getTaskId());
        this.checkAndAddToQueryManager();
    }

    public long getMaxEndTime() {
        return this.maxEndTime;
    }

    public void completeTaskScheduling() {
        this.taskSchedulingCompleted = true;
    }

    public void cancelUnfinishedTasks() {
        Sets.SetView pendingTaskIds = Sets.difference(this.taskIdMap.keySet(), this.completedTaskIds);
        double partialResultPercentage = this.getTaskCompletionRatio() * 100.0;
        for (TaskId taskId : pendingTaskIds) {
            RemoteTask pendingTask = this.taskIdMap.get(taskId);
            pendingTask.cancel();
        }
        if (!pendingTaskIds.isEmpty()) {
            String warningMessage = String.format("Partial results are returned. Only %.2f percent of the data is read.", partialResultPercentage);
            this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PARTIAL_RESULT_WARNING, warningMessage));
        }
    }
}

