/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import javax.validation.constraints.Min;

public class NodeResourceStatusConfig {
    private int requiredWorkersActive;
    private int requiredResourceManagersActive = 1;
    private int requiredCoordinatorsActive = 1;

    @Min(value=0L)
    public @Min(value=0L) int getRequiredWorkersActive() {
        return this.requiredWorkersActive;
    }

    @Config(value="cluster.required-workers-active")
    @ConfigDescription(value="Minimum number of active workers that must be available before activating the cluster")
    public NodeResourceStatusConfig setRequiredWorkersActive(int requiredWorkersActive) {
        this.requiredWorkersActive = requiredWorkersActive;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRequiredResourceManagersActive() {
        return this.requiredResourceManagersActive;
    }

    @Config(value="cluster.required-resource-managers-active")
    @ConfigDescription(value="Minimum number of active resource managers that must be available before activating the cluster")
    public NodeResourceStatusConfig setRequiredResourceManagersActive(int requiredResourceManagersActive) {
        this.requiredResourceManagersActive = requiredResourceManagersActive;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRequiredCoordinatorsActive() {
        return this.requiredCoordinatorsActive;
    }

    @Config(value="cluster.required-coordinators-active")
    @ConfigDescription(value="Minimum number of active coordinators that must be available before activating the cluster")
    public NodeResourceStatusConfig setRequiredCoordinatorsActive(int requiredCoordinatorsActive) {
        this.requiredCoordinatorsActive = requiredCoordinatorsActive;
        return this;
    }
}

