/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Throwables;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;

public final class AutoCloseableCloser
implements AutoCloseable {
    private final Deque<AutoCloseable> stack = new ArrayDeque<AutoCloseable>(4);

    private AutoCloseableCloser() {
    }

    public static AutoCloseableCloser create() {
        return new AutoCloseableCloser();
    }

    public <C extends AutoCloseable> C register(C closeable) {
        Objects.requireNonNull(closeable, "closeable is null");
        this.stack.addFirst(closeable);
        return closeable;
    }

    @Override
    public void close() throws Exception {
        Throwable rootCause = null;
        while (!this.stack.isEmpty()) {
            AutoCloseable closeable = this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Throwable t) {
                if (rootCause == null) {
                    rootCause = t;
                    continue;
                }
                if (rootCause == t) continue;
                rootCause.addSuppressed(t);
            }
        }
        if (rootCause != null) {
            Throwables.propagateIfPossible(rootCause, Exception.class);
            throw new AssertionError((Object)rootCause);
        }
    }
}

