/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.Int128ArrayBlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.AbstractType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.TypeSignature;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpAddressType
extends AbstractType
implements FixedWidthType {
    public static final IpAddressType IPADDRESS = new IpAddressType();

    private IpAddressType() {
        super(TypeSignature.parseTypeSignature((String)"ipaddress"), Slice.class);
    }

    public int getFixedSize() {
        return 16;
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isOrderable() {
        return true;
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return leftBlock.getLong(leftPosition, 8) == rightBlock.getLong(rightPosition, 8) && leftBlock.getLong(leftPosition, 0) == rightBlock.getLong(rightPosition, 0);
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int compare = Long.compareUnsigned(Long.reverseBytes(leftBlock.getLong(leftPosition, 0)), Long.reverseBytes(rightBlock.getLong(rightPosition, 0)));
        if (compare != 0) {
            return compare;
        }
        return Long.compareUnsigned(Long.reverseBytes(leftBlock.getLong(leftPosition, 8)), Long.reverseBytes(rightBlock.getLong(rightPosition, 8)));
    }

    public long hash(Block block, int position) {
        return XxHash64.hash((Slice)this.getSlice(block, position));
    }

    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        try {
            return InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(this.getSlice(block, position).getBytes()));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException();
        }
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0));
            blockBuilder.writeLong(block.getLong(position, 8));
            blockBuilder.closeEntry();
        }
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length != 16) {
            throw new IllegalStateException("Expected entry size to be exactly 16 but was " + length);
        }
        blockBuilder.writeLong(value.getLong(offset));
        blockBuilder.writeLong(value.getLong(offset + 8));
        blockBuilder.closeEntry();
    }

    public final Slice getSlice(Block block, int position) {
        return Slices.wrappedLongArray((long[])new long[]{block.getLong(position, 0), block.getLong(position, 8)});
    }
}

