/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tdigest;

import com.facebook.presto.tdigest.Centroid;
import com.facebook.presto.tdigest.TDigestUtils;
import com.google.common.base.Preconditions;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.concurrent.NotThreadSafe;
import org.openjdk.jol.info.ClassLayout;

@NotThreadSafe
public class TDigest {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TDigest.class).instanceSize();
    private static final double MAX_COMPRESSION_FACTOR = 1000.0;
    private static final double sizeFudge = 30.0;
    private static final double EPSILON = 0.001;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double sum;
    private final Random gen = ThreadLocalRandom.current();
    private int mergeCount;
    private final double publicCompression;
    private final double compression;
    private final int maxCentroidCount;
    private final int maxBufferSize;
    private int activeCentroids;
    private double totalWeight;
    private double[] weight;
    private double[] mean;
    private int tempUsed;
    private double unmergedWeight;
    private double[] tempWeight;
    private double[] tempMean;
    private int[] order;

    private TDigest(double compression) {
        Preconditions.checkArgument((!Double.isNaN(compression) ? 1 : 0) != 0);
        Preconditions.checkArgument((compression <= 1000.0 ? 1 : 0) != 0, (String)"Compression factor cannot exceed %s", (Object)1000.0);
        this.publicCompression = Math.max(compression, 10.0);
        this.compression = 2.0 * this.publicCompression;
        this.maxBufferSize = 5 * (int)Math.ceil(this.publicCompression + 30.0);
        this.maxCentroidCount = (int)Math.ceil(this.compression + 30.0);
        this.weight = new double[1];
        this.mean = new double[1];
        this.tempWeight = new double[1];
        this.tempMean = new double[1];
        this.order = new int[1];
        this.activeCentroids = 0;
    }

    public static TDigest createTDigest(double compression) {
        return new TDigest(compression);
    }

    public static TDigest createTDigest(Slice slice) {
        if (slice == null) {
            return null;
        }
        BasicSliceInput sliceInput = new BasicSliceInput(slice);
        try {
            byte format = sliceInput.readByte();
            Preconditions.checkArgument((format == 0 || format == 1 ? 1 : 0) != 0, (Object)"Invalid serialization format for TDigest; expected '0' or '1'");
            byte type = sliceInput.readByte();
            Preconditions.checkArgument((type == 0 ? 1 : 0) != 0, (Object)"Invalid type for TDigest; expected '0' (type double)");
            double min = sliceInput.readDouble();
            double max = sliceInput.readDouble();
            double sum = format == 1 ? sliceInput.readDouble() : 0.0;
            double publicCompression = Math.max(10.0, sliceInput.readDouble());
            TDigest r = new TDigest(publicCompression);
            r.setMinMax(min, max);
            r.setSum(sum);
            r.totalWeight = sliceInput.readDouble();
            r.activeCentroids = sliceInput.readInt();
            r.weight = new double[r.activeCentroids];
            r.mean = new double[r.activeCentroids];
            sliceInput.readBytes(Slices.wrappedDoubleArray((double[])r.weight), r.activeCentroids * 8);
            sliceInput.readBytes(Slices.wrappedDoubleArray((double[])r.mean), r.activeCentroids * 8);
            sliceInput.close();
            return r;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Incorrect slice serialization format");
        }
    }

    public void add(double x) {
        this.add(x, 1.0);
    }

    public void add(double x, double w) {
        Preconditions.checkArgument((!Double.isNaN(x) ? 1 : 0) != 0, (Object)"Cannot add NaN to t-digest");
        Preconditions.checkArgument((w > 0.0 ? 1 : 0) != 0, (Object)"weight must be > 0");
        if (this.tempWeight.length == this.tempUsed) {
            this.tempWeight = Arrays.copyOf(this.tempWeight, Math.min(this.tempWeight.length * 2, this.maxBufferSize));
            this.tempMean = Arrays.copyOf(this.tempMean, Math.min(this.tempMean.length * 2, this.maxBufferSize));
            this.order = Arrays.copyOf(this.order, Math.min(this.order.length * 2, this.maxBufferSize));
        }
        if (this.tempUsed >= this.maxBufferSize - this.activeCentroids - 1) {
            this.mergeNewValues();
        }
        int where = this.tempUsed++;
        this.tempWeight[where] = w;
        this.tempMean[where] = x;
        this.unmergedWeight += w;
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
        this.sum += x * w;
    }

    public void merge(TDigest other) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0, (Object)"Cannot merge with a null t-digest");
        Preconditions.checkArgument((this.publicCompression == other.getCompressionFactor() ? 1 : 0) != 0, (String)"TDigests must have the same compression, found (%s, %s)", (Object)this.publicCompression, (Object)other.getCompressionFactor());
        ArrayList<Centroid> tmp = new ArrayList<Centroid>();
        for (Centroid centroid : other.centroids()) {
            tmp.add(centroid);
        }
        Collections.shuffle(tmp, this.gen);
        for (Centroid centroid : tmp) {
            this.add(centroid.getMean(), centroid.getWeight());
        }
    }

    private void mergeNewValues() {
        this.mergeNewValues(false, this.compression);
    }

    private void mergeNewValues(boolean force, double compression) {
        if (this.unmergedWeight == 0.0) {
            return;
        }
        if (force || this.unmergedWeight > 0.0) {
            if (this.activeCentroids + this.tempUsed >= this.tempWeight.length) {
                this.tempWeight = Arrays.copyOf(this.tempWeight, Math.min(Math.max(this.tempWeight.length * 2, this.activeCentroids + this.tempUsed + 1), this.maxBufferSize));
                this.tempMean = Arrays.copyOf(this.tempMean, Math.min(Math.max(this.tempMean.length * 2, this.activeCentroids + this.tempUsed + 1), this.maxBufferSize));
                this.order = Arrays.copyOf(this.order, Math.min(Math.max(this.order.length * 2, this.activeCentroids + this.tempUsed + 1), this.maxBufferSize));
            }
            this.merge(this.tempMean, this.tempWeight, this.tempUsed, this.order, this.unmergedWeight, this.mergeCount % 2 == 1, compression);
            ++this.mergeCount;
            this.tempUsed = 0;
            this.unmergedWeight = 0.0;
        }
    }

    private void merge(double[] incomingMean, double[] incomingWeight, int incomingCount, int[] incomingOrder, double unmergedWeight, boolean runBackwards, double compression) {
        System.arraycopy(this.mean, 0, incomingMean, incomingCount, this.activeCentroids);
        System.arraycopy(this.weight, 0, incomingWeight, incomingCount, this.activeCentroids);
        Preconditions.checkArgument((incomingOrder != null ? 1 : 0) != 0, (Object)"Incoming order array was null");
        TDigestUtils.sort(incomingOrder, incomingMean, incomingCount += this.activeCentroids);
        if (runBackwards) {
            TDigestUtils.reverse(incomingOrder, 0, incomingCount);
        }
        this.totalWeight += unmergedWeight;
        Preconditions.checkArgument((this.activeCentroids + incomingCount > 0 ? 1 : 0) != 0, (String)"Active centroids plus incoming count must be > 0, was %s", (int)(this.activeCentroids + incomingCount));
        this.activeCentroids = 0;
        this.mean[this.activeCentroids] = incomingMean[incomingOrder[0]];
        this.weight[this.activeCentroids] = incomingWeight[incomingOrder[0]];
        double weightSoFar = 0.0;
        double normalizer = TDigestUtils.normalizer(compression, this.totalWeight);
        for (int i = 1; i < incomingCount; ++i) {
            int ix = incomingOrder[i];
            double proposedWeight = this.weight[this.activeCentroids] + incomingWeight[ix];
            double q0 = weightSoFar / this.totalWeight;
            double q2 = (weightSoFar + proposedWeight) / this.totalWeight;
            if (proposedWeight <= this.totalWeight * Math.min(TDigestUtils.maxSize(q0, normalizer), TDigestUtils.maxSize(q2, normalizer))) {
                int n = this.activeCentroids;
                this.weight[n] = this.weight[n] + incomingWeight[ix];
                this.mean[this.activeCentroids] = this.mean[this.activeCentroids] + (incomingMean[ix] - this.mean[this.activeCentroids]) * incomingWeight[ix] / this.weight[this.activeCentroids];
                incomingWeight[ix] = 0.0;
                continue;
            }
            weightSoFar += this.weight[this.activeCentroids];
            ++this.activeCentroids;
            if (this.mean.length == this.activeCentroids) {
                this.mean = Arrays.copyOf(this.mean, Math.min(this.mean.length * 2, this.maxCentroidCount));
                this.weight = Arrays.copyOf(this.weight, Math.min(this.weight.length * 2, this.maxCentroidCount));
            }
            this.mean[this.activeCentroids] = incomingMean[ix];
            this.weight[this.activeCentroids] = incomingWeight[ix];
            incomingWeight[ix] = 0.0;
        }
        ++this.activeCentroids;
        if (this.mean.length == this.activeCentroids) {
            this.mean = Arrays.copyOf(this.mean, Math.min(this.mean.length * 2, this.maxCentroidCount));
            this.weight = Arrays.copyOf(this.weight, Math.min(this.weight.length * 2, this.maxCentroidCount));
        }
        double sumWeights = 0.0;
        for (int i = 0; i < this.activeCentroids; ++i) {
            sumWeights += this.weight[i];
        }
        Preconditions.checkArgument((Math.abs(sumWeights - this.totalWeight) < 0.001 ? 1 : 0) != 0, (String)"Sum must equal the total weight, but sum:%s != totalWeight:%s", (Object)sumWeights, (Object)this.totalWeight);
        if (runBackwards) {
            TDigestUtils.reverse(this.mean, 0, this.activeCentroids);
            TDigestUtils.reverse(this.weight, 0, this.activeCentroids);
        }
        if (this.totalWeight > 0.0) {
            this.min = Math.min(this.min, this.mean[0]);
            this.max = Math.max(this.max, this.mean[this.activeCentroids - 1]);
        }
    }

    public void compress() {
        this.mergeNewValues(true, this.publicCompression);
    }

    public double getSize() {
        return this.totalWeight + this.unmergedWeight;
    }

    public double getCdf(double x) {
        if (this.unmergedWeight > 0.0) {
            this.compress();
        }
        if (this.activeCentroids == 0) {
            return Double.NaN;
        }
        if (this.activeCentroids == 1) {
            double width = this.max - this.min;
            if (x < this.min) {
                return 0.0;
            }
            if (x > this.max) {
                return 1.0;
            }
            if (x - this.min <= width) {
                return 0.5;
            }
            return (x - this.min) / (this.max - this.min);
        }
        int n = this.activeCentroids;
        if (x < this.min) {
            return 0.0;
        }
        if (x > this.max) {
            return 1.0;
        }
        if (x < this.mean[0]) {
            if (this.mean[0] - this.min > 0.0) {
                if (x == this.min) {
                    return 0.5 / this.totalWeight;
                }
                return (1.0 + (x - this.min) / (this.mean[0] - this.min) * (this.weight[0] / 2.0 - 1.0)) / this.totalWeight;
            }
            return 0.0;
        }
        Preconditions.checkArgument((x >= this.mean[0] ? 1 : 0) != 0, (String)"Value x:%s must be greater than mean of first centroid %s if we got here", (Object)x, (Object)this.mean[0]);
        if (x > this.mean[n - 1]) {
            if (this.max - this.mean[n - 1] > 0.0) {
                if (x == this.max) {
                    return 1.0 - 0.5 / this.totalWeight;
                }
                double dq = (1.0 + (this.max - x) / (this.max - this.mean[n - 1]) * (this.weight[n - 1] / 2.0 - 1.0)) / this.totalWeight;
                return 1.0 - dq;
            }
            return 1.0;
        }
        double weightSoFar = 0.0;
        for (int it = 0; it < n - 1; ++it) {
            if (this.mean[it] == x) {
                double dw = 0.0;
                while (it < n && this.mean[it] == x) {
                    dw += this.weight[it];
                    ++it;
                }
                return (weightSoFar + dw / 2.0) / this.totalWeight;
            }
            if (this.mean[it] <= x && x < this.mean[it + 1]) {
                if (this.mean[it + 1] - this.mean[it] > 0.0) {
                    double leftExcludedW = 0.0;
                    double rightExcludedW = 0.0;
                    if (this.weight[it] == 1.0) {
                        if (this.weight[it + 1] == 1.0) {
                            return (weightSoFar + 1.0) / this.totalWeight;
                        }
                        leftExcludedW = 0.5;
                    } else if (this.weight[it + 1] == 1.0) {
                        rightExcludedW = 0.5;
                    }
                    double dw = (this.weight[it] + this.weight[it + 1]) / 2.0;
                    Preconditions.checkArgument((dw > 1.0 ? 1 : 0) != 0, (String)"dw must be > 1, was %s", (Object)dw);
                    Preconditions.checkArgument((leftExcludedW + rightExcludedW <= 0.5 ? 1 : 0) != 0, (String)"Excluded weight must be <= 0.5, was %s", (Object)(leftExcludedW + rightExcludedW));
                    double left = this.mean[it];
                    double right = this.mean[it + 1];
                    double dwNoSingleton = dw - leftExcludedW - rightExcludedW;
                    Preconditions.checkArgument((right - left > 0.0 ? 1 : 0) != 0, (Object)"Centroids should be in ascending order, but mean of left centroid was greater than right centroid");
                    double base = weightSoFar + this.weight[it] / 2.0 + leftExcludedW;
                    return (base + dwNoSingleton * (x - left) / (right - left)) / this.totalWeight;
                }
                double dw = (this.weight[it] + this.weight[it + 1]) / 2.0;
                return (weightSoFar + dw) / this.totalWeight;
            }
            weightSoFar += this.weight[it];
        }
        Preconditions.checkArgument((x == this.mean[n - 1] ? 1 : 0) != 0, (Object)"At this point, x must equal the mean of the last centroid");
        return 1.0 - 0.5 / this.totalWeight;
    }

    public double getQuantile(double q) {
        Preconditions.checkArgument((q >= 0.0 && q <= 1.0 ? 1 : 0) != 0, (String)"q should be in [0,1], got %s", (Object)q);
        if (this.unmergedWeight > 0.0) {
            this.compress();
        }
        if (this.activeCentroids == 0) {
            return Double.NaN;
        }
        if (this.activeCentroids == 1) {
            return this.mean[0];
        }
        int n = this.activeCentroids;
        double index = q * this.totalWeight;
        if (index < 1.0) {
            return this.min;
        }
        if (this.weight[0] > 1.0 && index < this.weight[0] / 2.0) {
            return this.min + (index - 1.0) / (this.weight[0] / 2.0 - 1.0) * (this.mean[0] - this.min);
        }
        if (index > this.totalWeight - 1.0) {
            return this.max;
        }
        if (this.weight[n - 1] > 1.0 && this.totalWeight - index <= this.weight[n - 1] / 2.0) {
            return this.max - (this.totalWeight - index - 1.0) / (this.weight[n - 1] / 2.0 - 1.0) * (this.max - this.mean[n - 1]);
        }
        double weightSoFar = this.weight[0] / 2.0;
        for (int i = 0; i < n - 1; ++i) {
            double dw = (this.weight[i] + this.weight[i + 1]) / 2.0;
            if (weightSoFar + dw > index) {
                double leftUnit = 0.0;
                if (this.weight[i] == 1.0) {
                    if (index - weightSoFar < 0.5) {
                        return this.mean[i];
                    }
                    leftUnit = 0.5;
                }
                double rightUnit = 0.0;
                if (this.weight[i + 1] == 1.0) {
                    if (weightSoFar + dw - index <= 0.5) {
                        return this.mean[i + 1];
                    }
                    rightUnit = 0.5;
                }
                double z1 = index - weightSoFar - leftUnit;
                double z2 = weightSoFar + dw - index - rightUnit;
                return TDigestUtils.weightedAverage(this.mean[i], z2, this.mean[i + 1], z1);
            }
            weightSoFar += dw;
        }
        Preconditions.checkArgument((this.weight[n - 1] > 1.0 ? 1 : 0) != 0, (String)"Expected weight[n - 1] > 1, but was %s", (Object)this.weight[n - 1]);
        Preconditions.checkArgument((index <= this.totalWeight ? 1 : 0) != 0, (String)"Expected index <= totalWeight, but index:%s > totalWeight:%s", (Object)index, (Object)this.totalWeight);
        Preconditions.checkArgument((index >= this.totalWeight - this.weight[n - 1] / 2.0 ? 1 : 0) != 0, (String)"Expected index >= totalWeight - weight[n - 1] / 2, butindex:%s < %s", (Object)index, (Object)(this.totalWeight - this.weight[n - 1] / 2.0));
        double z1 = index - this.totalWeight - this.weight[n - 1] / 2.0;
        double z2 = this.weight[n - 1] / 2.0 - z1;
        return TDigestUtils.weightedAverage(this.mean[n - 1], z1, this.max, z2);
    }

    public int centroidCount() {
        this.mergeNewValues();
        return this.activeCentroids;
    }

    public Collection<Centroid> centroids() {
        this.compress();
        return new AbstractCollection<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return new Iterator<Centroid>(){
                    int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < TDigest.this.activeCentroids;
                    }

                    @Override
                    public Centroid next() {
                        Centroid rc = new Centroid(TDigest.this.mean[this.i], TDigest.this.weight[this.i]);
                        ++this.i;
                        return rc;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Default operation");
                    }
                };
            }

            @Override
            public int size() {
                return TDigest.this.activeCentroids;
            }
        };
    }

    public double getCompressionFactor() {
        return this.publicCompression;
    }

    public long estimatedSerializedSizeInBytes() {
        this.compress();
        return 46 + 8 * this.activeCentroids + 8 * this.activeCentroids;
    }

    public long estimatedInMemorySizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((double[])this.weight) + SizeOf.sizeOf((double[])this.mean) + SizeOf.sizeOf((double[])this.tempWeight) + SizeOf.sizeOf((double[])this.tempMean) + SizeOf.sizeOf((int[])this.order);
    }

    public Slice serialize() {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(Math.toIntExact(this.estimatedSerializedSizeInBytes()));
        sliceOutput.writeByte(1);
        sliceOutput.writeByte(0);
        sliceOutput.writeDouble(this.min);
        sliceOutput.writeDouble(this.max);
        sliceOutput.writeDouble(this.sum);
        sliceOutput.writeDouble(this.publicCompression);
        sliceOutput.writeDouble(this.totalWeight);
        sliceOutput.writeInt(this.activeCentroids);
        sliceOutput.writeBytes(Slices.wrappedDoubleArray((double[])this.weight), 0, this.activeCentroids * 8);
        sliceOutput.writeBytes(Slices.wrappedDoubleArray((double[])this.mean), 0, this.activeCentroids * 8);
        return sliceOutput.slice();
    }

    private void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    private void setSum(double sum) {
        this.sum = sum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum;
    }

    public void scale(double scaleFactor) {
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"scale factor must be > 0");
        this.compress();
        int i = 0;
        while (i < this.weight.length) {
            int n = i++;
            this.weight[n] = this.weight[n] * scaleFactor;
        }
        this.totalWeight *= scaleFactor;
    }

    public String toString() {
        return String.format("TDigest\nCompression:%s\nCentroid Count:%s\nSize:%s\nMin:%s Median:%s Max:%s", this.publicCompression, this.activeCentroids, this.totalWeight, this.min, this.getQuantile(0.5), this.max);
    }
}

