/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.AbstractJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SemiJoinNode
extends AbstractJoinNode {
    private final PlanNode source;
    private final PlanNode filteringSource;
    private final VariableReferenceExpression sourceJoinVariable;
    private final VariableReferenceExpression filteringSourceJoinVariable;
    private final VariableReferenceExpression semiJoinOutput;
    private final Optional<VariableReferenceExpression> sourceHashVariable;
    private final Optional<VariableReferenceExpression> filteringSourceHashVariable;
    private final Optional<DistributionType> distributionType;
    private final Map<String, VariableReferenceExpression> dynamicFilters;

    @JsonCreator
    public SemiJoinNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="filteringSource") PlanNode filteringSource, @JsonProperty(value="sourceJoinVariable") VariableReferenceExpression sourceJoinVariable, @JsonProperty(value="filteringSourceJoinVariable") VariableReferenceExpression filteringSourceJoinVariable, @JsonProperty(value="semiJoinOutput") VariableReferenceExpression semiJoinOutput, @JsonProperty(value="sourceHashVariable") Optional<VariableReferenceExpression> sourceHashVariable, @JsonProperty(value="filteringSourceHashVariable") Optional<VariableReferenceExpression> filteringSourceHashVariable, @JsonProperty(value="distributionType") Optional<DistributionType> distributionType, @JsonProperty(value="dynamicFilters") Map<String, VariableReferenceExpression> dynamicFilters) {
        super(sourceLocation, id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.filteringSource = Objects.requireNonNull(filteringSource, "filteringSource is null");
        this.sourceJoinVariable = Objects.requireNonNull(sourceJoinVariable, "sourceJoinVariable is null");
        this.filteringSourceJoinVariable = Objects.requireNonNull(filteringSourceJoinVariable, "filteringSourceJoinVariable is null");
        this.semiJoinOutput = Objects.requireNonNull(semiJoinOutput, "semiJoinOutput is null");
        this.sourceHashVariable = Objects.requireNonNull(sourceHashVariable, "sourceHashVariable is null");
        this.filteringSourceHashVariable = Objects.requireNonNull(filteringSourceHashVariable, "filteringSourceHashVariable is null");
        this.distributionType = Objects.requireNonNull(distributionType, "distributionType is null");
        this.dynamicFilters = Objects.requireNonNull(dynamicFilters, "dynamicFilters is null");
        Preconditions.checkArgument((boolean)source.getOutputVariables().contains(sourceJoinVariable), (Object)"Source does not contain join symbol");
        Preconditions.checkArgument((boolean)filteringSource.getOutputVariables().contains(filteringSourceJoinVariable), (Object)"Filtering source does not contain filtering join symbol");
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public PlanNode getProbe() {
        return this.source;
    }

    @JsonProperty
    public PlanNode getFilteringSource() {
        return this.filteringSource;
    }

    @Override
    public PlanNode getBuild() {
        return this.filteringSource;
    }

    @JsonProperty
    public VariableReferenceExpression getSourceJoinVariable() {
        return this.sourceJoinVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getFilteringSourceJoinVariable() {
        return this.filteringSourceJoinVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getSemiJoinOutput() {
        return this.semiJoinOutput;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getSourceHashVariable() {
        return this.sourceHashVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getFilteringSourceHashVariable() {
        return this.filteringSourceHashVariable;
    }

    @JsonProperty
    public Optional<DistributionType> getDistributionType() {
        return this.distributionType;
    }

    @Override
    @JsonProperty
    public Map<String, VariableReferenceExpression> getDynamicFilters() {
        return this.dynamicFilters;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source, (Object)this.filteringSource);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.source.getOutputVariables()).add((Object)this.semiJoinOutput).build();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitSemiJoin(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new SemiJoinNode(this.getSourceLocation(), this.getId(), newChildren.get(0), newChildren.get(1), this.sourceJoinVariable, this.filteringSourceJoinVariable, this.semiJoinOutput, this.sourceHashVariable, this.filteringSourceHashVariable, this.distributionType, this.dynamicFilters);
    }

    public SemiJoinNode withDistributionType(DistributionType distributionType) {
        return new SemiJoinNode(this.getSourceLocation(), this.getId(), this.source, this.filteringSource, this.sourceJoinVariable, this.filteringSourceJoinVariable, this.semiJoinOutput, this.sourceHashVariable, this.filteringSourceHashVariable, Optional.of(distributionType), this.dynamicFilters);
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }
}

