/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MetadataQueryOptimizer
implements PlanOptimizer {
    private static final Set<QualifiedObjectName> ALLOWED_FUNCTIONS = ImmutableSet.of((Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"max"), (Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"min"), (Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"approx_distinct"));
    private static final Map<QualifiedObjectName, QualifiedObjectName> AGGREGATION_SCALAR_MAPPING = ImmutableMap.of((Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"max"), (Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"greatest"), (Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"min"), (Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"least"));
    private final Metadata metadata;

    public MetadataQueryOptimizer(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (!SystemSessionProperties.isOptimizeMetadataQueries(session) && !SystemSessionProperties.isOptimizeMetadataQueriesIgnoreStats(session)) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Optimizer(session, this.metadata, idAllocator), plan, null);
    }

    private static class Replacer
    extends SimplePlanRewriter<Void> {
        private final ValuesNode replacement;

        private Replacer(ValuesNode replacement) {
            this.replacement = replacement;
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.replacement;
        }
    }

    private static class Optimizer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final Metadata metadata;
        private final RowExpressionDeterminismEvaluator determinismEvaluator;
        private final boolean ignoreMetadataStats;

        private Optimizer(Session session, Metadata metadata, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.metadata = metadata;
            this.idAllocator = idAllocator;
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(metadata);
            this.ignoreMetadataStats = SystemSessionProperties.isOptimizeMetadataQueriesIgnoreStats(session);
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Optional<RowExpression> remainingPredicate;
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                QualifiedObjectName functionName = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(aggregation.getFunctionHandle()).getName();
                if (ALLOWED_FUNCTIONS.contains(functionName) || aggregation.isDistinct()) continue;
                return context.defaultRewrite((PlanNode)node);
            }
            Optional<TableScanNode> result = Optimizer.findTableScan(node.getSource(), this.determinismEvaluator);
            if (!result.isPresent()) {
                return context.defaultRewrite((PlanNode)node);
            }
            TableScanNode tableScan = result.get();
            ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
            List inputs = tableScan.getOutputVariables();
            for (VariableReferenceExpression variable : inputs) {
                ColumnHandle column = (ColumnHandle)tableScan.getAssignments().get(variable);
                columnBuilder.put((Object)variable, (Object)column);
            }
            ImmutableMap columns = columnBuilder.build();
            TableLayout layout = !tableScan.getTable().getLayout().isPresent() ? this.metadata.getLayout(this.session, tableScan.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty()).getLayout() : this.metadata.getLayout(this.session, tableScan.getTable());
            if (!layout.getDiscretePredicates().isPresent()) {
                return context.defaultRewrite((PlanNode)node);
            }
            DiscretePredicates discretePredicates = layout.getDiscretePredicates().get();
            if (layout.getPredicate().getColumnDomains().isPresent()) {
                List predicateColumns = (List)((List)layout.getPredicate().getColumnDomains().get()).stream().map(TupleDomain.ColumnDomain::getColumn).collect(ImmutableList.toImmutableList());
                if (!discretePredicates.getColumns().containsAll(predicateColumns)) {
                    return context.defaultRewrite((PlanNode)node);
                }
            }
            if ((remainingPredicate = layout.getRemainingPredicate()).isPresent() && !VariablesExtractor.extractAll(remainingPredicate.get()).isEmpty()) {
                return context.defaultRewrite((PlanNode)node);
            }
            if (!discretePredicates.getColumns().containsAll(columns.values())) {
                return context.defaultRewrite((PlanNode)node);
            }
            if (this.isReducible(node, inputs)) {
                return this.reduce(node, inputs, (Map<VariableReferenceExpression, ColumnHandle>)columns, context, discretePredicates, tableScan.getTable());
            }
            for (TupleDomain tupleDomain : discretePredicates.getPredicates()) {
                if (this.hasPositiveRowCount(tableScan.getTable(), (TupleDomain<ColumnHandle>)tupleDomain)) continue;
                return context.defaultRewrite((PlanNode)node);
            }
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (TupleDomain domain : discretePredicates.getPredicates()) {
                if (domain.isNone()) continue;
                Map entries = (Map)TupleDomain.extractFixedValues((TupleDomain)domain).get();
                ImmutableList.Builder rowBuilder = ImmutableList.builder();
                for (VariableReferenceExpression input : inputs) {
                    ColumnHandle column = (ColumnHandle)columns.get(input);
                    NullableValue value = (NullableValue)entries.get(column);
                    if (value == null) {
                        return context.defaultRewrite((PlanNode)node);
                    }
                    rowBuilder.add((Object)Expressions.constant(value.getValue(), input.getType()));
                }
                rowsBuilder.add((Object)rowBuilder.build());
            }
            return SimplePlanRewriter.rewriteWith(new Replacer(new ValuesNode(node.getSourceLocation(), this.idAllocator.getNextId(), inputs, (List)rowsBuilder.build())), (PlanNode)node);
        }

        private boolean isReducible(AggregationNode node, List<VariableReferenceExpression> inputs) {
            if (node.getAggregations().isEmpty() || !node.getGroupingKeys().isEmpty() || !(node.getSource() instanceof TableScanNode)) {
                return false;
            }
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                FunctionMetadata functionMetadata = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(aggregation.getFunctionHandle());
                if (AGGREGATION_SCALAR_MAPPING.containsKey(functionMetadata.getName()) && functionMetadata.getArgumentTypes().size() <= 1 && inputs.containsAll(aggregation.getCall().getArguments())) continue;
                return false;
            }
            return true;
        }

        private PlanNode reduce(AggregationNode node, List<VariableReferenceExpression> inputs, Map<VariableReferenceExpression, ColumnHandle> columns, SimplePlanRewriter.RewriteContext<Void> context, DiscretePredicates predicates, TableHandle table) {
            ImmutableMap.Builder inputColumnValuesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder inputValueToDomainBuilder = ImmutableMap.builder();
            for (VariableReferenceExpression input : inputs) {
                ImmutableList.Builder arguments = ImmutableList.builder();
                HashMap valueToDomain = new HashMap();
                ColumnHandle column = columns.get(input);
                for (TupleDomain domain : predicates.getPredicates()) {
                    if (domain.isNone()) continue;
                    Map entries = (Map)TupleDomain.extractFixedValues((TupleDomain)domain).get();
                    NullableValue value = (NullableValue)entries.get(column);
                    if (value == null) {
                        return context.defaultRewrite((PlanNode)node);
                    }
                    if (value.getValue() == null) continue;
                    Type type = input.getType();
                    ConstantExpression constantExpression = Expressions.constant(value.getValue(), type);
                    arguments.add((Object)constantExpression);
                    valueToDomain.putIfAbsent(constantExpression, domain);
                }
                inputColumnValuesBuilder.put((Object)input, (Object)arguments.build());
                inputValueToDomainBuilder.put((Object)input, (Object)valueToDomain);
            }
            ImmutableMap inputColumnValues = inputColumnValuesBuilder.build();
            ImmutableMap inputValueToDomain = inputValueToDomainBuilder.build();
            Assignments.Builder assignmentsBuilder = Assignments.builder();
            for (VariableReferenceExpression outputVariable : node.getOutputVariables()) {
                AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)node.getAggregations().get(outputVariable);
                RowExpression inputVariable = (RowExpression)Iterables.getOnlyElement((Iterable)aggregation.getArguments());
                RowExpression result = this.evaluateMinMax(this.metadata.getFunctionAndTypeManager().getFunctionMetadata(((AggregationNode.Aggregation)node.getAggregations().get(outputVariable)).getFunctionHandle()), (List)inputColumnValues.get(inputVariable));
                assignmentsBuilder.put(outputVariable, result);
                TupleDomain tupleDomain = (TupleDomain)((Map)inputValueToDomain.get(inputVariable)).get(result);
                if (this.hasPositiveRowCount(table, (TupleDomain<ColumnHandle>)tupleDomain)) continue;
                return context.defaultRewrite((PlanNode)node);
            }
            Assignments assignments = assignmentsBuilder.build();
            ValuesNode valuesNode = new ValuesNode(node.getSourceLocation(), this.idAllocator.getNextId(), node.getOutputVariables(), (List)ImmutableList.of(new ArrayList(assignments.getExpressions())));
            return new ProjectNode(node.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)valuesNode, assignments, ProjectNode.Locality.LOCAL);
        }

        private boolean hasPositiveRowCount(TableHandle table, TupleDomain<ColumnHandle> tupleDomain) {
            if (this.ignoreMetadataStats) {
                return true;
            }
            TableStatistics tableStatistics = this.metadata.getTableStatistics(this.session, table, (List<ColumnHandle>)ImmutableList.of(), (Constraint<ColumnHandle>)new Constraint(tupleDomain));
            return !tableStatistics.getRowCount().isUnknown() && tableStatistics.getRowCount().getValue() > 0.0;
        }

        private RowExpression evaluateMinMax(FunctionMetadata aggregationFunctionMetadata, List<RowExpression> arguments) {
            Type returnType = this.metadata.getFunctionAndTypeManager().getType(aggregationFunctionMetadata.getReturnType());
            if (arguments.isEmpty()) {
                return Expressions.constant(null, returnType);
            }
            String scalarFunctionName = ((QualifiedObjectName)AGGREGATION_SCALAR_MAPPING.get(aggregationFunctionMetadata.getName())).getObjectName();
            ConnectorSession connectorSession = this.session.toConnectorSession();
            while (arguments.size() > 1) {
                ArrayList<RowExpression> reducedArguments = new ArrayList<RowExpression>();
                for (List partitionedArguments : Lists.partition(arguments, (int)100)) {
                    Object reducedValue = RowExpressionInterpreter.evaluateConstantRowExpression((RowExpression)Expressions.call(this.metadata.getFunctionAndTypeManager(), scalarFunctionName, returnType, (List<RowExpression>)partitionedArguments), this.metadata, connectorSession);
                    reducedArguments.add((RowExpression)Expressions.constant(reducedValue, returnType));
                }
                arguments = reducedArguments;
            }
            return (RowExpression)Iterables.getOnlyElement(arguments);
        }

        private static Optional<TableScanNode> findTableScan(PlanNode source, RowExpressionDeterminismEvaluator determinismEvaluator) {
            while (true) {
                if (source instanceof MarkDistinctNode || source instanceof FilterNode || source instanceof LimitNode || source instanceof TopNNode || source instanceof SortNode) {
                    source = (PlanNode)source.getSources().get(0);
                    continue;
                }
                if (!(source instanceof ProjectNode)) break;
                ProjectNode project = (ProjectNode)source;
                if (!Iterables.all((Iterable)project.getAssignments().getExpressions(), determinismEvaluator::isDeterministic)) {
                    return Optional.empty();
                }
                source = project.getSource();
            }
            if (source instanceof TableScanNode) {
                return Optional.of((TableScanNode)source);
            }
            return Optional.empty();
        }
    }
}

