/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.SetOperationNodeUtils;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class HashGenerationOptimizer
implements PlanOptimizer {
    public static final long INITIAL_HASH_VALUE = 0L;
    private static final String HASH_CODE = OperatorType.HASH_CODE.getFunctionName().getObjectName();
    private final FunctionAndTypeManager functionAndTypeManager;

    public HashGenerationOptimizer(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (SystemSessionProperties.isOptimizeHashGenerationEnabled(session)) {
            PlanWithProperties result = (PlanWithProperties)plan.accept((PlanVisitor)new Rewriter(idAllocator, variableAllocator, this.functionAndTypeManager), (Object)new HashComputationSet());
            return result.getNode();
        }
        return plan;
    }

    private static Optional<HashComputation> computeHash(Iterable<VariableReferenceExpression> fields, FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(fields, "fields is null");
        ImmutableList variables = ImmutableList.copyOf(fields);
        if (variables.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new HashComputation(fields, functionAndTypeManager));
    }

    public static Optional<RowExpression> getHashExpression(FunctionAndTypeManager functionAndTypeManager, List<VariableReferenceExpression> variables) {
        if (variables.isEmpty()) {
            return Optional.empty();
        }
        ConstantExpression result = Expressions.constant(0L, (Type)BigintType.BIGINT);
        for (VariableReferenceExpression variable : variables) {
            CallExpression hashField = Expressions.call(functionAndTypeManager, HASH_CODE, (Type)BigintType.BIGINT, new RowExpression[]{variable});
            hashField = HashGenerationOptimizer.orNullHashCode((RowExpression)hashField);
            result = Expressions.call(functionAndTypeManager, "combine_hash", (Type)BigintType.BIGINT, new RowExpression[]{result, hashField});
        }
        return Optional.of(result);
    }

    private static RowExpression orNullHashCode(RowExpression expression) {
        Preconditions.checkArgument((boolean)BigintType.BIGINT.equals((Object)expression.getType()), (Object)"expression should be BIGINT type");
        return new SpecialFormExpression(expression.getSourceLocation(), SpecialFormExpression.Form.COALESCE, (Type)BigintType.BIGINT, new RowExpression[]{expression, Expressions.constant(0L, (Type)BigintType.BIGINT)});
    }

    private static Map<VariableReferenceExpression, VariableReferenceExpression> computeIdentityTranslations(Map<VariableReferenceExpression, RowExpression> assignments) {
        HashMap<VariableReferenceExpression, VariableReferenceExpression> outputToInput = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (Map.Entry<VariableReferenceExpression, RowExpression> assignment : assignments.entrySet()) {
            Preconditions.checkArgument((!OriginalExpressionUtils.isExpression(assignment.getValue()) ? 1 : 0) != 0, (Object)"Cannot have OriginalExpression in assignments");
            if (!(assignment.getValue() instanceof VariableReferenceExpression)) continue;
            outputToInput.put(assignment.getKey(), (VariableReferenceExpression)assignment.getValue());
        }
        return outputToInput;
    }

    private static class PlanWithProperties {
        private final PlanNode node;
        private final BiMap<HashComputation, VariableReferenceExpression> hashVariables;

        public PlanWithProperties(PlanNode node, Map<HashComputation, VariableReferenceExpression> hashVariables) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.hashVariables = ImmutableBiMap.copyOf(Objects.requireNonNull(hashVariables, "hashVariables is null"));
        }

        public PlanNode getNode() {
            return this.node;
        }

        public BiMap<HashComputation, VariableReferenceExpression> getHashVariables() {
            return this.hashVariables;
        }

        public VariableReferenceExpression getRequiredHashVariable(HashComputation hash) {
            VariableReferenceExpression hashVariable = (VariableReferenceExpression)this.hashVariables.get((Object)hash);
            Objects.requireNonNull(hashVariable, () -> "No hash variable generated for " + hash);
            return hashVariable;
        }
    }

    private static class HashComputation {
        private final List<VariableReferenceExpression> fields;
        private final FunctionAndTypeManager functionAndTypeManager;

        private HashComputation(Iterable<VariableReferenceExpression> fields, FunctionAndTypeManager functionAndTypeManager) {
            Objects.requireNonNull(fields, "fields is null");
            this.fields = ImmutableList.copyOf(fields);
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
            Preconditions.checkArgument((!this.fields.isEmpty() ? 1 : 0) != 0, (Object)"fields can not be empty");
        }

        public Optional<HashComputation> translate(Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> translator) {
            ImmutableList.Builder newVariables = ImmutableList.builder();
            for (VariableReferenceExpression field : this.fields) {
                Optional<VariableReferenceExpression> newVariable = translator.apply(field);
                if (!newVariable.isPresent()) {
                    return Optional.empty();
                }
                newVariables.add((Object)newVariable.get());
            }
            return HashGenerationOptimizer.computeHash((Iterable)newVariables.build(), this.functionAndTypeManager);
        }

        public boolean canComputeWith(Set<VariableReferenceExpression> availableFields) {
            return availableFields.containsAll(this.fields);
        }

        private RowExpression getHashExpression() {
            ConstantExpression hashExpression = Expressions.constant(0L, (Type)BigintType.BIGINT);
            for (VariableReferenceExpression field : this.fields) {
                hashExpression = this.getHashFunctionCall((RowExpression)hashExpression, field);
            }
            return hashExpression;
        }

        private RowExpression getHashFunctionCall(RowExpression previousHashValue, VariableReferenceExpression variable) {
            CallExpression functionCall = Expressions.call(this.functionAndTypeManager, HASH_CODE, (Type)BigintType.BIGINT, new RowExpression[]{variable});
            return Expressions.call(this.functionAndTypeManager, "combine_hash", (Type)BigintType.BIGINT, previousHashValue, HashGenerationOptimizer.orNullHashCode((RowExpression)functionCall));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashComputation that = (HashComputation)o;
            return Objects.equals(this.fields, that.fields);
        }

        public int hashCode() {
            return Objects.hash(this.fields);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fields", this.fields).toString();
        }
    }

    private static class HashComputationSet {
        private final Set<HashComputation> hashes;

        public HashComputationSet() {
            this.hashes = ImmutableSet.of();
        }

        public HashComputationSet(Optional<HashComputation> hash) {
            Objects.requireNonNull(hash, "hash is null");
            this.hashes = hash.isPresent() ? ImmutableSet.of((Object)hash.get()) : ImmutableSet.of();
        }

        private HashComputationSet(Iterable<HashComputation> hashes) {
            Objects.requireNonNull(hashes, "hashes is null");
            this.hashes = ImmutableSet.copyOf(hashes);
        }

        public Set<HashComputation> getHashes() {
            return this.hashes;
        }

        public HashComputationSet pruneVariables(List<VariableReferenceExpression> variables) {
            ImmutableSet uniqueVariables = ImmutableSet.copyOf(variables);
            return new HashComputationSet((Iterable)this.hashes.stream().filter(arg_0 -> HashComputationSet.lambda$pruneVariables$0((Set)uniqueVariables, arg_0)).collect(ImmutableSet.toImmutableSet()));
        }

        public HashComputationSet translate(Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> translator) {
            Set newHashes = (Set)this.hashes.stream().map(hash -> hash.translate(translator)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet());
            return new HashComputationSet(newHashes);
        }

        public HashComputationSet withHashComputation(PlanNode node, Optional<HashComputation> hashComputation) {
            return this.pruneVariables(node.getOutputVariables()).withHashComputation(hashComputation);
        }

        public HashComputationSet withHashComputation(Optional<HashComputation> hashComputation) {
            if (!hashComputation.isPresent()) {
                return this;
            }
            return new HashComputationSet((Iterable<HashComputation>)ImmutableSet.builder().addAll(this.hashes).add((Object)hashComputation.get()).build());
        }

        private static /* synthetic */ boolean lambda$pruneVariables$0(Set uniqueVariables, HashComputation hash) {
            return hash.canComputeWith(uniqueVariables);
        }
    }

    private static class Rewriter
    extends InternalPlanVisitor<PlanWithProperties, HashComputationSet> {
        private final PlanNodeIdAllocator idAllocator;
        private final PlanVariableAllocator variableAllocator;
        private final FunctionAndTypeManager functionAndTypeManager;

        private Rewriter(PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, FunctionAndTypeManager functionAndTypeManager) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        }

        public PlanWithProperties visitPlan(PlanNode node, HashComputationSet parentPreference) {
            return this.planSimpleNodeWithProperties(node, parentPreference);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, HashComputationSet parentPreference) {
            return this.planSimpleNodeWithProperties(node, new HashComputationSet(), true);
        }

        @Override
        public PlanWithProperties visitApply(ApplyNode node, HashComputationSet context) {
            return new PlanWithProperties(node, (Map<HashComputation, VariableReferenceExpression>)ImmutableMap.of());
        }

        @Override
        public PlanWithProperties visitLateralJoin(LateralJoinNode node, HashComputationSet context) {
            return new PlanWithProperties(node, (Map<HashComputation, VariableReferenceExpression>)ImmutableMap.of());
        }

        public PlanWithProperties visitAggregation(AggregationNode node, HashComputationSet parentPreference) {
            Optional groupByHash = Optional.empty();
            List groupingKeys = node.getGroupingKeys();
            if (!node.isStreamable() && !this.canSkipHashGeneration(node.getGroupingKeys())) {
                groupByHash = HashGenerationOptimizer.computeHash(groupingKeys, this.functionAndTypeManager);
            }
            HashComputationSet requiredHashes = new HashComputationSet(groupByHash);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), requiredHashes, false, requiredHashes);
            Optional<VariableReferenceExpression> hashVariable = groupByHash.map(child::getRequiredHashVariable);
            return new PlanWithProperties((PlanNode)new AggregationNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getAggregations(), node.getGroupingSets(), node.getPreGroupedVariables(), node.getStep(), hashVariable, node.getGroupIdVariable()), (Map<HashComputation, VariableReferenceExpression>)(hashVariable.isPresent() ? ImmutableMap.of(groupByHash.get(), (Object)hashVariable.get()) : ImmutableMap.of()));
        }

        private boolean canSkipHashGeneration(List<VariableReferenceExpression> partitionVariables) {
            return partitionVariables.isEmpty() || partitionVariables.size() == 1 && ((VariableReferenceExpression)Iterables.getOnlyElement(partitionVariables)).getType().equals(BigintType.BIGINT);
        }

        @Override
        public PlanWithProperties visitGroupId(GroupIdNode node, HashComputationSet parentPreference) {
            return this.planSimpleNodeWithProperties(node, parentPreference.pruneVariables(node.getSource().getOutputVariables()));
        }

        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, HashComputationSet parentPreference) {
            if (this.canSkipHashGeneration(node.getDistinctVariables())) {
                return this.planSimpleNodeWithProperties((PlanNode)node, parentPreference);
            }
            Optional hashComputation = HashGenerationOptimizer.computeHash(node.getDistinctVariables(), this.functionAndTypeManager);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), false, parentPreference.withHashComputation((PlanNode)node, hashComputation));
            VariableReferenceExpression hashVariable = child.getRequiredHashVariable((HashComputation)hashComputation.get());
            return new PlanWithProperties((PlanNode)new DistinctLimitNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getLimit(), node.isPartial(), node.getDistinctVariables(), Optional.of(hashVariable)), (Map<HashComputation, VariableReferenceExpression>)ImmutableMap.of(hashComputation.get(), (Object)hashVariable));
        }

        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, HashComputationSet parentPreference) {
            if (this.canSkipHashGeneration(node.getDistinctVariables())) {
                return this.planSimpleNodeWithProperties((PlanNode)node, parentPreference);
            }
            Optional hashComputation = HashGenerationOptimizer.computeHash(node.getDistinctVariables(), this.functionAndTypeManager);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), false, parentPreference.withHashComputation((PlanNode)node, hashComputation));
            VariableReferenceExpression hashVariable = child.getRequiredHashVariable((HashComputation)hashComputation.get());
            return new PlanWithProperties((PlanNode)new MarkDistinctNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getMarkerVariable(), node.getDistinctVariables(), Optional.of(hashVariable)), (Map<HashComputation, VariableReferenceExpression>)child.getHashVariables());
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, HashComputationSet parentPreference) {
            if (node.getPartitionBy().isEmpty()) {
                return this.planSimpleNodeWithProperties(node, parentPreference);
            }
            Optional hashComputation = HashGenerationOptimizer.computeHash(node.getPartitionBy(), this.functionAndTypeManager);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), false, parentPreference.withHashComputation(node, hashComputation));
            VariableReferenceExpression hashVariable = child.getRequiredHashVariable((HashComputation)hashComputation.get());
            return new PlanWithProperties(new RowNumberNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getPartitionBy(), node.getRowNumberVariable(), node.getMaxRowCountPerPartition(), Optional.of(hashVariable)), (Map<HashComputation, VariableReferenceExpression>)child.getHashVariables());
        }

        @Override
        public PlanWithProperties visitTopNRowNumber(TopNRowNumberNode node, HashComputationSet parentPreference) {
            if (node.getPartitionBy().isEmpty()) {
                return this.planSimpleNodeWithProperties(node, parentPreference);
            }
            Optional hashComputation = HashGenerationOptimizer.computeHash(node.getPartitionBy(), this.functionAndTypeManager);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), false, parentPreference.withHashComputation(node, hashComputation));
            VariableReferenceExpression hashVariable = child.getRequiredHashVariable((HashComputation)hashComputation.get());
            return new PlanWithProperties(new TopNRowNumberNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getSpecification(), node.getRowNumberVariable(), node.getMaxRowCountPerPartition(), node.isPartial(), Optional.of(hashVariable)), (Map<HashComputation, VariableReferenceExpression>)child.getHashVariables());
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, HashComputationSet parentPreference) {
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            if (clauses.isEmpty()) {
                PlanWithProperties left = this.planAndEnforce(node.getLeft(), new HashComputationSet(), true, new HashComputationSet());
                PlanWithProperties right = this.planAndEnforce(node.getRight(), new HashComputationSet(), true, new HashComputationSet());
                Preconditions.checkState((left.getHashVariables().isEmpty() && right.getHashVariables().isEmpty() ? 1 : 0) != 0);
                return new PlanWithProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)left.getNode(), (Object)right.getNode())), (Map<HashComputation, VariableReferenceExpression>)ImmutableMap.of());
            }
            Optional leftHashComputation = HashGenerationOptimizer.computeHash(Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft), this.functionAndTypeManager);
            PlanWithProperties left = this.planAndEnforce(node.getLeft(), new HashComputationSet(leftHashComputation), true, new HashComputationSet(leftHashComputation));
            VariableReferenceExpression leftHashVariable = left.getRequiredHashVariable((HashComputation)leftHashComputation.get());
            Optional rightHashComputation = HashGenerationOptimizer.computeHash(Lists.transform(clauses, JoinNode.EquiJoinClause::getRight), this.functionAndTypeManager);
            PlanWithProperties right = this.planAndEnforce(node.getRight(), new HashComputationSet(rightHashComputation), true, new HashComputationSet(rightHashComputation));
            VariableReferenceExpression rightHashVariable = right.getRequiredHashVariable((HashComputation)rightHashComputation.get());
            HashMap<HashComputation, VariableReferenceExpression> allHashVariables = new HashMap<HashComputation, VariableReferenceExpression>();
            if (node.getType() == JoinNode.Type.INNER || node.getType() == JoinNode.Type.LEFT) {
                allHashVariables.putAll((Map<HashComputation, VariableReferenceExpression>)left.getHashVariables());
            }
            if (node.getType() == JoinNode.Type.INNER || node.getType() == JoinNode.Type.RIGHT) {
                allHashVariables.putAll((Map<HashComputation, VariableReferenceExpression>)right.getHashVariables());
            }
            return this.buildJoinNodeWithPreferredHashes(node, left, right, allHashVariables, parentPreference, Optional.of(leftHashVariable), Optional.of(rightHashVariable));
        }

        private PlanWithProperties buildJoinNodeWithPreferredHashes(JoinNode node, PlanWithProperties left, PlanWithProperties right, Map<HashComputation, VariableReferenceExpression> allHashVariables, HashComputationSet parentPreference, Optional<VariableReferenceExpression> leftHashVariable, Optional<VariableReferenceExpression> rightHashVariable) {
            Map hashVariablesWithParentPreferences = (Map)allHashVariables.entrySet().stream().filter(entry -> parentPreference.getHashes().contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            List outputVariables = (List)Stream.concat(left.getNode().getOutputVariables().stream(), right.getNode().getOutputVariables().stream()).filter(variable -> node.getOutputVariables().contains(variable) || hashVariablesWithParentPreferences.values().contains(variable)).collect(ImmutableList.toImmutableList());
            return new PlanWithProperties(new JoinNode(node.getSourceLocation(), node.getId(), node.getType(), left.getNode(), right.getNode(), node.getCriteria(), outputVariables, node.getFilter(), leftHashVariable, rightHashVariable, node.getDistributionType(), node.getDynamicFilters()), hashVariablesWithParentPreferences);
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, HashComputationSet parentPreference) {
            Optional sourceHashComputation = HashGenerationOptimizer.computeHash((Iterable)ImmutableList.of((Object)node.getSourceJoinVariable()), this.functionAndTypeManager);
            PlanWithProperties source = this.planAndEnforce(node.getSource(), new HashComputationSet(sourceHashComputation), true, new HashComputationSet(sourceHashComputation));
            VariableReferenceExpression sourceHashVariable = source.getRequiredHashVariable((HashComputation)sourceHashComputation.get());
            Optional filterHashComputation = HashGenerationOptimizer.computeHash((Iterable)ImmutableList.of((Object)node.getFilteringSourceJoinVariable()), this.functionAndTypeManager);
            HashComputationSet requiredHashes = new HashComputationSet(filterHashComputation);
            PlanWithProperties filteringSource = this.planAndEnforce(node.getFilteringSource(), requiredHashes, true, requiredHashes);
            VariableReferenceExpression filteringSourceHashVariable = filteringSource.getRequiredHashVariable((HashComputation)filterHashComputation.get());
            return new PlanWithProperties(new SemiJoinNode(node.getSourceLocation(), node.getId(), source.getNode(), filteringSource.getNode(), node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), Optional.of(sourceHashVariable), Optional.of(filteringSourceHashVariable), node.getDistributionType(), node.getDynamicFilters()), (Map<HashComputation, VariableReferenceExpression>)source.getHashVariables());
        }

        @Override
        public PlanWithProperties visitSpatialJoin(SpatialJoinNode node, HashComputationSet parentPreference) {
            PlanWithProperties left = this.planAndEnforce(node.getLeft(), new HashComputationSet(), true, new HashComputationSet());
            PlanWithProperties right = this.planAndEnforce(node.getRight(), new HashComputationSet(), true, new HashComputationSet());
            Verify.verify((boolean)left.getHashVariables().isEmpty(), (String)"probe side of the spatial join should not include hash variables", (Object[])new Object[0]);
            Verify.verify((boolean)right.getHashVariables().isEmpty(), (String)"build side of the spatial join should not include hash variables", (Object[])new Object[0]);
            return new PlanWithProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)left.getNode(), (Object)right.getNode())), (Map<HashComputation, VariableReferenceExpression>)ImmutableMap.of());
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, HashComputationSet parentPreference) {
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            Optional probeHashComputation = HashGenerationOptimizer.computeHash(Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe), this.functionAndTypeManager);
            PlanWithProperties probe = this.planAndEnforce(node.getProbeSource(), new HashComputationSet(probeHashComputation), true, new HashComputationSet(probeHashComputation));
            VariableReferenceExpression probeHashVariable = probe.getRequiredHashVariable((HashComputation)probeHashComputation.get());
            Optional indexHashComputation = HashGenerationOptimizer.computeHash(Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex), this.functionAndTypeManager);
            HashComputationSet requiredHashes = new HashComputationSet(indexHashComputation);
            PlanWithProperties index = this.planAndEnforce(node.getIndexSource(), requiredHashes, true, requiredHashes);
            VariableReferenceExpression indexHashVariable = index.getRequiredHashVariable((HashComputation)indexHashComputation.get());
            HashMap<HashComputation, VariableReferenceExpression> allHashVariables = new HashMap<HashComputation, VariableReferenceExpression>();
            if (node.getType() == IndexJoinNode.Type.INNER) {
                allHashVariables.putAll((Map<HashComputation, VariableReferenceExpression>)probe.getHashVariables());
            }
            allHashVariables.putAll((Map<HashComputation, VariableReferenceExpression>)index.getHashVariables());
            return new PlanWithProperties(new IndexJoinNode(node.getSourceLocation(), node.getId(), node.getType(), probe.getNode(), index.getNode(), node.getCriteria(), Optional.of(probeHashVariable), Optional.of(indexHashVariable)), allHashVariables);
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, HashComputationSet parentPreference) {
            if (node.getPartitionBy().isEmpty()) {
                return this.planSimpleNodeWithProperties(node, parentPreference, true);
            }
            Optional hashComputation = HashGenerationOptimizer.computeHash(node.getPartitionBy(), this.functionAndTypeManager);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), true, parentPreference.withHashComputation(node, hashComputation));
            VariableReferenceExpression hashSymbol = child.getRequiredHashVariable((HashComputation)hashComputation.get());
            return new PlanWithProperties(new WindowNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getSpecification(), node.getWindowFunctions(), Optional.of(hashSymbol), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix()), (Map<HashComputation, VariableReferenceExpression>)child.getHashVariables());
        }

        @Override
        public PlanWithProperties visitExchange(ExchangeNode node, HashComputationSet parentPreference) {
            HashComputationSet preference = parentPreference.pruneVariables(node.getOutputVariables());
            Optional partitionVariables = Optional.empty();
            PartitioningScheme partitioningScheme = node.getPartitioningScheme();
            if (partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION)) {
                if (partitioningScheme.getPartitioning().getArguments().stream().allMatch(VariableReferenceExpression.class::isInstance)) {
                    partitionVariables = HashGenerationOptimizer.computeHash((Iterable)partitioningScheme.getPartitioning().getArguments().stream().map(VariableReferenceExpression.class::cast).collect(ImmutableList.toImmutableList()), this.functionAndTypeManager);
                    preference = preference.withHashComputation(partitionVariables);
                }
            }
            ImmutableList hashVariableOrder = ImmutableList.copyOf(preference.getHashes());
            HashMap<HashComputation, VariableReferenceExpression> newHashVariables = new HashMap<HashComputation, VariableReferenceExpression>();
            for (HashComputation preferredHashVariable : hashVariableOrder) {
                newHashVariables.put(preferredHashVariable, this.variableAllocator.newHashVariable());
            }
            partitioningScheme = new PartitioningScheme(partitioningScheme.getPartitioning(), (List<VariableReferenceExpression>)ImmutableList.builder().addAll(partitioningScheme.getOutputLayout()).addAll((Iterable)hashVariableOrder.stream().map(newHashVariables::get).collect(ImmutableList.toImmutableList())).build(), partitionVariables.map(newHashVariables::get), partitioningScheme.isReplicateNullsAndAny(), partitioningScheme.getBucketToPartition());
            ImmutableList.Builder newInputs = ImmutableList.builder();
            ImmutableList.Builder newSources = ImmutableList.builder();
            for (int sourceId = 0; sourceId < node.getSources().size(); ++sourceId) {
                PlanNode source = node.getSources().get(sourceId);
                List<VariableReferenceExpression> inputVariables = node.getInputs().get(sourceId);
                HashMap<VariableReferenceExpression, VariableReferenceExpression> outputToInputMap = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
                for (int variableId = 0; variableId < inputVariables.size(); ++variableId) {
                    outputToInputMap.put(node.getOutputVariables().get(variableId), inputVariables.get(variableId));
                }
                Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> outputToInputTranslator = variable -> Optional.of(outputToInputMap.get(variable));
                HashComputationSet sourceContext = preference.translate(outputToInputTranslator);
                PlanWithProperties child = this.planAndEnforce(source, sourceContext, true, sourceContext);
                newSources.add((Object)child.getNode());
                ImmutableList.Builder newInputVariables = ImmutableList.builder();
                newInputVariables.addAll(inputVariables);
                for (HashComputation preferredHashSymbol : hashVariableOrder) {
                    HashComputation hashComputation = preferredHashSymbol.translate(outputToInputTranslator).get();
                    newInputVariables.add((Object)child.getRequiredHashVariable(hashComputation));
                }
                newInputs.add((Object)newInputVariables.build());
            }
            return new PlanWithProperties(new ExchangeNode(node.getSourceLocation(), node.getId(), node.getType(), node.getScope(), partitioningScheme, (List<PlanNode>)newSources.build(), (List<List<VariableReferenceExpression>>)newInputs.build(), node.isEnsureSourceOrdering(), node.getOrderingScheme()), newHashVariables);
        }

        public PlanWithProperties visitUnion(UnionNode node, HashComputationSet parentPreference) {
            HashComputationSet preference = parentPreference.pruneVariables(node.getOutputVariables());
            HashMap<HashComputation, VariableReferenceExpression> newHashVariables = new HashMap<HashComputation, VariableReferenceExpression>();
            for (HashComputation preferredHashSymbol : preference.getHashes()) {
                newHashVariables.put(preferredHashSymbol, this.variableAllocator.newHashVariable());
            }
            ImmutableListMultimap.Builder newVariableMapping = ImmutableListMultimap.builder();
            node.getVariableMapping().forEach((arg_0, arg_1) -> ((ImmutableListMultimap.Builder)newVariableMapping).putAll(arg_0, arg_1));
            ImmutableList.Builder newSources = ImmutableList.builder();
            for (int sourceId = 0; sourceId < node.getSources().size(); ++sourceId) {
                HashMap outputToInputMap = new HashMap();
                for (VariableReferenceExpression outputVariables : node.getOutputVariables()) {
                    outputToInputMap.put(outputVariables, ((List)node.getVariableMapping().get(outputVariables)).get(sourceId));
                }
                Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> outputToInputTranslator = variable -> Optional.of(outputToInputMap.get(variable));
                HashComputationSet sourcePreference = preference.translate(outputToInputTranslator);
                PlanWithProperties child = this.planAndEnforce((PlanNode)node.getSources().get(sourceId), sourcePreference, true, sourcePreference);
                newSources.add((Object)child.getNode());
                for (Map.Entry entry : newHashVariables.entrySet()) {
                    HashComputation hashComputation = ((HashComputation)entry.getKey()).translate(outputToInputTranslator).get();
                    newVariableMapping.put(entry.getValue(), (Object)child.getRequiredHashVariable(hashComputation));
                }
            }
            ImmutableListMultimap outputsToInputs = newVariableMapping.build();
            return new PlanWithProperties((PlanNode)new UnionNode(node.getSourceLocation(), node.getId(), (List)newSources.build(), (List)ImmutableList.copyOf((Collection)outputsToInputs.keySet()), SetOperationNodeUtils.fromListMultimap((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)outputsToInputs)), newHashVariables);
        }

        public PlanWithProperties visitProject(ProjectNode node, HashComputationSet parentPreference) {
            Map outputToInputMapping = HashGenerationOptimizer.computeIdentityTranslations(node.getAssignments().getMap());
            HashComputationSet sourceContext = parentPreference.translate(variable -> Optional.ofNullable(outputToInputMapping.get(variable)));
            PlanWithProperties child = this.plan(node.getSource(), sourceContext);
            Assignments.Builder newAssignments = Assignments.builder();
            newAssignments.putAll(node.getAssignments());
            HashMap<VariableReferenceExpression, VariableReferenceExpression> hashAssignments = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            HashMap<HashComputation, VariableReferenceExpression> allHashVariables = new HashMap<HashComputation, VariableReferenceExpression>();
            for (HashComputation hashComputation : sourceContext.getHashes()) {
                VariableReferenceExpression hashExpression;
                VariableReferenceExpression hashVariable = (VariableReferenceExpression)child.getHashVariables().get((Object)hashComputation);
                if (hashVariable == null) {
                    hashVariable = this.variableAllocator.newHashVariable();
                    hashExpression = hashComputation.getHashExpression();
                } else {
                    hashExpression = hashVariable;
                }
                hashAssignments.put(hashVariable, hashExpression);
                allHashVariables.put(hashComputation, hashVariable);
            }
            if (node.getLocality().equals((Object)ProjectNode.Locality.REMOTE) && !hashAssignments.isEmpty()) {
                Assignments.Builder localProjectionAssignments = Assignments.builder();
                child.getNode().getOutputVariables().forEach(variable -> localProjectionAssignments.put(variable, (RowExpression)variable));
                localProjectionAssignments.putAll(hashAssignments);
                ProjectNode localProjectNode = new ProjectNode(child.getNode().getSourceLocation(), this.idAllocator.getNextId(), child.getNode(), localProjectionAssignments.build(), ProjectNode.Locality.LOCAL);
                hashAssignments.keySet().forEach(variable -> newAssignments.put(variable, (RowExpression)variable));
                return new PlanWithProperties((PlanNode)new ProjectNode(localProjectNode.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)localProjectNode, newAssignments.build(), ProjectNode.Locality.REMOTE), allHashVariables);
            }
            newAssignments.putAll(hashAssignments);
            return new PlanWithProperties((PlanNode)new ProjectNode(node.getSourceLocation(), node.getId(), child.getNode(), newAssignments.build(), node.getLocality()), allHashVariables);
        }

        @Override
        public PlanWithProperties visitUnnest(UnnestNode node, HashComputationSet parentPreference) {
            PlanWithProperties child = this.plan(node.getSource(), parentPreference.pruneVariables(node.getSource().getOutputVariables()));
            HashMap<HashComputation, VariableReferenceExpression> hashVariables = new HashMap<HashComputation, VariableReferenceExpression>((Map<HashComputation, VariableReferenceExpression>)child.getHashVariables());
            hashVariables.keySet().retainAll(parentPreference.getHashes());
            return new PlanWithProperties(new UnnestNode(node.getSourceLocation(), node.getId(), child.getNode(), (List<VariableReferenceExpression>)ImmutableList.builder().addAll(node.getReplicateVariables()).addAll(hashVariables.values()).build(), node.getUnnestVariables(), node.getOrdinalityVariable()), hashVariables);
        }

        private PlanWithProperties planSimpleNodeWithProperties(PlanNode node, HashComputationSet preferredHashes) {
            return this.planSimpleNodeWithProperties(node, preferredHashes, true);
        }

        private PlanWithProperties planSimpleNodeWithProperties(PlanNode node, HashComputationSet preferredHashes, boolean alwaysPruneExtraHashVariables) {
            if (node.getSources().isEmpty()) {
                return new PlanWithProperties(node, (Map<HashComputation, VariableReferenceExpression>)ImmutableMap.of());
            }
            PlanWithProperties source = this.planAndEnforce((PlanNode)Iterables.getOnlyElement((Iterable)node.getSources()), new HashComputationSet(), alwaysPruneExtraHashVariables, preferredHashes);
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source.getNode()));
            HashMap<HashComputation, VariableReferenceExpression> hashVariables = new HashMap<HashComputation, VariableReferenceExpression>((Map<HashComputation, VariableReferenceExpression>)source.getHashVariables());
            hashVariables.values().retainAll(result.getOutputVariables());
            return new PlanWithProperties(result, hashVariables);
        }

        private PlanWithProperties planAndEnforce(PlanNode node, HashComputationSet requiredHashes, boolean pruneExtraHashVariables, HashComputationSet preferredHashes) {
            boolean preferenceSatisfied;
            PlanWithProperties result = this.plan(node, preferredHashes);
            if (pruneExtraHashVariables) {
                Set resultHashes = result.getHashVariables().keySet();
                ImmutableSet requiredAndPreferredHashes = ImmutableSet.builder().addAll(requiredHashes.getHashes()).addAll(preferredHashes.getHashes()).build();
                preferenceSatisfied = resultHashes.containsAll(requiredHashes.getHashes()) && requiredAndPreferredHashes.containsAll(resultHashes);
            } else {
                preferenceSatisfied = result.getHashVariables().keySet().containsAll(requiredHashes.getHashes());
            }
            if (preferenceSatisfied) {
                return result;
            }
            return this.enforce(result, requiredHashes);
        }

        private PlanWithProperties enforce(PlanWithProperties planWithProperties, HashComputationSet requiredHashes) {
            Assignments.Builder assignments = Assignments.builder();
            HashMap<HashComputation, VariableReferenceExpression> outputHashVariables = new HashMap<HashComputation, VariableReferenceExpression>();
            BiMap resultHashVariables = planWithProperties.getHashVariables().inverse();
            for (VariableReferenceExpression variable : planWithProperties.getNode().getOutputVariables()) {
                HashComputation partitionVariables = (HashComputation)resultHashVariables.get(variable);
                if (partitionVariables != null && !requiredHashes.getHashes().contains(partitionVariables)) continue;
                assignments.put(variable, (RowExpression)variable);
                if (partitionVariables == null) continue;
                outputHashVariables.put(partitionVariables, (VariableReferenceExpression)planWithProperties.getHashVariables().get((Object)partitionVariables));
            }
            for (HashComputation hashComputation : requiredHashes.getHashes()) {
                if (planWithProperties.getHashVariables().containsKey((Object)hashComputation)) continue;
                RowExpression hashExpression = hashComputation.getHashExpression();
                VariableReferenceExpression hashVariable = this.variableAllocator.newHashVariable();
                assignments.put(hashVariable, hashExpression);
                outputHashVariables.put(hashComputation, hashVariable);
            }
            ProjectNode projectNode = new ProjectNode(planWithProperties.node.getSourceLocation(), this.idAllocator.getNextId(), planWithProperties.getNode(), assignments.build(), ProjectNode.Locality.LOCAL);
            return new PlanWithProperties((PlanNode)projectNode, outputHashVariables);
        }

        private PlanWithProperties plan(PlanNode node, HashComputationSet parentPreference) {
            PlanWithProperties result = (PlanWithProperties)node.accept((PlanVisitor)this, (Object)parentPreference);
            Preconditions.checkState((boolean)result.getNode().getOutputVariables().containsAll(result.getHashVariables().values()), (String)"Node %s declares hash variables not in the output", (Object)result.getNode().getClass().getSimpleName());
            return result;
        }
    }
}

