/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Optional;

public class TransformUncorrelatedInPredicateSubqueryToSemiJoin
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode().with(Pattern.empty(Patterns.Apply.correlation()));

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
        if (applyNode.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        Expression expression = OriginalExpressionUtils.castToExpression((RowExpression)Iterables.getOnlyElement((Iterable)applyNode.getSubqueryAssignments().getExpressions()));
        if (!(expression instanceof InPredicate)) {
            return Rule.Result.empty();
        }
        InPredicate inPredicate = (InPredicate)expression;
        VariableReferenceExpression semiJoinVariable = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)applyNode.getSubqueryAssignments().getVariables());
        SemiJoinNode replacement = new SemiJoinNode(applyNode.getSourceLocation(), context.getIdAllocator().getNextId(), applyNode.getInput(), applyNode.getSubquery(), context.getVariableAllocator().toVariableReference(inPredicate.getValue()), context.getVariableAllocator().toVariableReference(inPredicate.getValueList()), semiJoinVariable, Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        return Rule.Result.ofPlanNode(replacement);
    }
}

