/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PushProjectionThroughExchange
implements Rule<ProjectNode> {
    private static final Capture<ExchangeNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().matching(project -> !PushProjectionThroughExchange.isSymbolToSymbolProjection(project)).with(Patterns.source().matching(Patterns.exchange().capturedAs(CHILD)));

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        ExchangeNode exchange = (ExchangeNode)((Object)captures.get(CHILD));
        Set<VariableReferenceExpression> partitioningColumns = exchange.getPartitioningScheme().getPartitioning().getVariableReferences();
        ImmutableList.Builder newSourceBuilder = ImmutableList.builder();
        ImmutableList.Builder inputsBuilder = ImmutableList.builder();
        for (int i = 0; i < exchange.getSources().size(); ++i) {
            Map<VariableReferenceExpression, VariableReferenceExpression> outputToInputMap = PushProjectionThroughExchange.extractExchangeOutputToInput(exchange, i);
            Assignments.Builder projections = Assignments.builder();
            ImmutableList.Builder inputs = ImmutableList.builder();
            partitioningColumns.stream().map(outputToInputMap::get).forEach(variable -> {
                projections.put(variable, (RowExpression)variable);
                inputs.add(variable);
            });
            if (exchange.getPartitioningScheme().getHashColumn().isPresent()) {
                VariableReferenceExpression hashVariable = exchange.getPartitioningScheme().getHashColumn().get();
                projections.put(hashVariable, (RowExpression)hashVariable);
                inputs.add((Object)hashVariable);
            }
            if (exchange.getOrderingScheme().isPresent()) {
                exchange.getOrderingScheme().get().getOrderByVariables().stream().filter(variable -> !partitioningColumns.contains(variable)).map(outputToInputMap::get).forEach(variable -> {
                    projections.put(variable, (RowExpression)variable);
                    inputs.add(variable);
                });
            }
            for (Map.Entry projection : project.getAssignments().entrySet()) {
                RowExpression translatedExpression = RowExpressionVariableInliner.inlineVariables((Map<VariableReferenceExpression, ? extends RowExpression>)outputToInputMap, (RowExpression)projection.getValue());
                VariableReferenceExpression variable2 = context.getVariableAllocator().newVariable(translatedExpression);
                projections.put(variable2, translatedExpression);
                inputs.add((Object)variable2);
            }
            newSourceBuilder.add((Object)new ProjectNode(project.getSourceLocation(), context.getIdAllocator().getNextId(), exchange.getSources().get(i), projections.build(), project.getLocality()));
            inputsBuilder.add((Object)inputs.build());
        }
        ImmutableList.Builder outputBuilder = ImmutableList.builder();
        partitioningColumns.forEach(arg_0 -> ((ImmutableList.Builder)outputBuilder).add(arg_0));
        exchange.getPartitioningScheme().getHashColumn().ifPresent(arg_0 -> ((ImmutableList.Builder)outputBuilder).add(arg_0));
        if (exchange.getOrderingScheme().isPresent()) {
            exchange.getOrderingScheme().get().getOrderByVariables().stream().filter(variable -> !partitioningColumns.contains(variable)).forEach(arg_0 -> ((ImmutableList.Builder)outputBuilder).add(arg_0));
        }
        for (Map.Entry projection : project.getAssignments().entrySet()) {
            outputBuilder.add(projection.getKey());
        }
        PartitioningScheme partitioningScheme = new PartitioningScheme(exchange.getPartitioningScheme().getPartitioning(), (List<VariableReferenceExpression>)outputBuilder.build(), exchange.getPartitioningScheme().getHashColumn(), exchange.getPartitioningScheme().isReplicateNullsAndAny(), exchange.getPartitioningScheme().getBucketToPartition());
        ExchangeNode result = new ExchangeNode(exchange.getSourceLocation(), exchange.getId(), exchange.getType(), exchange.getScope(), partitioningScheme, (List<PlanNode>)newSourceBuilder.build(), (List<List<VariableReferenceExpression>>)inputsBuilder.build(), exchange.isEnsureSourceOrdering(), exchange.getOrderingScheme());
        return Rule.Result.ofPlanNode(Util.restrictOutputs(context.getIdAllocator(), result, (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)project.getOutputVariables()), true).orElse(result));
    }

    private static boolean isSymbolToSymbolProjection(ProjectNode project) {
        return project.getAssignments().getExpressions().stream().allMatch(e -> e instanceof VariableReferenceExpression);
    }

    private static Map<VariableReferenceExpression, VariableReferenceExpression> extractExchangeOutputToInput(ExchangeNode exchange, int sourceIndex) {
        HashMap<VariableReferenceExpression, VariableReferenceExpression> outputToInputMap = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (int i = 0; i < exchange.getOutputVariables().size(); ++i) {
            outputToInputMap.put(exchange.getOutputVariables().get(i), exchange.getInputs().get(sourceIndex).get(i));
        }
        return outputToInputMap;
    }
}

