/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;

public class MergeLimitWithDistinct
implements Rule<LimitNode> {
    private static final Capture<AggregationNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.aggregation().capturedAs(CHILD).matching(MergeLimitWithDistinct::isDistinct)));

    private static boolean isDistinct(AggregationNode node) {
        return node.getAggregations().isEmpty() && node.getOutputVariables().size() == node.getGroupingKeys().size() && node.getOutputVariables().containsAll(node.getGroupingKeys());
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        AggregationNode child = (AggregationNode)captures.get(CHILD);
        return Rule.Result.ofPlanNode((PlanNode)new DistinctLimitNode(parent.getSourceLocation(), parent.getId(), child.getSource(), parent.getCount(), false, child.getGroupingKeys(), child.getHashVariable()));
    }
}

