/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TypeProvider {
    private final Map<String, Type> types;

    public static TypeProvider viewOf(Map<String, Type> types) {
        return new TypeProvider(types);
    }

    public static TypeProvider copyOf(Map<String, Type> types) {
        return new TypeProvider((Map<String, Type>)ImmutableMap.copyOf(types));
    }

    public static TypeProvider empty() {
        return new TypeProvider((Map<String, Type>)ImmutableMap.of());
    }

    public static TypeProvider fromVariables(Collection<VariableReferenceExpression> variables) {
        return new TypeProvider((Map)variables.stream().collect(ImmutableMap.toImmutableMap(VariableReferenceExpression::getName, VariableReferenceExpression::getType)));
    }

    private TypeProvider(Map<String, Type> types) {
        this.types = types;
    }

    public Type get(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        Symbol symbol = Symbol.from(expression);
        Type type = this.types.get(symbol.getName());
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"no type found found for symbol '%s'", (Object)symbol);
        return type;
    }

    public Set<VariableReferenceExpression> allVariables() {
        return (Set)this.types.entrySet().stream().map(entry -> new VariableReferenceExpression(Optional.empty(), (String)entry.getKey(), (Type)entry.getValue())).collect(ImmutableSet.toImmutableSet());
    }

    public Map<String, Type> allTypes() {
        return this.types;
    }
}

