/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PlanVariableAllocator
implements VariableAllocator {
    private static final Pattern DISALLOWED_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9_\\-$]+");
    private final Map<String, Type> variables;
    private int nextId;

    public PlanVariableAllocator() {
        this.variables = new HashMap<String, Type>();
    }

    public PlanVariableAllocator(Collection<VariableReferenceExpression> initial) {
        this.variables = Objects.requireNonNull(initial, "initial is null").stream().collect(Collectors.toMap(VariableReferenceExpression::getName, VariableReferenceExpression::getType));
    }

    public VariableReferenceExpression newVariable(VariableReferenceExpression variableHint) {
        Preconditions.checkArgument((boolean)this.variables.containsKey(variableHint.getName()), (Object)"variableHint name not in variables map");
        return this.newVariable((Optional<SourceLocation>)variableHint.getSourceLocation(), variableHint.getName(), variableHint.getType());
    }

    public VariableReferenceExpression newVariable(Optional<SourceLocation> sourceLocation, QualifiedName nameHint, Type type) {
        return this.newVariable(sourceLocation, nameHint.getSuffix(), type, null);
    }

    public VariableReferenceExpression newVariable(Optional<SourceLocation> sourceLocation, String nameHint, Type type) {
        return this.newVariable(sourceLocation, nameHint, type, null);
    }

    public VariableReferenceExpression newHashVariable() {
        return this.newVariable("$hashValue", (Type)BigintType.BIGINT);
    }

    public VariableReferenceExpression newVariable(String nameHint, Type type, String suffix) {
        return this.newVariable(Optional.empty(), nameHint, type, suffix);
    }

    public VariableReferenceExpression newVariable(Optional<SourceLocation> sourceLocation, String nameHint, Type type, String suffix) {
        String tail;
        Objects.requireNonNull(nameHint, "name is null");
        Objects.requireNonNull(type, "type is null");
        nameHint = nameHint.toLowerCase(Locale.ENGLISH);
        int index = nameHint.lastIndexOf("_");
        if (index > 0 && (Ints.tryParse((String)(tail = nameHint.substring(index + 1))) != null || index == nameHint.length() - 1)) {
            nameHint = nameHint.substring(0, index);
        }
        String unique = nameHint;
        if (suffix != null) {
            unique = unique + "$" + suffix;
        }
        String attempt = unique = DISALLOWED_CHAR_PATTERN.matcher(unique).replaceAll("_");
        while (this.variables.containsKey(attempt)) {
            attempt = unique + "_" + this.nextId();
        }
        this.variables.put(attempt, type);
        return new VariableReferenceExpression(sourceLocation, attempt, type);
    }

    public VariableReferenceExpression newVariable(Expression expression, Type type) {
        return this.newVariable(expression, type, null);
    }

    public VariableReferenceExpression newVariable(Expression expression, Type type, String suffix) {
        String nameHint = "expr";
        if (expression instanceof Identifier) {
            nameHint = ((Identifier)expression).getValue();
        } else if (expression instanceof FunctionCall) {
            nameHint = ((FunctionCall)expression).getName().getSuffix();
        } else if (expression instanceof SymbolReference) {
            nameHint = ((SymbolReference)expression).getName();
        } else if (expression instanceof GroupingOperation) {
            nameHint = "grouping";
        }
        return this.newVariable(ExpressionTreeUtils.getSourceLocation((Node)expression), nameHint, type, suffix);
    }

    public VariableReferenceExpression newVariable(Field field) {
        return this.newVariable(ExpressionTreeUtils.getSourceLocation(field.getNodeLocation()), field);
    }

    public VariableReferenceExpression newVariable(Optional<SourceLocation> sourceLocation, Field field) {
        return this.newVariable(sourceLocation, field.getName().orElse("field"), field.getType(), null);
    }

    public TypeProvider getTypes() {
        return TypeProvider.viewOf(this.variables);
    }

    private int nextId() {
        return this.nextId++;
    }

    public VariableReferenceExpression toVariableReference(Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof SymbolReference), (String)"Unexpected expression: %s", (Object)expression);
        String name = ((SymbolReference)expression).getName();
        Preconditions.checkArgument((boolean)this.variables.containsKey(name), (String)"variable map does not contain name %s", (Object)name);
        return new VariableReferenceExpression(ExpressionTreeUtils.getSourceLocation((Node)expression), name, this.variables.get(name));
    }

    public VariableReferenceExpression newVariable(RowExpression expression) {
        return this.newVariable(expression, null);
    }

    public VariableReferenceExpression newVariable(RowExpression expression, String suffix) {
        String nameHint = "expr";
        if (expression instanceof VariableReferenceExpression) {
            nameHint = ((VariableReferenceExpression)expression).getName();
        } else if (expression instanceof CallExpression) {
            nameHint = ((CallExpression)expression).getDisplayName();
        }
        return this.newVariable(expression.getSourceLocation(), nameHint, expression.getType(), suffix);
    }
}

