/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.CanonicalPartitioningScheme;
import com.facebook.presto.sql.planner.CanonicalTableScanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class CanonicalPlanFragment {
    private final PlanNode plan;
    private final CanonicalPartitioningScheme partitioningScheme;

    @JsonCreator
    public CanonicalPlanFragment(@JsonProperty(value="plan") PlanNode plan, @JsonProperty(value="partitionScheme") CanonicalPartitioningScheme partitioningScheme) {
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
    }

    @JsonProperty
    public PlanNode getPlan() {
        return this.plan;
    }

    @JsonProperty
    public CanonicalPartitioningScheme getPartitioningScheme() {
        return this.partitioningScheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalPlanFragment that = (CanonicalPlanFragment)o;
        return Objects.equals(this.plan, that.plan) && Objects.equals(this.partitioningScheme, that.partitioningScheme);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.partitioningScheme);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("plan", (Object)this.plan).add("partitioningScheme", (Object)this.partitioningScheme).toString();
    }

    public CanonicalPlanFragment updateRuntimeInformation(ConnectorSplit split) {
        return new CanonicalPlanFragment(SimplePlanRewriter.rewriteWith(new RuntimeInformationRewriter(split), this.plan), this.partitioningScheme);
    }

    private static class RuntimeInformationRewriter
    extends SimplePlanRewriter<Void> {
        private final ConnectorSplit split;

        public RuntimeInformationRewriter(ConnectorSplit split) {
            this.split = Objects.requireNonNull(split, "split is null");
        }

        @Override
        public PlanNode visitCanonicalTableScan(CanonicalTableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            CanonicalTableScanNode.CanonicalTableHandle originalTableHandle = node.getTable();
            Optional<Object> newLayoutIdentifier = originalTableHandle.getLayoutHandle().map(handle -> handle.getIdentifier(Optional.of(this.split)));
            return new CanonicalTableScanNode(node.getSourceLocation(), node.getId(), new CanonicalTableScanNode.CanonicalTableHandle(originalTableHandle.getConnectorId(), originalTableHandle.getTableHandle(), newLayoutIdentifier), node.getOutputVariables(), node.getAssignments());
        }
    }
}

